/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import mobileapplication3.editor.EditorSettings;
import mobileapplication3.editor.MainMenu;
import mobileapplication3.editor.setup.SetupWizard;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.UISettings;

public class Editor {
    public Editor() {
        Editor.startEditor();
    }

    public static void startEditor() {
        try {
            RootContainer.setUISettings(new UISettings(){

                @Override
                public boolean getKeyRepeatedInListsEnabled() {
                    return EditorSettings.getKeyRepeatedInListsEnabled(false);
                }

                @Override
                public boolean getKbSmoothScrollingEnabled() {
                    return EditorSettings.getKbSmoothScrollingEnabled(true);
                }

                @Override
                public boolean getKineticTouchScrollingEnabled() {
                    return EditorSettings.getKineticScrollingEnabled(true);
                }

                @Override
                public boolean getTransparencyEnabled() {
                    return EditorSettings.getTransparencyEnabled(false);
                }

                @Override
                public boolean showKbHints() {
                    return RootContainer.displayKbHints;
                }

                @Override
                public boolean enableOnScreenLog() {
                    return EditorSettings.getOnScreenLogEnabled(false);
                }

                @Override
                public void onChange() {
                    try {
                        RootContainer.init();
                    }
                    catch (Exception ex) {
                        Logger.log(ex);
                    }
                }
            });
            if (EditorSettings.isSetupWizardCompleted()) {
                RootContainer.setRootUIComponent(new MainMenu(RootContainer.getInst()));
            } else {
                RootContainer.setRootUIComponent(new SetupWizard(new SetupWizard.FinishSetup(){

                    @Override
                    public void onFinish() {
                        RootContainer.setRootUIComponent(new MainMenu(RootContainer.getInst()));
                    }
                }));
            }
        }
        catch (Exception ex) {
            Platform.showError(ex);
        }
    }
}

