/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import mobileapplication3.editor.StructureBuilder;
import mobileapplication3.editor.StructureViewerComponent;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;

public class EditorCanvas
extends StructureViewerComponent {
    public static final int MODE_STRUCTURE = 1;
    public static final int MODE_LEVEL = 2;
    private static final int COL_BG = 0;
    private int cursorX;
    private int cursorY;
    private int gridStep;
    private int keyRepeats = 0;
    public int selectedElement = 0;
    private int zoomOutMacroModeThreshold = 200;
    private final int editMode;
    private boolean viewMode;
    private final StructureBuilder structureBuilder;
    private final PointerHandler pointerHandler = new PointerHandler();
    private final Car car = new Car();

    public EditorCanvas(StructureBuilder structureBuilder, boolean viewMode) {
        super(structureBuilder.getElementsAsArray());
        this.structureBuilder = structureBuilder;
        this.editMode = structureBuilder.getMode();
        this.viewMode = viewMode;
    }

    public void onUpdate() {
        this.setElements(this.structureBuilder.getElementsAsArray());
    }

    @Override
    public void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (this.editMode == 1) {
            this.car.drawCar(g, x0, y0);
        }
        super.onPaint(g, x0, y0, w, h, forceInactive);
        if (this.editMode == 1) {
            this.drawStartPoint(g, x0, y0);
        }
        this.drawCursor(g, x0, y0);
        if (this.structureBuilder.placingNow != null) {
            g.setColor(0xAAFFAA);
            g.drawString(this.structureBuilder.getPlacingInfo(), x0, y0, 0);
            g.drawString("Move cursor to set the point", x0, y0 + g.getFontHeight(), 0);
            g.drawString("Click to continue", x0, y0 + g.getFontHeight() * 2, 0);
        }
    }

    @Override
    public void drawBg(Graphics g, int x0, int y0, int w, int h, boolean isActive) {
        g.setColor(0);
        g.fillRect(x0, y0, w, h);
        int step = this.gridStep * 1000 / this.zoomOut;
        if (step > 10) {
            g.setColor(119);
            int gridOffsetX = y0 + w / 2 % step + this.offsetX % step;
            int gridOffsetY = x0 + h / 2 % step + this.offsetY % step;
            for (int y = gridOffsetY - step; y < h; y += step) {
                g.drawLine(0, y, w, y);
            }
            for (int x = gridOffsetX - step; x < w; x += step) {
                g.drawLine(x, 0, x, h);
            }
        }
    }

    private void drawCursor(Graphics g, int x0, int y0) {
        int x = x0 + this.xToPX(this.cursorX);
        int y = y0 + this.yToPX(this.cursorY);
        int r = 2;
        g.setColor(0x22AA22);
        g.drawArc(x - r, y - r, r * 2, r * 2, 0, 360);
        g.drawString(this.cursorX + " " + this.cursorY, x, y + r, 20);
    }

    @Override
    protected void drawElements(Graphics g, int x0, int y0, Element[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            try {
                elements[i].paint(g, this.zoomOut, x0 + this.offsetX, y0 + this.offsetY, this.zoomOut > this.zoomOutMacroModeThreshold, i == this.selectedElement);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void drawStartPoint(Graphics g, int x0, int y0) {
        int d = 2;
        g.setColor(65280);
        g.fillRect(x0 + this.xToPX(0) - d, y0 + this.yToPX(0) - d, d * 2, d * 2);
    }

    @Override
    public void onSetBounds(int x0, int y0, int w, int h) {
        this.zoomOutMacroModeThreshold = 384000 / Math.min(w, h);
        if (!this.isSizeSet()) {
            this.zoomOut = Mathh.constrain(8, 4000000 / w, 200000);
        }
        this.recalculateOffset();
    }

    @Override
    public boolean canBeFocused() {
        return true;
    }

    @Override
    protected boolean handleMouseEvent(int event, int x, int y) {
        if (event == 7) {
            this.zoomOut();
        } else if (event == -7) {
            this.zoomIn();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean handlePointerPressed(int x, int y) {
        this.pointerHandler.handlePointerPressed(x, y);
        return true;
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        this.pointerHandler.dragged = false;
        this.pointerHandler.handlePointerClicked(x, y);
        return true;
    }

    @Override
    public boolean handlePointerDragged(int x, int y) {
        this.pointerHandler.handlePointerDragged(x, y);
        return true;
    }

    @Override
    public boolean handleKeyPressed(int keyCode, int count) {
        if ((count = Math.max(count - 4, 1)) > 10) {
            count = 10;
        }
        int step = Math.max(count * count * this.gridStep, this.zoomOut / 1000 / this.gridStep * this.gridStep);
        switch (RootContainer.getAction(keyCode)) {
            case 8: {
                this.structureBuilder.handleNextPoint((short)this.cursorX, (short)this.cursorY, false);
                break;
            }
            default: {
                if (this.moveCursorByKeyboard(keyCode, step)) break;
                return false;
            }
        }
        this.pointerHandler.onCursorMove();
        this.keyRepeats = 0;
        return true;
    }

    @Override
    public boolean handleKeyRepeated(int keyCode, int pressedCount) {
        int a = Math.min(100, this.keyRepeats);
        int step = this.gridStep * (1 + a) * pressedCount;
        if (!this.moveCursorByKeyboard(keyCode, step)) {
            return false;
        }
        this.pointerHandler.onCursorMove();
        ++this.keyRepeats;
        return true;
    }

    private boolean moveCursorByKeyboard(int keyCode, int step) {
        block0 : switch (RootContainer.getAction(keyCode)) {
            case 1: {
                this.cursorY -= step;
                break;
            }
            case 6: {
                this.cursorY += step;
                break;
            }
            case 2: {
                this.cursorX -= step;
                break;
            }
            case 5: {
                this.cursorX += step;
                break;
            }
            default: {
                switch (keyCode) {
                    case 49: {
                        this.cursorX -= step;
                        this.cursorY -= step;
                        break block0;
                    }
                    case 51: {
                        this.cursorX += step;
                        this.cursorY -= step;
                        break block0;
                    }
                    case 55: {
                        this.cursorX -= step;
                        this.cursorY += step;
                        break block0;
                    }
                    case 57: {
                        this.cursorX += step;
                        this.cursorY += step;
                        break block0;
                    }
                }
                return false;
            }
        }
        this.roundToGrid();
        return true;
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public int getCursorY() {
        return this.cursorY;
    }

    @Override
    protected void setOptimalZoomAndOffset(int w, int h) {
        if (this.viewMode) {
            super.setOptimalZoomAndOffset(w, h);
        }
    }

    @Override
    protected void setZoomOut(int zoomOut) {
        zoomOut = Mathh.constrain(8, zoomOut, 200000);
        super.setZoomOut(zoomOut);
        this.gridStep = zoomOut < 200 ? 1 : (zoomOut < 600 ? 25 : (zoomOut < 2000 ? 50 : 100));
    }

    private void roundToGrid() {
        if (this.gridStep > 1) {
            this.cursorX = (this.cursorX + this.gridStep * Mathh.sign(this.cursorX) / 2) / this.gridStep * this.gridStep;
            this.cursorY = (this.cursorY + this.gridStep * Mathh.sign(this.cursorY) / 2) / this.gridStep * this.gridStep;
            if (Math.abs(this.cursorX) % 1000 == 300) {
                this.cursorX = this.cursorX > 0 ? (this.cursorX -= 8) : (this.cursorX += 8);
            }
            if (Math.abs(this.cursorY) % 1000 == 300) {
                this.cursorY = this.cursorY > 0 ? (this.cursorY -= 8) : (this.cursorY += 8);
            }
        }
    }

    void zoomIn() {
        this.setZoomOut(this.zoomOut / 2);
        this.recalculateOffset();
    }

    void zoomOut() {
        this.setZoomOut(this.zoomOut * 2);
        this.recalculateOffset();
    }

    void recalculateOffset() {
        this.offsetX = this.w / 2 - this.cursorX * 1000 / this.zoomOut;
        this.offsetY = this.h / 2 - this.cursorY * 1000 / this.zoomOut;
    }

    public int xToPX(int c) {
        return c * 1000 / this.zoomOut + this.offsetX;
    }

    public int yToPX(int c) {
        return c * 1000 / this.zoomOut + this.offsetY;
    }

    class PointerHandler {
        public boolean dragged = false;
        int pressedX;
        int pressedY;
        int prevCursorX;
        int prevCursorY;
        int prevOffsetX;
        int prevOffsetY;
        int lastCursorX = 0;
        int lastCursorY = 0;

        PointerHandler() {
        }

        void handlePointerPressed(int x, int y) {
            if (!EditorCanvas.this.isVisible) {
                return;
            }
            this.pressedX = x;
            this.pressedY = y;
            this.prevOffsetX = EditorCanvas.this.offsetX;
            this.prevOffsetY = EditorCanvas.this.offsetY;
            this.prevCursorX = EditorCanvas.this.cursorX;
            this.prevCursorY = EditorCanvas.this.cursorY;
            this.dragged = false;
        }

        void handlePointerDragged(int x, int y) {
            if (!EditorCanvas.this.isVisible) {
                return;
            }
            int dx = x - this.pressedX;
            int dy = y - this.pressedY;
            this.lastCursorX = EditorCanvas.this.cursorX;
            this.lastCursorY = EditorCanvas.this.cursorY;
            EditorCanvas.this.cursorX = this.prevCursorX + dx * EditorCanvas.this.zoomOut / 1000;
            EditorCanvas.this.cursorY = this.prevCursorY + dy * EditorCanvas.this.zoomOut / 1000;
            if (EditorCanvas.this.gridStep > 1) {
                EditorCanvas.this.cursorX = EditorCanvas.this.cursorX / EditorCanvas.this.gridStep * EditorCanvas.this.gridStep;
                EditorCanvas.this.cursorY = EditorCanvas.this.cursorY / EditorCanvas.this.gridStep * EditorCanvas.this.gridStep;
            }
            EditorCanvas.this.roundToGrid();
            this.onCursorMove();
            this.dragged = this.dragged || dx != 0 || dy != 0;
        }

        void handlePointerClicked(int x, int y) {
            if (!EditorCanvas.this.isVisible) {
                return;
            }
            if (!this.dragged) {
                EditorCanvas.this.structureBuilder.handleNextPoint((short)EditorCanvas.this.cursorX, (short)EditorCanvas.this.cursorY, false);
            }
        }

        void onCursorMove() {
            if (this.lastCursorX != EditorCanvas.this.cursorX || this.lastCursorY != EditorCanvas.this.cursorY) {
                Platform.vibrate(1);
            }
            EditorCanvas.this.recalculateOffset();
            EditorCanvas.this.structureBuilder.handleNextPoint((short)EditorCanvas.this.cursorX, (short)EditorCanvas.this.cursorY, true);
        }
    }

    class Car {
        int carBodyLength = 240;
        int carBodyHeight = 40;
        int wr = 40;
        int carX = 0 - (this.carBodyLength / 2 - this.wr);
        int carY = 0 - this.wr / 2 * 3 - 2;

        Car() {
        }

        void drawCar(Graphics g, int x0, int y0) {
            if (EditorCanvas.this.zoomOut < EditorCanvas.this.zoomOutMacroModeThreshold) {
                return;
            }
            g.setColor(0x444444);
            g.drawRect(x0 + EditorCanvas.this.xToPX(this.carX - this.carBodyLength / 2), y0 + EditorCanvas.this.yToPX(this.carY - this.carBodyHeight / 2), this.carBodyLength * 1000 / EditorCanvas.this.zoomOut, this.carBodyHeight * 1000 / EditorCanvas.this.zoomOut);
            int lwX = x0 + EditorCanvas.this.xToPX(this.carX - (this.carBodyLength / 2 - this.wr));
            int lwY = y0 + EditorCanvas.this.yToPX(this.carY + this.wr / 2);
            int rwX = x0 + EditorCanvas.this.xToPX(this.carX + (this.carBodyLength / 2 - this.wr));
            int rwY = y0 + EditorCanvas.this.yToPX(this.carY + this.wr / 2);
            int wrScaled = this.wr * 1000 / EditorCanvas.this.zoomOut;
            g.setColor(0);
            g.fillArc(lwX - wrScaled, lwY - wrScaled, wrScaled * 2, wrScaled * 2, 0, 360);
            g.fillArc(rwX - wrScaled, rwY - wrScaled, wrScaled * 2, wrScaled * 2, 0, 360);
            g.setColor(0x444444);
            g.drawArc(lwX - wrScaled, lwY - wrScaled, wrScaled * 2, wrScaled * 2, 0, 360);
            g.drawArc(rwX - wrScaled, rwY - wrScaled, wrScaled * 2, wrScaled * 2, 0, 360);
            int lineEndX = this.carX - this.carBodyLength / 2 - this.wr / 2;
            int lineStartX = lineEndX - this.wr;
            int lineY = this.carY + this.carBodyHeight / 3;
            g.drawLine(x0 + EditorCanvas.this.xToPX(lineStartX), y0 + EditorCanvas.this.yToPX(lineY), x0 + EditorCanvas.this.xToPX(lineEndX), y0 + EditorCanvas.this.yToPX(lineY));
            g.drawLine(x0 + EditorCanvas.this.xToPX(lineStartX += this.carBodyHeight / 3), y0 + EditorCanvas.this.yToPX(lineY += this.carBodyHeight / 3), x0 + EditorCanvas.this.xToPX(lineEndX += this.carBodyHeight / 3), y0 + EditorCanvas.this.yToPX(lineY));
            g.drawLine(x0 + EditorCanvas.this.xToPX(lineStartX -= this.carBodyHeight * 2 / 3), y0 + EditorCanvas.this.yToPX(lineY -= this.carBodyHeight * 2 / 3), x0 + EditorCanvas.this.xToPX(lineEndX -= this.carBodyHeight * 2 / 3), y0 + EditorCanvas.this.yToPX(lineY));
        }
    }
}

