/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import mobileapplication3.editor.AutoSaveUI;
import mobileapplication3.editor.EditorSettings;
import mobileapplication3.editor.EditorUI;
import mobileapplication3.editor.MainMenu;
import mobileapplication3.editor.MoveAllElements;
import mobileapplication3.editor.PathPicker;
import mobileapplication3.game.GameplayCanvas;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.AbstractPopupPage;
import mobileapplication3.ui.BackButton;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonCol;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;

public class EditorQuickMenu
extends AbstractPopupPage {
    private final EditorUI parent;

    public EditorQuickMenu(EditorUI parent) {
        super(parent.getFileName(), parent);
        this.parent = parent;
    }

    @Override
    protected Button[] getActionButtons() {
        return new Button[]{new BackButton(this.parent)};
    }

    @Override
    protected IUIComponent initAndGetPageContent() {
        return new ButtonCol(this.getButtons());
    }

    private Button[] getButtons() {
        boolean gameIncluded = false;
        try {
            Class.forName("mobileapplication3.game.GameplayCanvas");
            gameIncluded = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Button levelTestButton = new Button("Open this level in the game"){

            @Override
            public void buttonPressed() {
                RootContainer.setRootUIComponent(new GameplayCanvas(EditorQuickMenu.this.parent).loadLevel(EditorQuickMenu.this.parent.getData()).disablePointCounter());
            }
        }.setBgColor(0x112211).setSelectedColor(0x115511).setIsActive(gameIncluded).setBindedKeyCode(49);
        Button structureTestButton = new Button("Test this structure in the game"){

            @Override
            public void buttonPressed() {
                RootContainer.setRootUIComponent(new GameplayCanvas(EditorQuickMenu.this.parent).addDeferredStructure(EditorQuickMenu.this.parent.getData()).disablePointCounter());
            }
        }.setBgColor(0x112211).setSelectedColor(0x115511).setIsActive(gameIncluded).setBindedKeyCode(49);
        Button saveButton = new Button("Save \"" + this.parent.getFileName() + "\""){

            @Override
            public void buttonPressed() {
                EditorQuickMenu.this.close();
                try {
                    EditorQuickMenu.this.parent.saveToFile(EditorQuickMenu.this.parent.getFilePath());
                    AutoSaveUI.deleteAutoSave(EditorQuickMenu.this.parent.getMode());
                }
                catch (Exception ex) {
                    Logger.log(ex);
                    Platform.showError(ex);
                }
            }
        }.setBindedKeyCode(56).setIsActive(this.parent.getFilePath() != null);
        Button saveAsButton = new Button("Save as..."){

            @Override
            public void buttonPressed() {
                EditorQuickMenu.this.close();
                final int mode = EditorQuickMenu.this.parent.getMode();
                String path = mode == 1 ? EditorSettings.getStructsFolderPath() : EditorSettings.getLevelsFolderPath();
                EditorQuickMenu.this.parent.showPopup(new PathPicker(mode, (IPopupFeedback)EditorQuickMenu.this.parent).pickFolder(path, "Save as \".curr_folder.\" ?", new PathPicker.Feedback(){

                    @Override
                    public void onComplete(final String path) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Logger.log("Saving to " + path);
                                    EditorQuickMenu.this.parent.saveToFile(path);
                                    Logger.log("Saved!");
                                    AutoSaveUI.deleteAutoSave(mode);
                                    EditorQuickMenu.this.parent.setFilePath(path);
                                    EditorQuickMenu.this.parent.closePopup();
                                }
                                catch (Exception ex) {
                                    Logger.log(ex);
                                    Platform.showError(ex);
                                }
                                EditorQuickMenu.this.repaint();
                            }
                        }).start();
                    }

                    @Override
                    public void onCancel() {
                        EditorQuickMenu.this.parent.closePopup();
                    }
                }));
            }
        }.setBindedKeyCode(57);
        Button moveElementsButton = new Button(MoveAllElements.getName()){

            @Override
            public void buttonPressed() {
                EditorQuickMenu.this.showPopup(new MoveAllElements(EditorQuickMenu.this, ((EditorQuickMenu)EditorQuickMenu.this).parent.elementsBuffer.getElementsAsArray()));
            }
        };
        Button convertButton = new Button("Convert to " + (this.parent.getMode() == 1 ? "level" : "structure")){

            @Override
            public void buttonPressed() {
                EditorQuickMenu.this.parent.setMode(EditorQuickMenu.this.parent.getMode() == 1 ? 2 : 1);
                EditorQuickMenu.this.close();
            }
        };
        Button menuButton = new Button("Open Menu"){

            @Override
            public void buttonPressed() {
                RootContainer.setRootUIComponent(new MainMenu(RootContainer.getInst()));
            }
        }.setBindedKeyCode(53).setBgColor(0x222200);
        Button[] buttons = null;
        if (this.parent.getMode() == 1) {
            buttons = new Button[]{structureTestButton, saveButton, saveAsButton, moveElementsButton, convertButton, menuButton};
        } else if (this.parent.getMode() == 2) {
            buttons = new Button[]{levelTestButton, saveButton, saveAsButton, moveElementsButton, convertButton, menuButton};
        }
        return buttons;
    }

    @Override
    public void setPageContentBounds(IUIComponent pageContent, int x0, int y0, int w, int h) {
        if (pageContent != null) {
            ((ButtonCol)pageContent).setButtonsBgPadding(this.margin / 8).setSize(w - this.margin * 2, h - this.margin * 2).setPos(x0 + w / 2, y0 + h - this.margin, 33);
        }
    }
}

