/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import mobileapplication3.platform.Settings;

public class EditorSettings {
    public static final String RECORD_STORE_SETTINGS = "editorsettings";
    public static final String IS_SETUP_WIZARD_COMPLETED = "setupDone";
    public static final String GAME_FOLDER_PATH = "MGPath";
    public static final String KB_SMOOTH_SCROLLING = "kbSmScrl";
    public static final String TRANSPARENCY = "trnspcy";
    public static final String LISTS_KEY_REPEATS = "listKRepeats";
    public static final String AUTO_SAVE = "autoSave";
    public static final String WHAT_TO_LOAD_AUTOMATICALLY = "alwLoad";
    public static final String SHOW_LOG = "showLog";
    public static final String KINETIC_SCROLL = "knScrl";
    public static final int OPTION_ALWAYS_LOAD_NONE = 0;
    public static final int OPTION_ALWAYS_LOAD_LIST = 1;
    public static final int OPTION_ALWAYS_LOAD_THUMBNAILS = 2;
    private static String gameFolderPath = null;
    private static int whatToLoadAutomatically = -1;
    private static Settings settingsInst = null;

    public static void resetSettings() {
        EditorSettings.getSettingsInst().resetSettings();
    }

    private static Settings getSettingsInst() {
        if (settingsInst == null) {
            settingsInst = new Settings(new String[]{IS_SETUP_WIZARD_COMPLETED, GAME_FOLDER_PATH, KB_SMOOTH_SCROLLING, TRANSPARENCY, LISTS_KEY_REPEATS, AUTO_SAVE, WHAT_TO_LOAD_AUTOMATICALLY, SHOW_LOG, KINETIC_SCROLL}, RECORD_STORE_SETTINGS);
        }
        return settingsInst;
    }

    public static boolean getKineticScrollingEnabled() {
        return EditorSettings.getSettingsInst().getBool(KINETIC_SCROLL);
    }

    public static boolean getKineticScrollingEnabled(boolean defaultValue) {
        return EditorSettings.getSettingsInst().getBool(KINETIC_SCROLL, defaultValue);
    }

    public static void setKineticScrollingEnabled(boolean b) {
        EditorSettings.getSettingsInst().set(KINETIC_SCROLL, b);
    }

    public static boolean getOnScreenLogEnabled() {
        return EditorSettings.getSettingsInst().getBool(SHOW_LOG);
    }

    public static boolean getOnScreenLogEnabled(boolean defaultValue) {
        return EditorSettings.getSettingsInst().getBool(SHOW_LOG, defaultValue);
    }

    public static void setOnScreenLogEnabled(boolean b) {
        EditorSettings.getSettingsInst().set(SHOW_LOG, b);
    }

    public static int getWhatToLoadAutomatically() {
        if (whatToLoadAutomatically < 0) {
            whatToLoadAutomatically = EditorSettings.getSettingsInst().getInt(WHAT_TO_LOAD_AUTOMATICALLY, 0);
        }
        return whatToLoadAutomatically;
    }

    public static void setWhatToLoadAutomatically(int option) {
        EditorSettings.getSettingsInst().set(WHAT_TO_LOAD_AUTOMATICALLY, String.valueOf(option));
        whatToLoadAutomatically = option;
    }

    public static boolean getAutoSaveEnabled() {
        return EditorSettings.getSettingsInst().getBool(AUTO_SAVE);
    }

    public static boolean getAutoSaveEnabled(boolean defaultValue) {
        return EditorSettings.getSettingsInst().getBool(AUTO_SAVE, defaultValue);
    }

    public static void setAutoSaveEnabled(boolean b) {
        EditorSettings.getSettingsInst().set(AUTO_SAVE, b);
    }

    public static boolean toggleAutoSaveEnabled() {
        return EditorSettings.getSettingsInst().toggleBool(AUTO_SAVE);
    }

    public static boolean getKeyRepeatedInListsEnabled() {
        return EditorSettings.getSettingsInst().getBool(LISTS_KEY_REPEATS);
    }

    public static boolean getKeyRepeatedInListsEnabled(boolean defaultValue) {
        return EditorSettings.getSettingsInst().getBool(LISTS_KEY_REPEATS, defaultValue);
    }

    public static void setKeyRepeatedInListsEnabled(boolean b) {
        EditorSettings.getSettingsInst().set(LISTS_KEY_REPEATS, b);
    }

    public static boolean toggleKeyRepeatedInListsEnabled() {
        return EditorSettings.getSettingsInst().toggleBool(LISTS_KEY_REPEATS);
    }

    public static boolean getTransparencyEnabled() {
        return EditorSettings.getSettingsInst().getBool(TRANSPARENCY);
    }

    public static boolean getTransparencyEnabled(boolean defaultValue) {
        return EditorSettings.getSettingsInst().getBool(TRANSPARENCY, defaultValue);
    }

    public static void setTransparencyEnabled(boolean b) {
        EditorSettings.getSettingsInst().set(TRANSPARENCY, b);
    }

    public static boolean toggleTransparency() {
        return EditorSettings.getSettingsInst().toggleBool(TRANSPARENCY);
    }

    public static boolean getKbSmoothScrollingEnabled() {
        return EditorSettings.getSettingsInst().getBool(KB_SMOOTH_SCROLLING);
    }

    public static boolean getKbSmoothScrollingEnabled(boolean defaultValue) {
        return EditorSettings.getSettingsInst().getBool(KB_SMOOTH_SCROLLING, defaultValue);
    }

    public static void setKbSmoothScrollingEnabled(boolean b) {
        EditorSettings.getSettingsInst().set(KB_SMOOTH_SCROLLING, b);
    }

    public static String getLevelsFolderPath() {
        return EditorSettings.getLevelsFolderPath(EditorSettings.getGameFolderPath());
    }

    public static String getLevelsFolderPath(String gameFolderPath) {
        return gameFolderPath + "Levels/";
    }

    public static String getStructsFolderPath() {
        return EditorSettings.getStructsFolderPath(EditorSettings.getGameFolderPath());
    }

    public static String getStructsFolderPath(String gameFolderPath) {
        return gameFolderPath + "MGStructs/";
    }

    public static String getGameFolderPath() {
        if (gameFolderPath == null) {
            gameFolderPath = EditorSettings.getSettingsInst().getStr(GAME_FOLDER_PATH);
        }
        return gameFolderPath;
    }

    public static void setGameFolderPath(String path) {
        EditorSettings.getSettingsInst().set(GAME_FOLDER_PATH, path);
        gameFolderPath = path;
    }

    public static boolean isSetupWizardCompleted() {
        return EditorSettings.getSettingsInst().getBool(IS_SETUP_WIZARD_COMPLETED);
    }

    public static void setIsSetupWizardCompleted(boolean b) {
        EditorSettings.getSettingsInst().set(IS_SETUP_WIZARD_COMPLETED, b);
    }
}

