/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import java.io.IOException;
import mobileapplication3.editor.AutoSaveUI;
import mobileapplication3.editor.EditorCanvas;
import mobileapplication3.editor.EditorQuickMenu;
import mobileapplication3.editor.EditorSettings;
import mobileapplication3.editor.ElementEditUI;
import mobileapplication3.editor.StructureBuilder;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.editor.elements.StartPoint;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.Utils;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.AbstractButtonSet;
import mobileapplication3.ui.BackButton;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonCol;
import mobileapplication3.ui.ButtonComponent;
import mobileapplication3.ui.ButtonPanelHorizontal;
import mobileapplication3.ui.ButtonRow;
import mobileapplication3.ui.Container;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.TextComponent;

public class EditorUI
extends Container {
    private static final int BUTTONS_IN_ROW = 4;
    public static final int FONT_H = Font.getDefaultFontHeight();
    public static final int BTN_H = FONT_H * 2;
    public static final int MODE_STRUCTURE = 1;
    public static final int MODE_LEVEL = 2;
    private EditorCanvas editorCanvas = null;
    private ButtonRow bottomButtonPanel = null;
    private ButtonPanelHorizontal placementButtonPanel = null;
    private ButtonCol placedElementsList = null;
    private StartPointWarning startPointWarning = null;
    public final StructureBuilder elementsBuffer;
    private boolean isAutoSaveEnabled = false;
    private int mode;
    private boolean viewMode = false;
    private boolean inited = false;

    public EditorUI(int editorMode) {
        this.mode = editorMode;
        this.elementsBuffer = new StructureBuilder(this.mode){

            @Override
            public void onUpdate() {
                try {
                    EditorUI.this.initListPanel();
                    EditorUI.this.saveToAutoSave();
                    EditorUI.this.editorCanvas.onUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        };
    }

    public EditorUI(int editorMode, Element[] elements, String path) {
        this(editorMode);
        this.elementsBuffer.setElements(elements);
        this.elementsBuffer.setFilePath(path);
    }

    @Override
    public void init() {
        this.init(false);
    }

    public void init(boolean force) {
        if (this.inited && !force) {
            return;
        }
        super.init();
        this.isAutoSaveEnabled = EditorSettings.getAutoSaveEnabled(true);
        this.initEditorCanvas();
        this.initBottomPanel();
        this.initStartPointWarning();
        this.initPlacementPanel();
        this.initListPanel();
        this.setComponents(new IUIComponent[]{this.editorCanvas, this.startPointWarning, this.placementButtonPanel, this.placedElementsList, this.bottomButtonPanel});
        this.inited = true;
    }

    @Override
    public void onSetBounds(int x0, int y0, int w, int h) {
        this.bottomButtonPanel.setButtonsBgPadding(BTN_H / 16).setSize(w, BTN_H).setPos(x0, y0 + h, 36);
        this.editorCanvas.setSize(w, h - this.bottomButtonPanel.h).setPos(x0, y0, 20);
        this.placementButtonPanel.setSizes(w, -1, BTN_H).setPos(x0, y0 + h - this.bottomButtonPanel.h, 36);
        this.placedElementsList.setSizes(w / 3, this.bottomButtonPanel.getTopY() - y0 - BTN_H / 4, FONT_H * 3).setPos(x0 + w, y0 + h - this.bottomButtonPanel.h, 40);
        if (this.startPointWarning != null) {
            this.startPointWarning.setSize(this.startPointWarning.getOptimalW(w / 3), this.startPointWarning.getOptimalH(this.bottomButtonPanel.getTopY() - y0)).setPos(this.bottomButtonPanel.getLeftX(), this.bottomButtonPanel.getTopY(), 36);
        }
    }

    @Override
    public void paint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (this.startPointWarning != null) {
            this.startPointWarning.setVisible(!StartPoint.checkStartPoint(this.elementsBuffer.getElementsAsArray()));
        }
        super.paint(g, x0, y0, w, h, forceInactive);
    }

    public String getFilePath() {
        return this.elementsBuffer.getFilePath();
    }

    public void setFilePath(String path) {
        this.elementsBuffer.setFilePath(path);
    }

    public String getFileName() {
        String path = this.getFilePath();
        String name = "Unnamed file";
        try {
            if (path != null) {
                String[] tmp = Utils.split(path, "/");
                name = tmp[tmp.length - 1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public short[][] getData() {
        return this.elementsBuffer.asShortArrays();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        String folderPath;
        this.mode = mode;
        this.elementsBuffer.setMode(mode);
        String name = this.getFileName();
        if (mode == 1) {
            folderPath = EditorSettings.getStructsFolderPath();
            name = this.changeExtension(name, ".mglvl", ".mgstruct");
        } else {
            folderPath = EditorSettings.getLevelsFolderPath();
            name = this.changeExtension(name, ".mgstruct", ".mglvl");
        }
        this.elementsBuffer.setFilePath(folderPath + name);
        this.elementsBuffer.recalculateEndPoint();
        this.init(true);
        this.onSetBounds(this.x0, this.y0, this.w, this.h);
    }

    private String changeExtension(String fileName, String oldExtension, String newExtension) {
        if (fileName.endsWith(oldExtension)) {
            return fileName.substring(0, Utils.indexOf(fileName, oldExtension, 0)) + newExtension;
        }
        return fileName;
    }

    public EditorUI setViewMode(boolean viewMode) {
        this.viewMode = viewMode;
        return this;
    }

    public void saveToFile(String path) throws SecurityException, IOException {
        this.elementsBuffer.saveToFile(path);
    }

    private void saveToAutoSave() {
        if (this.isAutoSaveEnabled && this.elementsBuffer != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AutoSaveUI.autoSaveWrite(EditorUI.this.elementsBuffer, EditorUI.this.elementsBuffer.getFilePath(), EditorUI.this.mode);
                    }
                    catch (Exception ex) {
                        Logger.log(ex);
                        Platform.showError(ex);
                    }
                }
            }).start();
        }
    }

    private void initEditorCanvas() {
        this.editorCanvas = new EditorCanvas(this.elementsBuffer, this.viewMode);
    }

    private void initBottomPanel() {
        Button[] buttonArray;
        Button placeButton = new Button("Place"){

            @Override
            public void buttonPressed() {
                EditorUI.this.placedElementsList.setVisible(false);
                EditorUI.this.placementButtonPanel.toggleIsVisible();
                EditorUI.this.placementButtonPanel.setFocused(EditorUI.this.placementButtonPanel.getIsVisible());
            }
        };
        Button menuButton = new Button("Menu"){

            @Override
            public void buttonPressed() {
                EditorUI.this.showPopup(new EditorQuickMenu(EditorUI.this));
            }
        }.setBindedKeyCode(48);
        Button zoomInButton = new Button("+"){

            @Override
            public void buttonPressed() {
                EditorUI.this.editorCanvas.zoomIn();
            }
        }.setBindedKeyCode(42);
        Button zoomOutButton = new Button("-"){

            @Override
            public void buttonPressed() {
                EditorUI.this.editorCanvas.zoomOut();
            }
        }.setBindedKeyCode(35);
        Button editButton = new Button("Edit"){

            @Override
            public void buttonPressed() {
                EditorUI.this.placementButtonPanel.setVisible(false);
                EditorUI.this.placedElementsList.toggleIsVisible();
                EditorUI.this.placedElementsList.setFocused(EditorUI.this.placedElementsList.getIsVisible());
            }
        };
        BackButton backButton = new BackButton(RootContainer.getInst());
        backButton.setTitle("Back");
        if (this.viewMode) {
            Button[] buttonArray2 = new Button[4];
            buttonArray2[0] = menuButton;
            buttonArray2[1] = zoomInButton;
            buttonArray2[2] = zoomOutButton;
            buttonArray = buttonArray2;
            buttonArray2[3] = backButton;
        } else {
            Button[] buttonArray3 = new Button[5];
            buttonArray3[0] = placeButton;
            buttonArray3[1] = menuButton;
            buttonArray3[2] = zoomInButton;
            buttonArray3[3] = zoomOutButton;
            buttonArray = buttonArray3;
            buttonArray3[4] = editButton;
        }
        Button[] bottomButtons = buttonArray;
        this.bottomButtonPanel = (ButtonRow)new ButtonRow().setButtons(bottomButtons).setButtonsBgColor(0x151535);
        this.bottomButtonPanel.bindToSoftButtons();
    }

    private void initStartPointWarning() {
        this.startPointWarning = this.mode == 1 ? (StartPointWarning)new StartPointWarning().setVisible(false) : null;
    }

    private void initPlacementPanel() {
        Button btnLine = new Button("Line"){

            @Override
            public void buttonPressed() {
                EditorUI.this.place(2, EditorUI.this.editorCanvas.getCursorX(), EditorUI.this.editorCanvas.getCursorY());
                EditorUI.this.placementButtonPanel.setVisible(false);
            }
        };
        Button btnCircle = new Button("Circle"){

            @Override
            public void buttonPressed() {
                EditorUI.this.place(3, EditorUI.this.editorCanvas.getCursorX(), EditorUI.this.editorCanvas.getCursorY());
                EditorUI.this.placementButtonPanel.setVisible(false);
            }
        };
        Button btnSine = new Button("Sine"){

            @Override
            public void buttonPressed() {
                EditorUI.this.place(6, EditorUI.this.editorCanvas.getCursorX(), EditorUI.this.editorCanvas.getCursorY());
                EditorUI.this.placementButtonPanel.setVisible(false);
            }
        };
        Button btnBrLine = new Button("Broken\nline"){

            @Override
            public void buttonPressed() {
                EditorUI.this.place(4, EditorUI.this.editorCanvas.getCursorX(), EditorUI.this.editorCanvas.getCursorY());
                EditorUI.this.placementButtonPanel.setVisible(false);
            }
        };
        Button btnBrCircle = new Button("Broken\ncircle"){

            @Override
            public void buttonPressed() {
                EditorUI.this.place(5, EditorUI.this.editorCanvas.getCursorX(), EditorUI.this.editorCanvas.getCursorY());
                EditorUI.this.placementButtonPanel.setVisible(false);
            }
        };
        Button btnAccel = new Button("Accele-\nrator"){

            @Override
            public void buttonPressed() {
                EditorUI.this.place(7, EditorUI.this.editorCanvas.getCursorX(), EditorUI.this.editorCanvas.getCursorY());
                EditorUI.this.placementButtonPanel.setVisible(false);
            }
        };
        Button btnFinish = new Button("Level-\nFinish"){

            @Override
            public void buttonPressed() {
                EditorUI.this.place(10, EditorUI.this.editorCanvas.getCursorX(), EditorUI.this.editorCanvas.getCursorY());
                EditorUI.this.placementButtonPanel.setVisible(false);
            }
        };
        Button btnTrampoline = new Button("Trampo-\nline"){

            @Override
            public void buttonPressed() {
                EditorUI.this.place(8, EditorUI.this.editorCanvas.getCursorX(), EditorUI.this.editorCanvas.getCursorY());
                EditorUI.this.placementButtonPanel.setVisible(false);
            }
        };
        Button btnLava = new Button("Lava"){

            @Override
            public void buttonPressed() {
                EditorUI.this.place(11, EditorUI.this.editorCanvas.getCursorX(), EditorUI.this.editorCanvas.getCursorY());
                EditorUI.this.placementButtonPanel.setVisible(false);
            }
        };
        Button[] placementButtons = this.mode == 1 ? new Button[]{btnLine, btnCircle, btnSine, btnBrLine, btnBrCircle.setIsActive(false), btnAccel, btnTrampoline, btnLava} : new Button[]{btnLine, btnCircle, btnSine, btnBrLine, btnBrCircle.setIsActive(false), btnAccel, btnTrampoline, btnLava, btnFinish};
        this.placementButtonPanel = (ButtonPanelHorizontal)new ButtonPanelHorizontal(placementButtons).setBtnsInRowCount(4).setIsSelectionEnabled(true).setVisible(false);
    }

    private void place(int id, int x, int y) {
        this.elementsBuffer.place((short)id, (short)x, (short)y);
        this.placedElementsList.setSelected(this.placedElementsList.getButtonCount() - 1);
    }

    private void initListPanel() {
        Element[] elements = this.elementsBuffer.getElementsAsArray();
        Logger.log("updating, " + elements.length + " elements");
        Button[] listButtons = new Button[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            final Element element = elements[i];
            listButtons[i] = new Button(elements[i].getName()){

                @Override
                public void buttonPressed() {
                }

                @Override
                public void buttonPressedSelected() {
                    EditorUI.this.placedElementsList.setVisible(false);
                    EditorUI.this.placementButtonPanel.setVisible(false);
                    EditorUI.this.showPopup(new ElementEditUI(element, EditorUI.this.elementsBuffer, EditorUI.this));
                }
            };
        }
        if (this.placedElementsList == null) {
            this.placedElementsList = new ButtonCol(){

                @Override
                public AbstractButtonSet setSelected(int selected) {
                    ((EditorUI)EditorUI.this).editorCanvas.selectedElement = selected;
                    return super.setSelected(selected);
                }
            };
        }
        this.placedElementsList.setButtons(listButtons).setSelected(Mathh.constrain(0, this.placedElementsList.getSelected(), listButtons.length - 1)).setIsSelectionVisible(true).setVisible(false);
    }

    private void moveToZeros() {
        StartPoint.moveToZeros(this.elementsBuffer.getElementsAsArray());
        this.saveToAutoSave();
    }

    class StartPointWarning
    extends Container {
        private final TextComponent message;
        private final ButtonComponent button;

        public StartPointWarning() {
            this.setBgColor(-1);
            this.message = new TextComponent("Warn: start point of the structure should be on (x,y) 0 0");
            this.message.setBgColor(-1);
            this.message.setFontColor(0xFFFF00);
            Button button = new Button("Move to 0 0"){

                @Override
                public void buttonPressed() {
                    EditorUI.this.moveToZeros();
                }
            }.setBgColor(8704);
            this.button = new ButtonComponent(button).setBindedKeyCode(55);
        }

        @Override
        public void init() {
            this.setComponents(new IUIComponent[]{this.message, this.button});
        }

        @Override
        protected void onSetBounds(int x0, int y0, int w, int h) {
            this.button.setSize(w, -1).setPos(x0, y0 + h, 36);
            this.message.setSize(w, h - this.button.getHeight()).setPos(x0, y0, 20);
        }

        public int getOptimalW(int freeSpace) {
            return Math.min(freeSpace, Font.defaultFontStringWidth(this.message.getText()) / 2);
        }

        public int getOptimalH(int freeSpace) {
            return Math.min(freeSpace, FONT_H * 10);
        }
    }
}

