/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import mobileapplication3.editor.AdvancedElementEditUI;
import mobileapplication3.editor.StructureBuilder;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.editor.elements.EndPoint;
import mobileapplication3.editor.elements.LevelStart;
import mobileapplication3.ui.AbstractPopupPage;
import mobileapplication3.ui.BackButton;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonCol;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;

public class ElementEditUI
extends AbstractPopupPage {
    private final Element element;
    private Button[] rows;
    private final StructureBuilder sb;

    public ElementEditUI(Element element, StructureBuilder sb, IPopupFeedback parent) {
        super("Edit " + element.getName(), parent);
        this.element = element;
        this.sb = sb;
    }

    @Override
    protected Button[] getActionButtons() {
        return new Button[]{new BackButton(this.feedback)};
    }

    @Override
    protected IUIComponent initAndGetPageContent() {
        int o;
        int i;
        Element.PlacementStep[] editSteps = this.element.getPlacementSteps();
        Element.PlacementStep[] extraEditSteps = this.element.getExtraEditingSteps();
        this.rows = new Button[editSteps.length + extraEditSteps.length + 3];
        for (i = 0; i < editSteps.length; ++i) {
            o = i;
            this.rows[o] = new Button(editSteps[i].getName()){

                @Override
                public void buttonPressed() {
                    ElementEditUI.this.sb.edit(ElementEditUI.this.element, o);
                    ElementEditUI.this.close();
                }
            };
        }
        for (i = 0; i < extraEditSteps.length; ++i) {
            o = i + editSteps.length;
            this.rows[o] = new Button(extraEditSteps[i].getName()){

                @Override
                public void buttonPressed() {
                    ElementEditUI.this.sb.edit(ElementEditUI.this.element, o);
                    ElementEditUI.this.close();
                }
            }.setBgColor(0x201010);
        }
        Button cloneButton = new Button("Clone"){

            @Override
            public void buttonPressed() {
                Element clone = ElementEditUI.this.element.clone();
                ElementEditUI.this.sb.add(clone);
                ElementEditUI.this.sb.edit(clone, 0);
                ElementEditUI.this.close();
            }
        };
        final ElementEditUI fb = this;
        Button advancedEditButton = new Button("AdvancedEdit"){

            @Override
            public void buttonPressed() {
                ElementEditUI.this.showPopup(new AdvancedElementEditUI(ElementEditUI.this.element, ElementEditUI.this.sb, fb));
            }
        }.setBgColor(0x222200);
        Button deleteButton = new Button("Delete element"){

            @Override
            public void buttonPressed() {
                ElementEditUI.this.sb.remove(ElementEditUI.this.element);
                ElementEditUI.this.close();
            }
        }.setBgColor(0x550000);
        if (this.element instanceof EndPoint || this.element instanceof LevelStart) {
            cloneButton.setIsActive(false);
            deleteButton.setIsActive(false);
        }
        this.rows[this.rows.length - 3] = cloneButton;
        this.rows[this.rows.length - 2] = advancedEditButton;
        this.rows[this.rows.length - 1] = deleteButton;
        return new ButtonCol(this.rows){

            @Override
            public void onSetBounds(int x0, int y0, int w, int h) {
                this.setButtonsBgPadding(this.getBtnH() / 16);
                super.onSetBounds(x0, y0, w, h);
            }
        };
    }
}

