/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import mobileapplication3.editor.About;
import mobileapplication3.editor.AutoSaveUI;
import mobileapplication3.editor.EditorSettings;
import mobileapplication3.editor.EditorUI;
import mobileapplication3.editor.LevelsMenu;
import mobileapplication3.editor.SettingsUI;
import mobileapplication3.editor.StructuresMenu;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.game.MenuCanvas;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.BackButton;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonCol;
import mobileapplication3.ui.Container;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.TextComponent;
import mobileapplication3.ui.UIComponent;

public class MainMenu
extends Container {
    private final TextComponent title;
    private final UIComponent logo;
    private final ButtonCol buttons;
    private boolean isAutoSaveEnabled = true;
    private static boolean autoSaveCheckDone = false;

    public MainMenu(IPopupFeedback parent) {
        boolean gameIncluded = false;
        try {
            Class.forName("mobileapplication3.game.MenuCanvas");
            gameIncluded = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        final MainMenu inst = this;
        this.title = new TextComponent("Mobapp Editor");
        this.logo = About.getAppLogo();
        int c = 49;
        this.buttons = new ButtonCol(new Button[]{new Button("Structures"){

            @Override
            public void buttonPressed() {
                MainMenu.this.showPopup(new StructuresMenu(inst));
            }
        }.setBgColor(0x151535).setBindedKeyCode(c++), new Button("Levels"){

            @Override
            public void buttonPressed() {
                MainMenu.this.showPopup(new LevelsMenu(inst));
            }
        }.setBgColor(0x151535).setBindedKeyCode(c++), new Button("Open Game"){

            @Override
            public void buttonPressed() {
                RootContainer.setRootUIComponent(new MenuCanvas());
            }
        }.setBgColor(0x151535).setIsActive(gameIncluded).setBindedKeyCode(c++), new Button("Settings"){

            @Override
            public void buttonPressed() {
                MainMenu.this.showPopup(new SettingsUI(inst));
            }
        }.setBindedKeyCode(c++), new Button("About"){

            @Override
            public void buttonPressed() {
                MainMenu.this.showPopup(new About(inst));
            }
        }.setBindedKeyCode(c++), new BackButton(parent).setBindedKeyCodes(new int[]{-7, 48})});
        this.setComponents(new IUIComponent[]{this.title, this.logo, this.buttons});
    }

    @Override
    public void init() {
        this.isAutoSaveEnabled = EditorSettings.getAutoSaveEnabled(true);
        super.init();
        this.checkAutoSaveStorage();
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        int margin = h / 16;
        if (w <= h) {
            this.title.setSize(w, -1).setPos(x0, y0, 20);
            this.buttons.setButtonsBgPadding(w / 128);
            this.buttons.setSizes(w / 2, h / 2, Font.getDefaultFontHeight() * 2).setPos(x0 + w / 2, y0 + h - margin, 33);
            int logoSide = Math.min(w * 3 / 4, this.buttons.getTopY() - this.title.getBottomY() - margin);
            if (logoSide < 1) {
                logoSide = 1;
            }
            this.logo.setSize(logoSide, logoSide).setPos(x0 + w / 2, (this.buttons.getTopY() + this.title.getBottomY()) / 2, 3);
            this.buttons.setSize(Math.max(w / 2, logoSide * 32 / 31), this.buttons.getHeight());
        } else {
            this.title.setSize(w, -1).setPos(x0, y0, 20);
            this.buttons.setIsSelectionEnabled(true).setButtonsBgPadding(w / 128).setSize(w / 2 - margin, h - this.title.h - margin * 2).setPos(x0 + w - margin, (this.title.getBottomY() + y0 + h) / 2, 10);
            int logoSide = Math.min(this.buttons.getWidth(), y0 + h - this.title.getBottomY() - margin * 2);
            if (logoSide < 1) {
                logoSide = 1;
            }
            this.logo.setSize(logoSide, logoSide).setPos(x0 + w / 4, (y0 + h + this.title.getBottomY()) / 2, 3);
        }
    }

    private void checkAutoSaveStorage() {
        if (!this.isAutoSaveEnabled || autoSaveCheckDone) {
            return;
        }
        try {
            Element[] elements;
            int mode;
            AutoSaveUI.AutoSaveData data = AutoSaveUI.autoSaveRead(1);
            if (data != null) {
                mode = 1;
            } else {
                data = AutoSaveUI.autoSaveRead(2);
                mode = 2;
            }
            if (data != null && (elements = data.getElements()).length > 2) {
                final String path = data.getPath();
                this.showPopup(new AutoSaveUI(this, elements){

                    @Override
                    public void onRestore() {
                        RootContainer.setRootUIComponent(new EditorUI(mode, elements, path));
                    }

                    @Override
                    public void onDelete() {
                        AutoSaveUI.deleteAutoSave(mode);
                        this.close();
                    }
                });
            }
        }
        catch (Exception ex) {
            Platform.showError("Can't restore auto-saved data:", ex);
            this.closePopup();
        }
        autoSaveCheckDone = true;
    }
}

