/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import java.io.IOException;
import java.util.Calendar;
import mobileapplication3.platform.FileUtils;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Utils;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.ui.AbstractPopupPage;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonCol;
import mobileapplication3.ui.Container;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.TextComponent;

public class PathPicker
extends AbstractPopupPage {
    public static final String STRUCTURE_FILE_EXTENSION = ".mgstruct";
    public static final String LEVEL_FILE_EXTENSION = ".mglvl";
    public static final String QUESTION_REPLACE_WITH_PATH = ".curr_folder.";
    private static final int TARGET_SAVE = 0;
    private static final int TARGET_OPEN = 1;
    public static final int MODE_STRUCTURE = 1;
    public static final int MODE_LEVEL = 2;
    private final TextComponent question = new TextComponent();
    private final ButtonCol list = new ButtonCol();
    private Feedback feedback;
    private final int mode;
    private int currentTarget = 0;
    private String currentFolder = null;
    private String pickedPath;
    private String fileName = "";
    private String questionTemplate = "";

    public PathPicker(int mode, IPopupFeedback parent) {
        super("File picker", parent);
        this.mode = mode;
        this.initUI();
    }

    public PathPicker pickFolder(String question, Feedback onComplete) {
        return this.pickFolder(null, question, onComplete);
    }

    public PathPicker pickFolder(String initialPath, String question, Feedback onComplete) {
        this.questionTemplate = question;
        this.currentTarget = 0;
        this.currentFolder = initialPath;
        this.feedback = onComplete;
        this.initFM();
        return this;
    }

    public PathPicker pickFile(String question, Feedback onComplete) {
        return this.pickFile(null, question, onComplete);
    }

    public PathPicker pickFile(String initialPath, String question, Feedback onComplete) {
        this.questionTemplate = question;
        this.currentTarget = 1;
        this.currentFolder = initialPath;
        this.feedback = onComplete;
        this.initFM();
        return this;
    }

    private void initFM() {
        this.question.setText("");
        if (this.currentTarget == 0) {
            this.title.setText("Choose a folder");
        } else if (this.currentTarget == 1) {
            this.title.setText("Choose a file");
        }
        if (this.currentTarget == 0) {
            this.fileName = this.generateNewFileName();
            Logger.log(this.fileName);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (PathPicker.this.currentFolder == null) {
                    PathPicker.this.currentFolder = "";
                    String[] roots = FileUtils.getRoots();
                    PathPicker.this.setPaths(roots);
                } else {
                    if (PathPicker.this.currentTarget == 0) {
                        PathPicker.this.pickPath(PathPicker.this.currentFolder + PathPicker.this.fileName);
                    }
                    PathPicker.this.getNewList();
                }
            }
        }).start();
    }

    private void getNewList() {
        this.title.setText(this.currentFolder);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PathPicker.this.setPaths(FileUtils.list(PathPicker.this.currentFolder));
                }
                catch (IOException ex) {
                    Logger.log(ex);
                }
            }
        }).start();
    }

    private void pickPath(String path) {
        this.pickedPath = path;
        if (!this.fileName.equals("")) {
            this.question.setText(Utils.replace(this.questionTemplate, QUESTION_REPLACE_WITH_PATH, this.pickedPath));
        } else {
            this.question.setText("");
        }
    }

    private void setPaths(String[] paths) {
        Button[] listButtons = new Button[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            final String name = paths[i];
            listButtons[i] = new Button(name){

                @Override
                public void buttonPressed() {
                    if (name.endsWith(String.valueOf('/'))) {
                        if (PathPicker.this.currentTarget == 1) {
                            PathPicker.this.fileName = "";
                        }
                        PathPicker.this.currentFolder = PathPicker.this.currentFolder + name;
                        PathPicker.this.pickPath(PathPicker.this.currentFolder + PathPicker.this.fileName);
                        PathPicker.this.getNewList();
                    } else {
                        if (PathPicker.this.currentTarget == 1) {
                            PathPicker.this.fileName = name;
                        }
                        PathPicker.this.pickPath(PathPicker.this.currentFolder + name);
                    }
                }
            };
        }
        this.setListButtons(listButtons);
    }

    private void setListButtons(Button[] buttons) {
        this.list.setButtons(buttons);
        this.setSize(this.w, this.h);
        this.refreshFocusedComponents();
        this.repaint();
    }

    private void initUI() {
        this.question.enableHorizontalScrolling(true).setBgColor(-1);
    }

    @Override
    protected Button[] getActionButtons() {
        Button okBtn = new Button("OK"){

            @Override
            public void buttonPressed() {
                if (PathPicker.this.currentTarget == 1 && PathPicker.this.pickedPath.endsWith(String.valueOf('/'))) {
                    return;
                }
                PathPicker.this.feedback.onComplete(PathPicker.this.pickedPath);
            }
        };
        Button cancelBtn = new Button("Cancel"){

            @Override
            public void buttonPressed() {
                PathPicker.this.setVisible(false);
                PathPicker.this.feedback.onCancel();
            }
        };
        return new Button[]{okBtn, cancelBtn};
    }

    @Override
    protected IUIComponent initAndGetPageContent() {
        return new Container(){

            @Override
            public void init() {
                this.setComponents(new IUIComponent[]{PathPicker.this.list, PathPicker.this.question});
                super.init();
            }

            @Override
            protected void onSetBounds(int x0, int y0, int w, int h) {
                PathPicker.this.question.setSize(w, Font.getDefaultFontHeight()).setPos(x0 + w / 2, y0 + h, 33);
                PathPicker.this.list.setButtonsBgPadding(PathPicker.this.margin / 4).setSize(w, PathPicker.this.question.getTopY() - PathPicker.this.margin - y0).setPos(x0 + w / 2, PathPicker.this.question.getTopY() - PathPicker.this.margin, 33);
            }
        };
    }

    private String generateNewFileName() {
        String fileExtension;
        Calendar calendar = Calendar.getInstance();
        switch (this.mode) {
            case 1: {
                fileExtension = STRUCTURE_FILE_EXTENSION;
                break;
            }
            case 2: {
                fileExtension = LEVEL_FILE_EXTENSION;
                break;
            }
            default: {
                fileExtension = ".unknown";
            }
        }
        return calendar.get(1) + "-" + this.format(calendar.get(2) + 1) + "-" + this.format(calendar.get(5)) + "_" + this.format(calendar.get(11)) + "-" + this.format(calendar.get(12)) + "-" + this.format(calendar.get(13)) + fileExtension;
    }

    private String format(int date) {
        String dateStr = String.valueOf(date);
        if (dateStr.length() < 2) {
            dateStr = "0" + dateStr;
        }
        return dateStr;
    }

    public static interface Feedback {
        public void onComplete(String var1);

        public void onCancel();
    }
}

