/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import mobileapplication3.editor.EditorSettings;
import mobileapplication3.editor.setup.SetupWizard;
import mobileapplication3.ui.AbstractPopupPage;
import mobileapplication3.ui.BackButton;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonCol;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.Switch;

public class SettingsUI
extends AbstractPopupPage {
    public SettingsUI(IPopupFeedback parent) {
        super("Settings", parent);
    }

    @Override
    protected Button[] getActionButtons() {
        return new Button[]{new BackButton(this.feedback)};
    }

    @Override
    protected IUIComponent initAndGetPageContent() {
        Button[] settingsButtons = new Button[]{new Button("Current game folder: " + EditorSettings.getGameFolderPath()){

            @Override
            public void buttonPressed() {
            }
        }.setIsActive(false), new Switch("Smooth keyboard scrolling"){

            @Override
            public boolean getValue() {
                return EditorSettings.getKbSmoothScrollingEnabled();
            }

            @Override
            public void setValue(boolean value) {
                EditorSettings.setKbSmoothScrollingEnabled(value);
                SettingsUI.this.getUISettings().onChange();
            }
        }, new Switch("Kinetic touch scrolling"){

            @Override
            public boolean getValue() {
                return EditorSettings.getKineticScrollingEnabled();
            }

            @Override
            public void setValue(boolean value) {
                EditorSettings.setKineticScrollingEnabled(value);
                SettingsUI.this.getUISettings().onChange();
            }
        }, new Switch("Transparent background of popups"){

            @Override
            public boolean getValue() {
                return EditorSettings.getTransparencyEnabled();
            }

            @Override
            public void setValue(boolean value) {
                EditorSettings.setTransparencyEnabled(value);
                SettingsUI.this.getUISettings().onChange();
            }
        }, new Switch("Key repeats in lists"){

            @Override
            public boolean getValue() {
                return EditorSettings.getKeyRepeatedInListsEnabled();
            }

            @Override
            public void setValue(boolean value) {
                EditorSettings.setKeyRepeatedInListsEnabled(value);
                SettingsUI.this.getUISettings().onChange();
            }
        }, new Switch("Auto-save"){

            @Override
            public boolean getValue() {
                return EditorSettings.getAutoSaveEnabled();
            }

            @Override
            public void setValue(boolean value) {
                EditorSettings.setAutoSaveEnabled(value);
                SettingsUI.this.getUISettings().onChange();
            }
        }, new Switch("Show log"){

            @Override
            public boolean getValue() {
                return EditorSettings.getOnScreenLogEnabled();
            }

            @Override
            public void setValue(boolean value) {
                EditorSettings.setOnScreenLogEnabled(value);
                SettingsUI.this.getUISettings().onChange();
            }
        }, new Button("Open setup wizard"){

            @Override
            public void buttonPressed() {
                SettingsUI.this.showPopup(new SetupWizard(new SetupWizard.FinishSetup(){

                    @Override
                    public void onFinish() {
                        SettingsUI.this.closePopup();
                        SettingsUI.this.isInited = false;
                        SettingsUI.this.init();
                    }
                }));
            }
        }, new Button("Reset settings"){

            @Override
            public void buttonPressed() {
                EditorSettings.resetSettings();
                SettingsUI.this.isInited = false;
                SettingsUI.this.init();
            }
        }.setBgColor(0x550000)};
        return new ButtonCol(settingsButtons);
    }

    @Override
    public void setPageContentBounds(IUIComponent pageContent, int x0, int y0, int w, int h) {
        if (pageContent != null) {
            ((ButtonCol)pageContent).setButtonsBgPadding(this.margin / 8).setSize(w - this.margin * 2, h - this.margin * 2).setPos(x0 + w / 2, y0 + h - this.margin, 33);
        }
    }
}

