/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import java.io.IOException;
import java.util.Vector;
import mobileapplication3.editor.MGStructs;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.editor.elements.EndPoint;
import mobileapplication3.editor.elements.LevelStart;
import mobileapplication3.platform.FileUtils;
import mobileapplication3.platform.Logger;

public abstract class StructureBuilder {
    public static final int MODE_STRUCTURE = 1;
    public static final int MODE_LEVEL = 2;
    private int mode;
    private Vector buffer;
    public Element placingNow;
    private NextPointHandler nextPointHandler;
    public boolean isEditing = false;
    private String path = null;

    public StructureBuilder(int mode) {
        this.reset(mode);
    }

    public void reset(int mode) {
        this.mode = mode;
        this.buffer = new Vector();
        if (mode == 1) {
            this.buffer.addElement(new EndPoint().setArgs(new short[]{0, 0}));
        } else if (mode == 2) {
            this.buffer.addElement(new LevelStart().setArgs(new short[]{200, -200}));
        }
        this.onUpdate();
    }

    public void place(short id, short x, short y) throws IllegalArgumentException {
        this.isEditing = false;
        this.placingNow = Element.createTypedInstance(id);
        Logger.log("Placing " + id);
        this.nextPointHandler = new NextPointHandler();
        this.handleNextPoint(x, y, false);
        this.add(this.placingNow);
        this.onUpdate();
        this.handleNextPoint(x, y, true);
    }

    public void edit(Element e, int step) {
        Element[] elements = this.getElementsAsArray();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null || !elements[i].equals(e)) continue;
            this.edit(i, step);
            break;
        }
    }

    public void edit(int i, int step) {
        this.placingNow = this.getElementsAsArray()[i];
        this.nextPointHandler = new NextPointHandler(step);
        this.isEditing = true;
    }

    public void handleNextPoint(short x, short y, boolean isPreview) {
        if (this.placingNow == null) {
            return;
        }
        this.nextPointHandler.showingPreview = isPreview;
        this.nextPointHandler.handleNextPoint(x, y);
        if ((this.nextPointHandler.step >= this.placingNow.getStepsToPlace() || this.isEditing) && !isPreview) {
            if (this.placingNow.getID() != 1) {
                this.recalculateEndPoint();
            }
            this.placingNow = null;
            this.nextPointHandler = null;
            this.onUpdate();
        }
    }

    public void add(Element element) {
        if (element != null && !(element instanceof EndPoint)) {
            this.buffer.addElement(element);
        }
    }

    public short[] asShortArray() {
        int carriage = 0;
        short[] data = new short[2 + this.getDataLengthInShorts() + 1];
        data[carriage] = 1;
        data[++carriage] = (short)this.getElementsCount();
        ++carriage;
        for (int i = 0; i < this.getElementsCount(); ++i) {
            Element element = (Element)this.buffer.elementAt(i);
            short[] elementArgs = element.getAsShortArray();
            for (int j = 0; j < elementArgs.length; ++j) {
                data[carriage] = elementArgs[j];
                ++carriage;
            }
        }
        data[carriage] = 0;
        return data;
    }

    public short[][] asShortArrays() {
        short[][] data = new short[this.getElementsCount()][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((Element)this.buffer.elementAt(i)).getAsShortArray();
        }
        return data;
    }

    public void saveToFile(String path) throws IOException, SecurityException {
        FileUtils.saveShortArrayToFile(this.asShortArray(), path);
    }

    public void loadFile(String path) {
        try {
            Element[] elements = MGStructs.readMGStruct(path);
            if (elements == null) {
                Logger.log("error: elements array is null");
                return;
            }
            this.setElements(elements);
            this.path = path;
        }
        catch (Exception ex) {
            Logger.log(ex);
        }
    }

    public String getFilePath() {
        return this.path;
    }

    public void setFilePath(String path) {
        this.path = path;
    }

    public void setElements(Element[] elements) {
        this.buffer = new Vector();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] != null) {
                this.buffer.addElement(elements[i]);
                continue;
            }
            Logger.log("elements[" + i + "] is null. skipping");
        }
        this.onUpdate();
    }

    public void remove(int i) {
        if (this.buffer.elementAt(i) instanceof EndPoint || this.buffer.elementAt(i) instanceof LevelStart) {
            return;
        }
        boolean needToRecalculateEndPoint = true;
        this.buffer.removeElementAt(i);
        if (needToRecalculateEndPoint) {
            this.recalculateEndPoint();
        }
        this.onUpdate();
    }

    public void remove(Element e) {
        this.remove(this.findInBuffer(e));
    }

    public int findInBuffer(Element e) {
        Element[] elements = this.getElementsAsArray();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null || !elements[i].equals(e)) continue;
            return i;
        }
        throw new IllegalArgumentException("Element " + e + " not found in buffer");
    }

    public void recalculateEndPoint() {
        if (this.mode == 2) {
            return;
        }
        Element[] elements = this.getElementsAsArray();
        EndPoint endPoint = (EndPoint)elements[0];
        endPoint.setArgs(EndPoint.findEndPoint(elements));
    }

    public Vector getElements() {
        return this.buffer;
    }

    public int getElementsCount() {
        return this.buffer.size();
    }

    public Element[] getElementsAsArray() {
        Element[] elements = new Element[this.getElementsCount()];
        for (int i = 0; i < this.getElementsCount(); ++i) {
            elements[i] = (Element)this.buffer.elementAt(i);
        }
        return elements;
    }

    public int getDataLengthInShorts() {
        int l = 0;
        for (int i = 0; i < this.getElementsCount(); ++i) {
            l += 1 + ((Element)this.buffer.elementAt(i)).getArgsCount();
        }
        return l;
    }

    public String getPlacingInfo() {
        if (this.nextPointHandler != null && this.placingNow != null) {
            return this.nextPointHandler.getCurrentPlacementStep().getCurrentStepInfo();
        }
        return "";
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        Vector oldBuffer = this.buffer;
        this.reset(mode);
        for (int i = 1; i < oldBuffer.size(); ++i) {
            this.buffer.addElement(oldBuffer.elementAt(i));
        }
        this.onUpdate();
    }

    public abstract void onUpdate();

    private class NextPointHandler {
        public int step;
        public boolean showingPreview = false;

        public NextPointHandler(int step) {
            this.step = step;
        }

        public NextPointHandler() {
            this(0);
        }

        void handleNextPoint(short x, short y) {
            try {
                this.getCurrentPlacementStep().place(x, y);
            }
            catch (Exception ex) {
                Logger.log(ex);
            }
            if (!this.showingPreview) {
                ++this.step;
            }
        }

        public Element.PlacementStep getCurrentPlacementStep() {
            return StructureBuilder.this.placingNow.getAllSteps()[this.step];
        }
    }
}

