/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import mobileapplication3.editor.elements.Element;
import mobileapplication3.editor.elements.EndPoint;
import mobileapplication3.editor.elements.StartPoint;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.UIComponent;

public class StructureViewerComponent
extends UIComponent {
    protected static final int MIN_ZOOM_OUT = 8;
    protected static final int MAX_ZOOM_OUT = 200000;
    protected int offsetX;
    protected int offsetY;
    protected int zoomOut;
    protected short start;
    protected short end;
    protected Element[] elements = new Element[0];

    public StructureViewerComponent() {
        this.setBgColor(0x101020);
        this.setZoomOut(8192);
    }

    public StructureViewerComponent(Element[] elements) {
        this();
        this.setElements(elements);
    }

    @Override
    public void postInit() {
        this.setOptimalZoomAndOffset(this.w, this.h);
    }

    public void setElements(Element[] elements) {
        this.elements = elements;
        this.start = StartPoint.findStartPoint(elements)[0];
        this.end = EndPoint.findEndPoint(elements)[0];
    }

    @Override
    public boolean canBeFocused() {
        return false;
    }

    @Override
    protected boolean handlePointerClicked(int x, int y) {
        return false;
    }

    @Override
    protected boolean handleKeyPressed(int keyCode, int count) {
        return false;
    }

    @Override
    protected void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        try {
            this.drawElements(g, x0, y0, this.elements);
        }
        catch (Exception ex) {
            g.drawString(ex.toString(), x0, y0, 20);
        }
    }

    protected void drawElements(Graphics g, int x0, int y0, Element[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            try {
                elements[i].paint(g, this.zoomOut, x0 + this.offsetX, y0 + this.offsetY, true, false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        this.setOptimalZoomAndOffset(w, h);
    }

    protected void setOptimalZoomAndOffset(int w, int h) {
        int zoomOut = Mathh.constrain(8, 4000000 / Math.min(w, h), 200000);
        zoomOut = Math.max(zoomOut, 1000 * (this.end - this.start) * 3 / w / 2);
        this.setZoomOut(zoomOut);
        this.offsetX = w / 2;
        if (zoomOut != 0) {
            this.offsetX -= (this.end + this.start) / 2 * 1000 / zoomOut;
        }
        this.offsetY = h / 2;
    }

    protected void setZoomOut(int zoomOut) {
        this.zoomOut = zoomOut;
    }
}

