/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import java.io.IOException;
import java.util.Vector;
import mobileapplication3.editor.AbstractEditorMenu;
import mobileapplication3.editor.EditorSettings;
import mobileapplication3.editor.EditorUI;
import mobileapplication3.editor.MGStructs;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;

public class StructuresMenu
extends AbstractEditorMenu {
    private String path = null;

    public StructuresMenu(IPopupFeedback parent) {
        super(parent, "Structures");
    }

    private String getPath() {
        if (this.path == null) {
            this.path = EditorSettings.getStructsFolderPath();
        }
        return this.path;
    }

    @Override
    public IUIComponent[] getGridContent() {
        Vector<1> gridContentVector = new Vector<1>();
        String[] files = new String[]{};
        try {
            files = this.listFiles(this.getPath());
        }
        catch (IOException e) {
            Platform.showError(e);
        }
        Logger.log("getting grid content: " + files.length + " files");
        try {
            for (int i = 0; i < files.length; ++i) {
                final String filePath = this.getPath() + files[i];
                try {
                    gridContentVector.addElement(new AbstractEditorMenu.EditorFileListCell(filePath){

                        @Override
                        public void openInEditor() {
                            StructuresMenu.this.openInEditor(filePath);
                        }
                    });
                    continue;
                }
                catch (Exception ex) {
                    Logger.log("Can't create StructureViewer:");
                    Logger.log(ex);
                }
            }
        }
        catch (Exception e) {
            Platform.showError(e);
        }
        IUIComponent[] gridContent = new IUIComponent[gridContentVector.size()];
        for (int i = 0; i < gridContentVector.size(); ++i) {
            gridContent[i] = (IUIComponent)gridContentVector.elementAt(i);
        }
        Logger.log("Grid: " + gridContent.length + " cells");
        return gridContent;
    }

    @Override
    public Button[] getList() {
        String[] files = null;
        try {
            files = this.listFiles(this.getPath());
        }
        catch (IOException e) {
            Platform.showError(e);
        }
        if (files == null) {
            files = new String[]{};
        }
        Button[] buttons = new Button[files.length];
        for (int i = 0; i < files.length; ++i) {
            final String name = files[i];
            buttons[i] = new Button(name){

                @Override
                public void buttonPressed() {
                    StructuresMenu.this.openInEditor(StructuresMenu.this.getPath() + name);
                }
            };
        }
        return buttons;
    }

    public void openInEditor(String path) {
        this.openInEditor(MGStructs.readMGStruct(path), path);
    }

    public void openInEditor(Element[] elements, String path) {
        RootContainer.setRootUIComponent(new EditorUI(1, elements, path));
    }

    @Override
    protected void createNew() {
        RootContainer.setRootUIComponent(new EditorUI(1));
    }
}

