/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.elements;

import mobileapplication3.editor.elements.Element;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Graphics;

public abstract class AbstractCurve
extends Element {
    protected static final int NO_ARROWS = 0;
    protected static final int ARROWS_NORMAL = 1;
    protected static final int ARROWS_INVERTED = -1;
    protected PointsCache pointsCache = null;

    abstract void genPoints();

    @Override
    public void paint(Graphics g, int zoomOut, int offsetX, int offsetY, boolean drawThickness, boolean drawAsSelected) {
        if (this.pointsCache == null) {
            this.genPoints();
        }
        if (this.pointsCache.getSize() == 0) {
            return;
        }
        g.setColor(this.getSuitableColor(drawAsSelected));
        short[] startPoint = this.pointsCache.getPoint(0);
        int arrowsDirection = this.getArrowsDirection();
        for (int i = 0; i < this.pointsCache.getSize() - 1; ++i) {
            short[] endPoint = this.pointsCache.getPoint(i + 1);
            int x1 = this.xToPX(startPoint[0], zoomOut, offsetX);
            int y1 = this.yToPX(startPoint[1], zoomOut, offsetY);
            int x2 = this.xToPX(endPoint[0], zoomOut, offsetX);
            int y2 = this.yToPX(endPoint[1], zoomOut, offsetY);
            g.drawLine(x1, y1, x2, y2, 24, zoomOut, drawThickness, true, true, true);
            if (arrowsDirection != 0 && i % 2 == 0) {
                int dx = x2 - x1;
                int dy = y2 - y1;
                if (arrowsDirection == -1) {
                    dx = -dx;
                    dy = -dy;
                }
                short l = Mathh.calcDistance(dx, dy);
                int centerX = (x1 + x2) / 2;
                int centerY = (y1 + y2) / 2;
                int lzoomout = l * zoomOut;
                g.drawArrow(centerX, centerY, centerX + dy * 50000 / lzoomout, centerY - dx * 50000 / lzoomout, 4, zoomOut, drawThickness);
            }
            startPoint = endPoint;
        }
    }

    @Override
    public boolean isBody() {
        return false;
    }

    protected int getArrowsDirection() {
        return 0;
    }

    protected class PointsCache {
        short[][] pointsCache;
        int cacheCarriage = 0;

        PointsCache(int length) {
            this.pointsCache = new short[length][2];
        }

        public void writePointToCache(short[] point) {
            this.writePointToCache(point[0], point[1]);
        }

        public void writePointToCache(int x, int y) {
            this.pointsCache[this.cacheCarriage][0] = (short)x;
            this.pointsCache[this.cacheCarriage][1] = (short)y;
            ++this.cacheCarriage;
        }

        public void movePoints(short dx, short dy) {
            for (int i = 0; i < this.pointsCache.length; ++i) {
                short[] sArray = this.pointsCache[i];
                sArray[0] = (short)(sArray[0] + dx);
                short[] sArray2 = this.pointsCache[i];
                sArray2[1] = (short)(sArray2[1] + dy);
            }
        }

        public int getSize() {
            return this.cacheCarriage;
        }

        public short[] getPoint(int i) {
            return this.pointsCache[i];
        }
    }
}

