/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.elements;

import mobileapplication3.editor.elements.Element;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Property;

public abstract class AbstractRectBodyElement
extends Element {
    protected short x;
    protected short y;
    protected short l;
    protected short thickness = (short)20;
    protected short angle;
    protected short anchorX;
    protected short anchorY;
    protected int color;

    public AbstractRectBodyElement(int color) {
        this.color = color;
    }

    @Override
    public Element.PlacementStep[] getPlacementSteps() {
        return new Element.PlacementStep[]{new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                AbstractRectBodyElement.this.setAnchorPoint(pointX, pointY);
            }

            @Override
            public String getName() {
                return "Move";
            }

            @Override
            public String getCurrentStepInfo() {
                return "x=" + AbstractRectBodyElement.this.anchorX + "y=" + AbstractRectBodyElement.this.anchorY;
            }
        }, new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                short dx = (short)(pointX - AbstractRectBodyElement.this.anchorX);
                short dy = (short)(pointY - AbstractRectBodyElement.this.anchorY);
                AbstractRectBodyElement.this.l = Element.calcDistance(dx, dy);
                AbstractRectBodyElement.this.angle = (short)Mathh.arctg(dx, dy);
                AbstractRectBodyElement.this.calcCenterPoint();
            }

            @Override
            public String getName() {
                return "Change length and angle";
            }

            @Override
            public String getCurrentStepInfo() {
                return "l=" + AbstractRectBodyElement.this.l + "angle=" + AbstractRectBodyElement.this.angle;
            }
        }};
    }

    @Override
    public Element.PlacementStep[] getExtraEditingSteps() {
        return new Element.PlacementStep[0];
    }

    @Override
    public void paint(Graphics g, int zoomOut, int offsetX, int offsetY, boolean drawThickness, boolean drawAsSelected) {
        int dx = this.l * Mathh.cos(this.angle) / 1000;
        int dy = this.l * Mathh.sin(this.angle) / 1000;
        if (!drawAsSelected) {
            g.setColor(this.color);
        } else {
            g.setColor(this.getSuitableColor(true));
        }
        g.drawLine(this.xToPX(this.x - dx / 2, zoomOut, offsetX), this.yToPX(this.y - dy / 2, zoomOut, offsetY), this.xToPX(this.x + dx / 2, zoomOut, offsetX), this.yToPX(this.y + dy / 2, zoomOut, offsetY), this.thickness, zoomOut, true, true, false, false);
    }

    @Override
    public Element setArgs(short[] args) {
        this.l = args[2];
        this.thickness = args[3];
        this.angle = args[4];
        this.setCenterPoint(args[0], args[1]);
        return this;
    }

    @Override
    public short[] getArgsValues() {
        return new short[]{this.x, this.y, this.l, this.thickness, this.angle};
    }

    @Override
    public Property[] getArgs() {
        return new Property[]{new Property("X"){

            @Override
            public void setValue(short value) {
                AbstractRectBodyElement.this.x = value;
            }

            @Override
            public short getValue() {
                return AbstractRectBodyElement.this.x;
            }
        }, new Property("Y"){

            @Override
            public void setValue(short value) {
                AbstractRectBodyElement.this.y = value;
            }

            @Override
            public short getValue() {
                return AbstractRectBodyElement.this.y;
            }
        }, new Property("L"){

            @Override
            public void setValue(short value) {
                AbstractRectBodyElement.this.l = value;
            }

            @Override
            public short getValue() {
                return AbstractRectBodyElement.this.l;
            }

            @Override
            public short getMinValue() {
                return 0;
            }
        }, new Property("Thickness"){

            @Override
            public void setValue(short value) {
                AbstractRectBodyElement.this.thickness = value;
            }

            @Override
            public short getValue() {
                return AbstractRectBodyElement.this.thickness;
            }

            @Override
            public short getMinValue() {
                return 1;
            }

            @Override
            public short getMaxValue() {
                return (short)(AbstractRectBodyElement.this.l * 2);
            }
        }, new Property("Angle", true){

            @Override
            public void setValue(short value) {
                AbstractRectBodyElement.this.angle = value;
            }

            @Override
            public short getValue() {
                return AbstractRectBodyElement.this.angle;
            }

            @Override
            public short getMinValue() {
                return 0;
            }

            @Override
            public short getMaxValue() {
                return 360;
            }
        }};
    }

    @Override
    public int getStepsToPlace() {
        return STEPS_TO_PLACE[this.getID()];
    }

    @Override
    public void move(short dx, short dy) {
        this.x = (short)(this.x + dx);
        this.y = (short)(this.y + dy);
    }

    @Override
    public short[] getStartPoint() {
        return this.getCornerPoint((this.angle + 90) % 360 < 180 ? 0 : 2);
    }

    @Override
    public short[] getEndPoint() {
        return this.getCornerPoint((this.angle + 90) % 360 < 180 ? 1 : 3);
    }

    @Override
    public boolean isBody() {
        return true;
    }

    @Override
    public void recalcCalculatedArgs() {
        this.calcAnchorPoint();
    }

    private short[] getCornerPoint(int i) {
        int m1;
        int m2;
        if (i == 0) {
            m2 = -1;
            m1 = -1;
        } else if (i == 1) {
            m1 = 1;
            m2 = -1;
        } else if (i == 2) {
            m2 = 1;
            m1 = 1;
        } else {
            m1 = -1;
            m2 = 1;
        }
        return new short[]{(short)(this.x + m1 * this.l * Mathh.cos(this.angle) / 2000 + m2 * this.thickness * Mathh.cos(this.angle + 90) / 2000), (short)(this.y + m1 * this.l * Mathh.sin(this.angle) / 2000 + m2 * this.thickness * Mathh.sin(this.angle + 90) / 2000)};
    }

    private void setCenterPoint(short x, short y) {
        if (x == this.x && y == this.y) {
            return;
        }
        this.x = x;
        this.y = y;
        this.calcAnchorPoint();
    }

    private void setAnchorPoint(short x, short y) {
        if (x == this.anchorX && y == this.anchorY) {
            return;
        }
        this.anchorX = x;
        this.anchorY = y;
        this.calcCenterPoint();
    }

    private void calcCenterPoint() {
        this.x = (short)(this.anchorX + this.l * Mathh.cos(this.angle) / 2000 + this.thickness * Mathh.cos(this.angle + 90) / 2000);
        this.y = (short)(this.anchorY + this.l * Mathh.sin(this.angle) / 2000 + this.thickness * Mathh.sin(this.angle + 90) / 2000);
    }

    private void calcAnchorPoint() {
        this.anchorX = (short)(this.x - this.l * Mathh.cos(this.angle) / 2000 - this.thickness * Mathh.cos(this.angle + 90) / 2000);
        this.anchorY = (short)(this.y - this.l * Mathh.sin(this.angle) / 2000 - this.thickness * Mathh.sin(this.angle + 90) / 2000);
    }
}

