/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.elements;

import mobileapplication3.editor.elements.AbstractRectBodyElement;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Property;

public class Accelerator
extends AbstractRectBodyElement {
    private short directionOffset;
    private short m = (short)150;
    private short effectDuration = (short)30;

    public Accelerator() {
        super(0xFF00FF);
    }

    @Override
    public void paint(Graphics g, int zoomOut, int offsetX, int offsetY, boolean drawThickness, boolean drawAsSelected) {
        int blue;
        int dx = this.l * Mathh.cos(this.angle) / 1000;
        int dy = this.l * Mathh.sin(this.angle) / 1000;
        int colorModifier = (this.m - 100) * 3;
        int red = Math.min(255, Math.max(0, colorModifier));
        if (red < 50 & (blue = Math.min(255, Math.max(0, -colorModifier))) < 50) {
            red = 50;
            blue = 50;
        }
        if (!drawAsSelected) {
            g.setColor(red, blue, blue);
        } else {
            g.setColor(this.getSuitableColor(drawAsSelected));
        }
        g.drawLine(this.xToPX(this.x - dx / 2, zoomOut, offsetX), this.yToPX(this.y - dy / 2, zoomOut, offsetY), this.xToPX(this.x + dx / 2, zoomOut, offsetX), this.yToPX(this.y + dy / 2, zoomOut, offsetY), this.thickness, zoomOut, true, true, false, true);
        int vectorX = this.m * Mathh.cos(this.angle + 15 + this.directionOffset) / 1000;
        int vectorY = this.m * Mathh.sin(this.angle + 15 + this.directionOffset) / 1000;
        g.drawArrow(this.xToPX(this.x, zoomOut, offsetX), this.yToPX(this.y, zoomOut, offsetY), this.xToPX(this.x + vectorX, zoomOut, offsetX), this.yToPX(this.y + vectorY, zoomOut, offsetY), this.thickness / 4, zoomOut, drawThickness);
    }

    private short[] getZeros() {
        short x = (short)(this.x - this.l * Mathh.cos(this.angle) / 2000);
        short y = (short)(this.y - this.l * Mathh.sin(this.angle) / 2000);
        return new short[]{x, y};
    }

    private void setZeros(int x, int y, int l, int angle) {
        this.x = (short)(x + l * Mathh.cos(angle) / 2000);
        this.y = (short)(y + l * Mathh.sin(angle) / 2000);
    }

    @Override
    public Element setArgs(short[] args) {
        this.setZeros(args[0], args[1], args[2], args[4]);
        this.l = args[2];
        this.thickness = args[3];
        this.angle = args[4];
        this.directionOffset = args[5];
        this.m = args[6];
        this.effectDuration = args[7];
        this.recalcCalculatedArgs();
        return this;
    }

    @Override
    public short[] getArgsValues() {
        short[] zeros = this.getZeros();
        short x = zeros[0];
        short y = zeros[1];
        return new short[]{x, y, this.l, this.thickness, this.angle, this.directionOffset, this.m, this.effectDuration};
    }

    @Override
    public Property[] getArgs() {
        return Accelerator.concatArrays(super.getArgs(), new Property[]{new Property("Speed direction offset"){

            @Override
            public void setValue(short value) {
                Accelerator.this.directionOffset = value;
            }

            @Override
            public short getValue() {
                return Accelerator.this.directionOffset;
            }

            @Override
            public short getMinValue() {
                return 0;
            }

            @Override
            public short getMaxValue() {
                return 360;
            }
        }, new Property("Speed multiplier (percents)"){

            @Override
            public void setValue(short value) {
                Accelerator.this.m = value;
            }

            @Override
            public short getValue() {
                return Accelerator.this.m;
            }

            @Override
            public short getMinValue() {
                return 0;
            }

            @Override
            public short getMaxValue() {
                return 1000;
            }
        }, new Property("Effect duration (ticks)"){

            @Override
            public void setValue(short value) {
                Accelerator.this.effectDuration = value;
            }

            @Override
            public short getValue() {
                return Accelerator.this.effectDuration;
            }

            @Override
            public short getMinValue() {
                return 0;
            }

            @Override
            public short getMaxValue() {
                return 1200;
            }
        }});
    }

    @Override
    public short getID() {
        return 7;
    }

    @Override
    public int getStepsToPlace() {
        return STEPS_TO_PLACE[7];
    }

    @Override
    public String getName() {
        return "Accelerator";
    }
}

