/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.elements;

import mobileapplication3.editor.elements.Element;
import mobileapplication3.editor.elements.Line;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Property;

public class BrokenLine
extends Line {
    protected short thickness = (short)20;
    protected short platformLength;
    protected short spacing = (short)10;
    protected short l;
    protected short ang;

    @Override
    public Element.PlacementStep[] getPlacementSteps() {
        return new Element.PlacementStep[]{new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                int dx = pointX - BrokenLine.this.x1;
                int dy = pointY - BrokenLine.this.y1;
                BrokenLine.this.setStartPoint(pointX, pointY);
                BrokenLine.this.setEndPoint((short)(BrokenLine.this.x2 + dx), (short)(BrokenLine.this.y2 + dy));
            }

            @Override
            public String getName() {
                return "Move";
            }

            @Override
            public String getCurrentStepInfo() {
                return "x1=" + BrokenLine.this.x1 + " y1=" + BrokenLine.this.y1;
            }
        }, new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                BrokenLine.this.setEndPoint(pointX, pointY);
                BrokenLine.this.recalcCalculatedArgs();
            }

            @Override
            public String getName() {
                return "Move end point";
            }

            @Override
            public String getCurrentStepInfo() {
                return "plL=" + BrokenLine.this.platformLength + " ang=" + BrokenLine.this.ang + "; x1=" + BrokenLine.this.x1 + " y1=" + BrokenLine.this.y1 + "; x2=" + BrokenLine.this.x2 + " y2=" + BrokenLine.this.y2;
            }
        }};
    }

    @Override
    public void recalcCalculatedArgs() {
        short dx = (short)(this.x2 - this.x1);
        short dy = (short)(this.y2 - this.y1);
        this.l = dy == 0 ? dx : (dx == 0 ? dy : BrokenLine.calcDistance(dx, dy));
        if (this.l <= 0) {
            this.l = 1;
        }
        int optimalPlatfL = 260;
        this.platformLength = (short)optimalPlatfL;
        if (this.platformLength > this.l) {
            this.platformLength = this.l;
        } else {
            short platfL1 = this.platformLength;
            while ((this.l + this.spacing) % (this.platformLength + this.spacing) != 0 & this.platformLength < this.l & (this.l + this.spacing) % (platfL1 + this.spacing) != 0) {
                this.platformLength = (short)(this.platformLength + 1);
                if (platfL1 <= 5) continue;
                platfL1 = (short)(platfL1 - 1);
            }
            if ((this.l + this.spacing) % (this.platformLength + this.spacing) == 0) {
                platfL1 = this.platformLength;
            }
            this.platformLength = platfL1;
        }
        if (this.platformLength <= 0) {
            this.platformLength = this.l;
        }
        this.ang = (short)Mathh.arctg(dx, dy);
    }

    @Override
    public Element.PlacementStep[] getExtraEditingSteps() {
        return super.getExtraEditingSteps();
    }

    @Override
    public void paint(Graphics g, int zoomOut, int offsetX, int offsetY, boolean drawThickness, boolean drawAsSelected) {
        if (!drawAsSelected) {
            g.setColor(0xFFFFFF);
        } else {
            g.setColor(this.getSuitableColor(true));
        }
        int dx = this.x2 - this.x1;
        int dy = this.y2 - this.y1;
        int n = (this.l + this.spacing) / (this.platformLength + this.spacing);
        int spX = this.spacing * dx / this.l;
        int spY = this.spacing * dy / this.l;
        int platfDx = (dx + spX) / n;
        int platfDy = (dy + spY) / n;
        for (int i = 0; i < n; ++i) {
            g.drawLine(this.xToPX(this.x1 + i * platfDx, zoomOut, offsetX), this.yToPX(this.y1 + i * platfDy, zoomOut, offsetY), this.xToPX(this.x1 + (i + 1) * platfDx - spX, zoomOut, offsetX), this.yToPX(this.y1 + (i + 1) * platfDy - spY, zoomOut, offsetY), this.thickness, zoomOut, true, true, false, false);
        }
    }

    @Override
    public Element setArgs(short[] args) {
        this.x1 = args[0];
        this.y1 = args[1];
        this.x2 = args[2];
        this.y2 = args[3];
        this.thickness = args[4];
        this.platformLength = args[5];
        this.spacing = args[6];
        this.l = args[7];
        this.ang = args[8];
        return this;
    }

    @Override
    public short[] getArgsValues() {
        return new short[]{this.x1, this.y1, this.x2, this.y2, this.thickness, this.platformLength, this.spacing, this.l, this.ang};
    }

    @Override
    public Property[] getArgs() {
        Property[] superArgs = super.getArgs();
        Property[] thisArgs = new Property[]{new Property("Thickness"){

            @Override
            public void setValue(short value) {
                BrokenLine.this.thickness = value;
            }

            @Override
            public short getValue() {
                return BrokenLine.this.thickness;
            }

            @Override
            public short getMinValue() {
                return 1;
            }

            @Override
            public short getMaxValue() {
                return (short)(BrokenLine.this.platformLength * 2);
            }
        }, new Property("Platform length", true){

            @Override
            public void setValue(short value) {
                BrokenLine.this.platformLength = value;
            }

            @Override
            public short getValue() {
                return BrokenLine.this.platformLength;
            }

            @Override
            public short getMinValue() {
                return 0;
            }
        }, new Property("Spacing"){

            @Override
            public void setValue(short value) {
                BrokenLine.this.spacing = value;
            }

            @Override
            public short getValue() {
                return BrokenLine.this.spacing;
            }

            @Override
            public short getMinValue() {
                return 0;
            }
        }, new Property("Length", true){

            @Override
            public void setValue(short value) {
                BrokenLine.this.l = value;
            }

            @Override
            public short getValue() {
                return BrokenLine.this.l;
            }

            @Override
            public short getMinValue() {
                return 0;
            }
        }, new Property("Angle", true){

            @Override
            public void setValue(short value) {
                BrokenLine.this.ang = value;
            }

            @Override
            public short getValue() {
                return BrokenLine.this.ang;
            }

            @Override
            public short getMinValue() {
                return 0;
            }

            @Override
            public short getMaxValue() {
                return 360;
            }
        }};
        Property[] args = new Property[superArgs.length + thisArgs.length];
        System.arraycopy(superArgs, 0, args, 0, superArgs.length);
        System.arraycopy(thisArgs, 0, args, superArgs.length, thisArgs.length);
        return args;
    }

    @Override
    public short getID() {
        return 4;
    }

    @Override
    public int getStepsToPlace() {
        return 2;
    }

    @Override
    public String getName() {
        return "Broken Line";
    }

    @Override
    public boolean isBody() {
        return true;
    }
}

