/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.elements;

import mobileapplication3.editor.elements.AbstractCurve;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.editor.elements.EndPoint;
import mobileapplication3.editor.elements.StartPoint;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Property;

public class Circle
extends AbstractCurve {
    private short x;
    private short y;
    private short r = 1;
    private short arcAngle = (short)360;
    private short startAngle;
    private short kx = (short)100;
    private short ky = (short)100;

    @Override
    public Element.PlacementStep[] getPlacementSteps() {
        return new Element.PlacementStep[]{new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                Circle.this.setCenter(pointX, pointY);
            }

            @Override
            public String getName() {
                return "Move";
            }

            @Override
            public String getCurrentStepInfo() {
                return "x=" + Circle.this.x + " y=" + Circle.this.y;
            }
        }, new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                short dx = (short)(pointX - Circle.this.x);
                short dy = (short)(pointY - Circle.this.y);
                Circle.this.setRadius(Element.calcDistance(dx, dy));
            }

            @Override
            public String getName() {
                return "Change radius";
            }

            @Override
            public String getCurrentStepInfo() {
                return "r=" + Circle.this.r;
            }
        }};
    }

    @Override
    public Element.PlacementStep[] getExtraEditingSteps() {
        final short centerX = this.x;
        final short centerY = this.y;
        final short startAngle = this.startAngle;
        return new Element.PlacementStep[]{new Element.PlacementStep(){

            @Override
            public void place(short x, short y) {
                short ang = (short)(Mathh.arctg(x - centerX, y - centerY) - startAngle);
                for (ang = (short)(ang % 360); ang < 1; ang = (short)(ang + 360)) {
                }
                Circle.this.setArcAngle(ang);
            }

            @Override
            public String getName() {
                return "Change angle";
            }

            @Override
            public String getCurrentStepInfo() {
                return "ang=" + Circle.this.arcAngle;
            }
        }, new Element.PlacementStep(){

            @Override
            public void place(short x, short y) {
                short ang = (short)Mathh.arctg(x - centerX, y - centerY);
                Circle.this.setStartAngle(ang);
            }

            @Override
            public String getName() {
                return "Change start angle";
            }

            @Override
            public String getCurrentStepInfo() {
                return "startAng=" + startAngle;
            }
        }, new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                short dx = (short)(pointX - Circle.this.x);
                short dy = (short)(pointY - Circle.this.y);
                Circle.this.setScale((short)(Math.abs(dx) * 100 / Circle.this.r), (short)(Math.abs(dy) * 100 / Circle.this.r));
            }

            @Override
            public String getName() {
                return "Scale";
            }

            @Override
            public String getCurrentStepInfo() {
                return "kx=" + Circle.this.kx + ", ky=" + Circle.this.ky;
            }
        }};
    }

    public Element setCenter(short x, short y) {
        if (this.x == x && this.y == y) {
            return this;
        }
        if (this.pointsCache != null) {
            this.pointsCache.movePoints((short)(x - this.x), (short)(y - this.y));
        }
        this.x = x;
        this.y = y;
        return this;
    }

    public Element setRadius(short r) {
        if (this.r == (r = (short)Math.max(Math.abs(r), 1))) {
            return this;
        }
        this.r = r;
        this.pointsCache = null;
        return this;
    }

    public Element setArcAngle(short arcAngle) {
        if (this.arcAngle == arcAngle) {
            return this;
        }
        this.arcAngle = arcAngle;
        this.pointsCache = null;
        return this;
    }

    public Element setStartAngle(short startAngle) {
        while (startAngle < 0) {
            startAngle = (short)(startAngle + 360);
        }
        if (this.startAngle == (startAngle = (short)(startAngle % 360))) {
            return this;
        }
        this.startAngle = startAngle;
        this.pointsCache = null;
        return this;
    }

    public Element setScale(short scaleX, short scaleY) {
        if (this.kx == scaleX && this.ky == scaleY) {
            return this;
        }
        this.kx = (short)Math.max(Math.abs(scaleX), 1);
        this.ky = (short)Math.max(Math.abs(scaleY), 1);
        this.pointsCache = null;
        return this;
    }

    @Override
    public Element setArgs(short[] args) {
        this.x = args[0];
        this.y = args[1];
        this.r = args[2];
        this.arcAngle = args[3];
        this.startAngle = args[4];
        this.kx = args[5];
        this.ky = args[6];
        this.pointsCache = null;
        return this;
    }

    @Override
    public short[] getArgsValues() {
        return new short[]{this.x, this.y, this.r, this.arcAngle, this.startAngle, this.kx, this.ky};
    }

    @Override
    public Property[] getArgs() {
        return new Property[]{new Property("X"){

            @Override
            public void setValue(short value) {
                if (Circle.this.x != value) {
                    Circle.this.pointsCache = null;
                }
                Circle.this.x = value;
            }

            @Override
            public short getValue() {
                return Circle.this.x;
            }
        }, new Property("Y"){

            @Override
            public void setValue(short value) {
                if (Circle.this.y != value) {
                    Circle.this.pointsCache = null;
                }
                Circle.this.y = value;
            }

            @Override
            public short getValue() {
                return Circle.this.y;
            }
        }, new Property("R"){

            @Override
            public void setValue(short value) {
                if (Circle.this.r != value) {
                    Circle.this.pointsCache = null;
                }
                Circle.this.r = value;
            }

            @Override
            public short getValue() {
                return Circle.this.r;
            }

            @Override
            public short getMinValue() {
                return 1;
            }
        }, new Property("Arc angle"){

            @Override
            public void setValue(short value) {
                if (Circle.this.arcAngle != value) {
                    Circle.this.pointsCache = null;
                }
                Circle.this.arcAngle = value;
            }

            @Override
            public short getValue() {
                return Circle.this.arcAngle;
            }

            @Override
            public short getMinValue() {
                return -360;
            }

            @Override
            public short getMaxValue() {
                return 360;
            }
        }, new Property("Start angle"){

            @Override
            public void setValue(short value) {
                if (Circle.this.startAngle != value) {
                    Circle.this.pointsCache = null;
                }
                Circle.this.startAngle = value;
            }

            @Override
            public short getValue() {
                return Circle.this.startAngle;
            }

            @Override
            public short getMinValue() {
                return 0;
            }

            @Override
            public short getMaxValue() {
                return 360;
            }
        }, new Property("X-axis scale"){

            @Override
            public void setValue(short value) {
                if (Circle.this.kx != value) {
                    Circle.this.pointsCache = null;
                }
                Circle.this.kx = value;
            }

            @Override
            public short getValue() {
                return Circle.this.kx;
            }

            @Override
            public short getMinValue() {
                return 1;
            }

            @Override
            public short getMaxValue() {
                return 2048;
            }
        }, new Property("Y-axis scale"){

            @Override
            public void setValue(short value) {
                if (Circle.this.ky != value) {
                    Circle.this.pointsCache = null;
                }
                Circle.this.ky = value;
            }

            @Override
            public short getValue() {
                return Circle.this.ky;
            }

            @Override
            public short getMinValue() {
                return 1;
            }

            @Override
            public short getMaxValue() {
                return 2048;
            }
        }};
    }

    @Override
    public short getID() {
        return 3;
    }

    @Override
    public int getStepsToPlace() {
        return 2;
    }

    @Override
    public String getName() {
        return "Circle";
    }

    @Override
    public void move(short dx, short dy) {
        this.x = (short)(this.x + dx);
        this.y = (short)(this.y + dy);
        if (this.pointsCache != null) {
            this.pointsCache.movePoints(dx, dy);
        }
    }

    @Override
    public short[] getStartPoint() {
        if (Mathh.isPointOnArc(180, this.startAngle, this.arcAngle)) {
            return new short[]{(short)(this.x - this.r), this.y};
        }
        return StartPoint.compareAsStartPoints(this.getPointOnCircleByAngle(this.startAngle), this.getPointOnCircleByAngle(this.startAngle + this.arcAngle));
    }

    @Override
    public short[] getEndPoint() {
        if (Mathh.isPointOnArc(0, this.startAngle, this.arcAngle)) {
            return new short[]{(short)(this.x + this.r * this.kx / 100), this.y};
        }
        return EndPoint.compareAsEndPoints(this.getPointOnCircleByAngle(this.startAngle), this.getPointOnCircleByAngle(this.startAngle + this.arcAngle));
    }

    private short[] getPointOnCircleByAngle(int a) {
        return new short[]{(short)(this.x + Mathh.cos(a) * this.kx * this.r / 100000), (short)(this.y + Mathh.sin(a) * this.ky * this.r / 100000)};
    }

    @Override
    protected void genPoints() {
        int circleSegmentLen = 10000 / (140 + this.r);
        circleSegmentLen = Math.min(72, Math.max(10, circleSegmentLen));
        int pointsNumber = Math.abs(this.arcAngle) / circleSegmentLen + 1;
        if (this.arcAngle % circleSegmentLen != 0) {
            ++pointsNumber;
        }
        this.pointsCache = new AbstractCurve.PointsCache(this, pointsNumber);
        short startAngle = this.startAngle;
        if (this.arcAngle < 0) {
            circleSegmentLen = -circleSegmentLen;
        }
        for (int i = 0; i <= this.arcAngle && this.arcAngle > 0 || i >= this.arcAngle && this.arcAngle < 0; i += circleSegmentLen) {
            this.pointsCache.writePointToCache(this.getPointOnCircleByAngle(startAngle + i));
        }
        if (Math.abs(this.arcAngle) % Math.abs(circleSegmentLen) != 0) {
            this.pointsCache.writePointToCache(this.getPointOnCircleByAngle(startAngle + this.arcAngle));
        }
    }

    @Override
    protected int getArrowsDirection() {
        if (this.arcAngle == 360 || this.arcAngle == -360) {
            return 1;
        }
        return 0;
    }

    @Override
    public void paint(Graphics g, int zoomOut, int offsetX, int offsetY, boolean drawThickness, boolean drawAsSelected) {
        super.paint(g, zoomOut, offsetX, offsetY, drawThickness, drawAsSelected);
        int centerMarkR = 4;
        int leftX = this.xToPX(this.x - centerMarkR, zoomOut, offsetX);
        int rightX = this.xToPX(this.x + centerMarkR, zoomOut, offsetX);
        int topY = this.yToPX(this.y - centerMarkR, zoomOut, offsetY);
        int bottomY = this.yToPX(this.y + centerMarkR, zoomOut, offsetY);
        g.drawLine(leftX, topY, rightX, bottomY);
        g.drawLine(rightX, topY, leftX, bottomY);
    }

    @Override
    public void recalcCalculatedArgs() {
    }
}

