/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.elements;

import mobileapplication3.editor.elements.Accelerator;
import mobileapplication3.editor.elements.BrokenCircle;
import mobileapplication3.editor.elements.BrokenLine;
import mobileapplication3.editor.elements.Circle;
import mobileapplication3.editor.elements.EndPoint;
import mobileapplication3.editor.elements.Lava;
import mobileapplication3.editor.elements.LevelFinish;
import mobileapplication3.editor.elements.LevelStart;
import mobileapplication3.editor.elements.Line;
import mobileapplication3.editor.elements.Sine;
import mobileapplication3.editor.elements.Trampoline;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Property;

public abstract class Element {
    public static final short EOF = 0;
    public static final short END_POINT = 1;
    public static final short LINE = 2;
    public static final short CIRCLE = 3;
    public static final short BROKEN_LINE = 4;
    public static final short BROKEN_CIRCLE = 5;
    public static final short SINE = 6;
    public static final short ACCELERATOR = 7;
    public static final short TRAMPOLINE = 8;
    public static final short LEVEL_START = 9;
    public static final short LEVEL_FINISH = 10;
    public static final short LAVA = 11;
    public static final int[] ARGS_NUMBER = new int[]{0, 2, 4, 7, 9, 10, 6, 8, 6, 2, 5, 5};
    public static final int[] STEPS_TO_PLACE = new int[]{0, 1, 2, 2, 2, 2, 3, 2, 2, 1, 2, 2};
    public static final int LINE_THICKNESS = 24;
    public static final int COLOR_LANDSCAPE = 0x4444FF;
    public static final int COLOR_BODY = 0xFFFFFF;
    public static final int COLOR_SELECTED = 0xAAFFFF;

    protected Element() {
    }

    public Element createTypedInstance(short id, short[] args) throws IllegalArgumentException {
        if (args.length != ARGS_NUMBER[id]) {
            throw new IllegalArgumentException("Element with id=" + id + " can't have " + args.length + " args");
        }
        return Element.createTypedInstance(id).setArgs(args);
    }

    public static Element createTypedInstance(short id) throws IllegalArgumentException {
        if (id < 1) {
            throw new IllegalArgumentException("Element id can't be < 1");
        }
        switch (id) {
            case 1: {
                return new EndPoint();
            }
            case 2: {
                return new Line();
            }
            case 3: {
                return new Circle();
            }
            case 4: {
                return new BrokenLine();
            }
            case 5: {
                return new BrokenCircle();
            }
            case 6: {
                return new Sine();
            }
            case 7: {
                return new Accelerator();
            }
            case 8: {
                return new Trampoline();
            }
            case 9: {
                return new LevelStart();
            }
            case 10: {
                return new LevelFinish();
            }
            case 11: {
                return new Lava();
            }
        }
        Logger.log("Unknown id: " + id);
        return null;
    }

    public void printDebug() {
        short[] args = this.getArgsValues();
        StringBuffer sb = new StringBuffer();
        sb.append("id=" + this.getID());
        for (int i = 0; i < args.length; ++i) {
            sb.append(" " + args[i]);
        }
        Logger.log(sb.toString());
    }

    public static Element readFromData(short[] data) {
        short id = data[0];
        short[] args = new short[data.length - 1];
        System.arraycopy(data, 1, args, 0, args.length);
        if (id < 1) {
            throw new IllegalArgumentException("Element id can't be < 1");
        }
        if (args.length != ARGS_NUMBER[id]) {
            throw new IllegalArgumentException("Element with id=" + id + " can't have " + args.length + " args");
        }
        return Element.createTypedInstance(id).setArgs(args);
    }

    public int xToPX(int c, int zoomOut, int offsetX) {
        return c * 1000 / zoomOut + offsetX;
    }

    public int yToPX(int c, int zoomOut, int offsetY) {
        return c * 1000 / zoomOut + offsetY;
    }

    public static short calcDistance(short dx, short dy) {
        return Mathh.calcDistance(dx, dy);
    }

    public int getArgsCount() {
        return this.getArgsValues().length;
    }

    public int getDataLengthInShorts() {
        return 1 + this.getArgsCount();
    }

    public short[] getAsShortArray() {
        short[] args = this.getArgsValues();
        short[] arr = new short[args.length + 1];
        arr[0] = this.getID();
        System.arraycopy(args, 0, arr, 1, args.length);
        return arr;
    }

    public final PlacementStep[] getAllSteps() {
        PlacementStep[] placementSteps = this.getPlacementSteps();
        PlacementStep[] editSteps = this.getExtraEditingSteps();
        PlacementStep[] allSteps = new PlacementStep[placementSteps.length + editSteps.length];
        System.arraycopy(placementSteps, 0, allSteps, 0, placementSteps.length);
        System.arraycopy(editSteps, 0, allSteps, placementSteps.length, editSteps.length);
        return allSteps;
    }

    public Element clone() {
        if (this.getID() == 1 || this.getID() == 9) {
            return null;
        }
        Element clone = Element.createTypedInstance(this.getID());
        clone.setArgs(this.getArgsValues());
        return clone;
    }

    protected int getSuitableColor(boolean drawAsSelected) {
        if (drawAsSelected) {
            return 0xAAFFFF;
        }
        if (this.isBody()) {
            return 0xFFFFFF;
        }
        return 0x4444FF;
    }

    public static Property[] concatArrays(Property[] arr1, Property[] arr2) {
        Property[] result = new Property[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, result, 0, arr1.length);
        System.arraycopy(arr2, 0, result, arr1.length, arr2.length);
        return result;
    }

    public static void move(Element[] elements, int dx, int dy) {
        for (int i = 0; i < elements.length; ++i) {
            elements[i].move((short)dx, (short)dy);
        }
    }

    public abstract PlacementStep[] getPlacementSteps();

    public abstract PlacementStep[] getExtraEditingSteps();

    public abstract void paint(Graphics var1, int var2, int var3, int var4, boolean var5, boolean var6);

    public abstract Element setArgs(short[] var1);

    public abstract short[] getArgsValues();

    public abstract Property[] getArgs();

    public abstract short getID();

    public abstract int getStepsToPlace();

    public abstract String getName();

    public abstract void move(short var1, short var2);

    public abstract short[] getStartPoint();

    public abstract short[] getEndPoint() throws Exception;

    public abstract boolean isBody();

    public abstract void recalcCalculatedArgs();

    public abstract class PlacementStep {
        public abstract void place(short var1, short var2);

        public abstract String getName();

        public abstract String getCurrentStepInfo();
    }
}

