/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.elements;

import mobileapplication3.editor.elements.Element;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Property;

public class EndPoint
extends Element {
    private short x;
    private short y;

    @Override
    public Element.PlacementStep[] getPlacementSteps() {
        return new Element.PlacementStep[]{new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                EndPoint.this.x = pointX;
                EndPoint.this.y = pointY;
            }

            @Override
            public String getName() {
                return "Move";
            }

            @Override
            public String getCurrentStepInfo() {
                return "x=" + EndPoint.this.x + " y=" + EndPoint.this.y;
            }
        }};
    }

    @Override
    public Element.PlacementStep[] getExtraEditingSteps() {
        return new Element.PlacementStep[0];
    }

    @Override
    public void paint(Graphics g, int zoomOut, int offsetX, int offsetY, boolean drawThickness, boolean drawAsSelected) {
        int r = 3;
        int prevColor = g.getColor();
        g.setColor(0xFF0000);
        g.fillArc(this.xToPX(this.x, zoomOut, offsetX) - r, this.yToPX(this.y, zoomOut, offsetY) - r, r * 2, r * 2, 0, 360);
        g.setColor(prevColor);
    }

    @Override
    public Element setArgs(short[] args) {
        this.x = args[0];
        this.y = args[1];
        return this;
    }

    @Override
    public short[] getArgsValues() {
        short[] args = new short[]{this.x, this.y};
        return args;
    }

    @Override
    public Property[] getArgs() {
        return new Property[]{new Property("X"){

            @Override
            public void setValue(short value) {
                EndPoint.this.x = value;
            }

            @Override
            public short getValue() {
                return EndPoint.this.x;
            }
        }, new Property("Y"){

            @Override
            public void setValue(short value) {
                EndPoint.this.y = value;
            }

            @Override
            public short getValue() {
                return EndPoint.this.y;
            }
        }};
    }

    @Override
    public short getID() {
        return 1;
    }

    @Override
    public int getStepsToPlace() {
        return 1;
    }

    @Override
    public String getName() {
        return "End point";
    }

    @Override
    public void move(short dx, short dy) {
        this.x = (short)(this.x + dx);
        this.y = (short)(this.y + dy);
    }

    @Override
    public short[] getStartPoint() {
        return new short[]{this.x, this.y};
    }

    @Override
    public short[] getEndPoint() throws Exception {
        throw new Exception("Never ask end point its end point");
    }

    public static boolean compare(short[] oldEndPoint, short[] newEndPoint) {
        short oldX = oldEndPoint[0];
        short oldY = oldEndPoint[1];
        short newX = newEndPoint[0];
        short newY = newEndPoint[1];
        return newX >= oldX && (newX > oldX || newY > oldY);
    }

    public static short[] compareAsEndPoints(short[] a, short[] b) {
        if (EndPoint.compare(a, b)) {
            return b;
        }
        return a;
    }

    public static short[] findEndPoint(Element[] elements) {
        short[] endPoint;
        short[] mayBeEndPoint = endPoint = new short[]{0, 0};
        for (int i = 1; i < elements.length; ++i) {
            try {
                mayBeEndPoint = elements[i].getEndPoint();
                if (!EndPoint.compare(endPoint, mayBeEndPoint)) continue;
                endPoint = mayBeEndPoint;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return endPoint;
    }

    @Override
    public boolean isBody() {
        return false;
    }

    @Override
    public void recalcCalculatedArgs() {
    }
}

