/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.elements;

import mobileapplication3.editor.elements.Element;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Property;

public class LevelStart
extends Element {
    private short x;
    private short y;

    @Override
    public Element.PlacementStep[] getPlacementSteps() {
        return new Element.PlacementStep[]{new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                LevelStart.this.x = pointX;
                LevelStart.this.y = pointY;
            }

            @Override
            public String getName() {
                return "Move";
            }

            @Override
            public String getCurrentStepInfo() {
                return "Choose level start point: x=" + LevelStart.this.x + " y=" + LevelStart.this.y;
            }
        }};
    }

    @Override
    public Element.PlacementStep[] getExtraEditingSteps() {
        return new Element.PlacementStep[0];
    }

    @Override
    public void paint(Graphics g, int zoomOut, int offsetX, int offsetY, boolean drawThickness, boolean drawAsSelected) {
        int r = 3;
        int prevColor = g.getColor();
        if (!drawAsSelected) {
            g.setColor(65280);
        } else {
            g.setColor(this.getSuitableColor(drawAsSelected));
        }
        g.fillArc(this.xToPX(this.x, zoomOut, offsetX) - r, this.yToPX(this.y, zoomOut, offsetY) - r, r * 2, r * 2, 0, 360);
        g.setColor(prevColor);
    }

    @Override
    public Element setArgs(short[] args) {
        this.x = args[0];
        this.y = args[1];
        return this;
    }

    @Override
    public short[] getArgsValues() {
        short[] args = new short[]{this.x, this.y};
        return args;
    }

    @Override
    public Property[] getArgs() {
        return new Property[]{new Property("X"){

            @Override
            public void setValue(short value) {
                LevelStart.this.x = value;
            }

            @Override
            public short getValue() {
                return LevelStart.this.x;
            }
        }, new Property("Y"){

            @Override
            public void setValue(short value) {
                LevelStart.this.y = value;
            }

            @Override
            public short getValue() {
                return LevelStart.this.y;
            }
        }};
    }

    @Override
    public short getID() {
        return 9;
    }

    @Override
    public int getStepsToPlace() {
        return STEPS_TO_PLACE[this.getID()];
    }

    @Override
    public String getName() {
        return "Level Start";
    }

    @Override
    public void move(short dx, short dy) {
        this.x = (short)(this.x + dx);
        this.y = (short)(this.y + dy);
    }

    @Override
    public short[] getStartPoint() {
        return new short[]{this.x, this.y};
    }

    @Override
    public short[] getEndPoint() {
        return new short[]{this.x, this.y};
    }

    @Override
    public boolean isBody() {
        return false;
    }

    @Override
    public void recalcCalculatedArgs() {
    }
}

