/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.elements;

import mobileapplication3.editor.elements.Element;
import mobileapplication3.editor.elements.EndPoint;
import mobileapplication3.editor.elements.StartPoint;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Property;

public class Line
extends Element {
    protected short x1;
    protected short y1;
    protected short x2;
    protected short y2;

    @Override
    public Element.PlacementStep[] getPlacementSteps() {
        return new Element.PlacementStep[]{new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                int dx = pointX - Line.this.x1;
                int dy = pointY - Line.this.y1;
                Line.this.setStartPoint(pointX, pointY);
                Line.this.setEndPoint((short)(Line.this.x2 + dx), (short)(Line.this.y2 + dy));
            }

            @Override
            public String getName() {
                return "Move";
            }

            @Override
            public String getCurrentStepInfo() {
                return "x1=" + Line.this.x1 + " y1=" + Line.this.y1;
            }
        }, new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                Line.this.setEndPoint(pointX, pointY);
            }

            @Override
            public String getName() {
                return "Move end point";
            }

            @Override
            public String getCurrentStepInfo() {
                return "x1=" + Line.this.x1 + " y1=" + Line.this.y1 + "; x2=" + Line.this.x2 + " y2=" + Line.this.y2;
            }
        }};
    }

    @Override
    public Element.PlacementStep[] getExtraEditingSteps() {
        return new Element.PlacementStep[]{new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                Line.this.setStartPoint(pointX, pointY);
            }

            @Override
            public String getName() {
                return "Move start point";
            }

            @Override
            public String getCurrentStepInfo() {
                return "x1=" + Line.this.x1 + " y1=" + Line.this.y1;
            }
        }};
    }

    public void setStartPoint(short x, short y) {
        this.x1 = x;
        this.y1 = y;
    }

    public void setEndPoint(short x, short y) {
        this.x2 = x;
        this.y2 = y;
    }

    @Override
    public void paint(Graphics g, int zoomOut, int offsetX, int offsetY, boolean drawThickness, boolean drawAsSelected) {
        g.setColor(this.getSuitableColor(drawAsSelected));
        g.drawLine(this.xToPX(this.x1, zoomOut, offsetX), this.yToPX(this.y1, zoomOut, offsetY), this.xToPX(this.x2, zoomOut, offsetX), this.yToPX(this.y2, zoomOut, offsetY), 24, zoomOut, drawThickness, true, true, true);
    }

    @Override
    public Element setArgs(short[] args) {
        this.x1 = args[0];
        this.y1 = args[1];
        this.x2 = args[2];
        this.y2 = args[3];
        return this;
    }

    @Override
    public short[] getArgsValues() {
        short[] args = new short[]{this.x1, this.y1, this.x2, this.y2};
        return args;
    }

    @Override
    public Property[] getArgs() {
        return new Property[]{new Property("X1"){

            @Override
            public void setValue(short value) {
                Line.this.x1 = value;
            }

            @Override
            public short getValue() {
                return Line.this.x1;
            }
        }, new Property("Y1"){

            @Override
            public void setValue(short value) {
                Line.this.y1 = value;
            }

            @Override
            public short getValue() {
                return Line.this.y1;
            }
        }, new Property("X2"){

            @Override
            public void setValue(short value) {
                Line.this.x2 = value;
            }

            @Override
            public short getValue() {
                return Line.this.x2;
            }
        }, new Property("Y2"){

            @Override
            public void setValue(short value) {
                Line.this.y2 = value;
            }

            @Override
            public short getValue() {
                return Line.this.y2;
            }
        }};
    }

    @Override
    public short getID() {
        return 2;
    }

    @Override
    public int getStepsToPlace() {
        return 2;
    }

    @Override
    public String getName() {
        return "Line";
    }

    @Override
    public void move(short dx, short dy) {
        this.x1 = (short)(this.x1 + dx);
        this.y1 = (short)(this.y1 + dy);
        this.x2 = (short)(this.x2 + dx);
        this.y2 = (short)(this.y2 + dy);
    }

    private short[][] getEnds() {
        return new short[][]{{this.x1, this.y1}, {this.x2, this.y2}};
    }

    @Override
    public short[] getStartPoint() {
        short[][] ends = this.getEnds();
        return StartPoint.compareAsStartPoints(ends[0], ends[1]);
    }

    @Override
    public short[] getEndPoint() {
        short[][] ends = this.getEnds();
        return EndPoint.compareAsEndPoints(ends[0], ends[1]);
    }

    @Override
    public boolean isBody() {
        return false;
    }

    @Override
    public void recalcCalculatedArgs() {
    }
}

