/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.elements;

import mobileapplication3.editor.elements.AbstractCurve;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.editor.elements.EndPoint;
import mobileapplication3.editor.elements.StartPoint;
import mobileapplication3.platform.Mathh;
import mobileapplication3.ui.Property;

public class Sine
extends AbstractCurve {
    private static final int STEP = 30;
    private short x0;
    private short y0;
    private short l;
    private short halfperiods = 1;
    private short offset = (short)270;
    private short amp;
    private short anchorX;
    private short anchorY;

    @Override
    public Element.PlacementStep[] getPlacementSteps() {
        return new Element.PlacementStep[]{new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                Sine.this.setAnchorPoint(pointX, pointY);
            }

            @Override
            public String getName() {
                return "Move start point";
            }

            @Override
            public String getCurrentStepInfo() {
                return "x0=" + Sine.this.x0 + " y0=" + Sine.this.y0;
            }
        }, new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                Sine.this.setLength((short)(pointX - Sine.this.x0));
                int sinoffset = Mathh.sin(-Sine.this.offset);
                int amp = Sine.this.anchorY - pointY;
                if (sinoffset != 0) {
                    amp = amp * 1000 / sinoffset;
                }
                Sine.this.setAmplitude((short)(amp / 2));
                Sine.this.calcZeroPoint();
            }

            @Override
            public String getName() {
                return "Change length and amplitude";
            }

            @Override
            public String getCurrentStepInfo() {
                return "l=" + Sine.this.l;
            }
        }, new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                int dx = pointX - Sine.this.anchorX;
                if (dx * Sine.this.l > 0) {
                    Sine.this.setHalfperiodsNumber((short)Math.max(1, Sine.this.l / dx));
                }
            }

            @Override
            public String getName() {
                return "Change number of halfperiods";
            }

            @Override
            public String getCurrentStepInfo() {
                return "halfperiods=" + Sine.this.halfperiods;
            }
        }};
    }

    @Override
    public Element.PlacementStep[] getExtraEditingSteps() {
        return new Element.PlacementStep[]{new Element.PlacementStep(){

            @Override
            public void place(short pointX, short pointY) {
                int dx = pointX - Sine.this.anchorX;
                Sine.this.setOffset((short)(dx * Sine.this.halfperiods * 180 / Sine.this.l + 90));
            }

            @Override
            public String getName() {
                return "Change phase shift";
            }

            @Override
            public String getCurrentStepInfo() {
                return "offset=" + Sine.this.offset;
            }
        }};
    }

    public void setAnchorPoint(short x, short y) {
        if (this.anchorX == x && this.anchorY == y) {
            return;
        }
        this.pointsCache = null;
        this.anchorX = x;
        this.anchorY = y;
        this.calcZeroPoint();
    }

    public void calcZeroPoint() {
        this.setZeroPoint(this.anchorX, (short)(this.anchorY - this.amp * Mathh.sin(-this.offset) / 1000));
    }

    public void calcAnchorPoint() {
        this.setAnchorPoint(this.x0, (short)(this.y0 + this.amp * Mathh.sin(-this.offset) / 1000));
    }

    public void setZeroPoint(short x, short y) {
        if (this.x0 == x && this.y0 == y) {
            return;
        }
        this.pointsCache = null;
        this.x0 = x;
        this.y0 = y;
        this.calcAnchorPoint();
    }

    public void setLength(short l) {
        if (this.l == l) {
            return;
        }
        this.pointsCache = null;
        this.l = l;
    }

    public void setHalfperiodsNumber(short n) {
        if (this.halfperiods == n) {
            return;
        }
        this.pointsCache = null;
        this.halfperiods = n;
    }

    public void setOffset(short offset) throws IllegalArgumentException {
        if (this.offset == offset) {
            return;
        }
        this.pointsCache = null;
        this.offset = offset = (short)Mathh.normalizeAngle(offset);
        this.calcZeroPoint();
    }

    public void setAmplitude(short a) {
        if (this.amp == a) {
            return;
        }
        this.pointsCache = null;
        this.amp = a;
    }

    @Override
    public Element setArgs(short[] args) {
        this.setZeroPoint(args[0], args[1]);
        this.setLength(args[2]);
        this.setHalfperiodsNumber(args[3]);
        this.setOffset(-args[4]);
        this.setAmplitude(args[5]);
        this.pointsCache = null;
        this.recalcCalculatedArgs();
        return this;
    }

    @Override
    public short[] getArgsValues() {
        return new short[]{this.x0, this.y0, this.l, this.halfperiods, (short)Mathh.normalizeAngle(-this.offset), this.amp};
    }

    @Override
    public Property[] getArgs() {
        return new Property[]{new Property("X0"){

            @Override
            public void setValue(short value) {
                if (Sine.this.x0 != value) {
                    Sine.this.pointsCache = null;
                }
                Sine.this.x0 = value;
                Sine.this.calcAnchorPoint();
            }

            @Override
            public short getValue() {
                return Sine.this.x0;
            }
        }, new Property("Y0"){

            @Override
            public void setValue(short value) {
                if (Sine.this.y0 != value) {
                    Sine.this.pointsCache = null;
                }
                Sine.this.y0 = value;
            }

            @Override
            public short getValue() {
                return Sine.this.y0;
            }
        }, new Property("Length"){

            @Override
            public void setValue(short value) {
                Sine.this.setLength(value);
            }

            @Override
            public short getValue() {
                return Sine.this.l;
            }

            @Override
            public short getMinValue() {
                return -Sine.this.x0;
            }

            @Override
            public short getMaxValue() {
                return (short)(Short.MAX_VALUE - Sine.this.x0);
            }
        }, new Property("Halfperiods"){

            @Override
            public void setValue(short value) {
                Sine.this.setHalfperiodsNumber(value);
            }

            @Override
            public short getValue() {
                return Sine.this.halfperiods;
            }

            @Override
            public short getMinValue() {
                return 1;
            }

            @Override
            public short getMaxValue() {
                return (short)(Sine.this.l / 64);
            }
        }, new Property("Phase shift"){

            @Override
            public void setValue(short value) {
                Sine.this.setOffset(value);
            }

            @Override
            public short getValue() {
                return Sine.this.offset;
            }

            @Override
            public short getMaxValue() {
                return 360;
            }

            @Override
            public short getMinValue() {
                return 0;
            }
        }, new Property("Amplitude"){

            @Override
            public void setValue(short value) {
                Sine.this.setAmplitude(value);
            }

            @Override
            public short getValue() {
                return Sine.this.amp;
            }
        }};
    }

    @Override
    public short getID() {
        return 6;
    }

    @Override
    public int getStepsToPlace() {
        return 3;
    }

    @Override
    public String getName() {
        return "Sine";
    }

    @Override
    public void move(short dx, short dy) {
        this.anchorX = (short)(this.anchorX + dx);
        this.anchorY = (short)(this.anchorY + dy);
        this.x0 = (short)(this.x0 + dx);
        this.y0 = (short)(this.y0 + dy);
        if (this.pointsCache != null) {
            this.pointsCache.movePoints(dx, dy);
        }
    }

    private short[][] getEnds() {
        return new short[][]{{this.anchorX, this.anchorY}, {(short)(this.x0 + this.l), (short)(this.y0 + this.amp * Mathh.sin(180 * this.halfperiods - this.offset) / 1000)}};
    }

    @Override
    public short[] getStartPoint() {
        short[][] ends = this.getEnds();
        return StartPoint.compareAsStartPoints(ends[0], ends[1]);
    }

    @Override
    public short[] getEndPoint() {
        short[][] ends = this.getEnds();
        return EndPoint.compareAsEndPoints(ends[0], ends[1]);
    }

    @Override
    protected void genPoints() {
        if (this.amp == 0) {
            this.pointsCache = new AbstractCurve.PointsCache(2);
            this.pointsCache.writePointToCache(this.x0, this.y0);
            this.pointsCache.writePointToCache(this.x0 + this.l, this.y0);
        } else {
            int nextPointY;
            int nextPointX;
            int startA = 360 - this.offset;
            int endA = 360 + this.halfperiods * 180 - this.offset;
            int a = endA - startA;
            this.pointsCache = new AbstractCurve.PointsCache(1 + this.halfperiods * 6);
            for (int i = startA; i <= endA; i += 30) {
                nextPointX = this.x0 + (i - startA) * this.l / a;
                nextPointY = this.y0 + this.amp * Mathh.sin(i) / 1000;
                this.pointsCache.writePointToCache(nextPointX, nextPointY);
            }
            if (a % 30 != 0) {
                nextPointX = this.x0 + this.l;
                nextPointY = this.y0 + this.amp * Mathh.sin(endA) / 1000;
                this.pointsCache.writePointToCache(nextPointX, nextPointY);
            }
        }
    }

    @Override
    public void recalcCalculatedArgs() {
        this.calcAnchorPoint();
    }

    @Override
    protected int getArrowsDirection() {
        return 1;
    }
}

