/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.setup;

import mobileapplication3.editor.EditorSettings;
import mobileapplication3.editor.setup.AbstractSetupWizardPage;
import mobileapplication3.editor.setup.SetupWizard;
import mobileapplication3.platform.FileUtils;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.AbstractPopupPage;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonCol;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.UIComponent;

public class Page5
extends AbstractSetupWizardPage {
    private final ButtonCol list = new ButtonCol(){

        @Override
        public boolean handlePointerClicked(int x, int y) {
            super.handlePointerClicked(x, y);
            return false;
        }
    };
    private Button[] listButtons;

    public Page5(Button[] buttons, SetupWizard.Feedback feedback) {
        super("Let's choose the game folder", buttons, feedback);
    }

    @Override
    public void init() {
        super.init();
        this.actionButtons.setSelected(this.actionButtons.getButtonCount() - 1);
        this.actionButtons.buttons[1] = new Button("Finish"){

            @Override
            public void buttonPressed() {
                Page5.this.saveFolderChoice(Page5.this.listButtons[Page5.this.list.getSelected()].getTitle());
            }
        };
        this.list.setIsSelectionVisible(true);
    }

    @Override
    public void initOnFirstShow() {
        this.fillList();
        this.list.setButtonsBgPadding(this.margin / 4);
    }

    private void fillList() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String[] folders = FileUtils.getAllPlaces("MobappGame");
                Page5.access$002(Page5.this, new Button[folders.length]);
                for (int i = 0; i < folders.length; ++i) {
                    ((Page5)Page5.this).listButtons[i] = new Button(folders[i]){

                        @Override
                        public void buttonPressed() {
                        }
                    };
                }
                Page5.this.list.setButtons(Page5.this.listButtons);
                Page5.this.list.setSelected(((Page5)Page5.this).list.buttons.length - 1);
                if (Page5.this.w != 0 && Page5.this.h != 0) {
                    Page5.this.onSetBounds(Page5.this.x0, Page5.this.y0, Page5.this.w, Page5.this.h / 2);
                    Page5.this.onSetBounds(Page5.this.x0, Page5.this.y0, Page5.this.w, Page5.this.h);
                }
                Page5.this.feedback.needRepaint();
            }
        }).start();
    }

    private void saveFolderChoice(final String path) {
        this.showPopup(new LoadingPopup("Checking folder...", this));
        new Thread(new Runnable(){
            String folderPath;

            @Override
            public void run() {
                this.folderPath = null;
                try {
                    this.folderPath = EditorSettings.getStructsFolderPath(path);
                    FileUtils.createFolder(this.folderPath);
                }
                catch (Throwable ex) {
                    Page5.this.closePopup();
                    Platform.showError("Can't create folder \"" + this.folderPath + ": ", ex);
                }
                this.folderPath = null;
                try {
                    this.folderPath = EditorSettings.getLevelsFolderPath(path);
                    Logger.log("creating subfolder: " + this.folderPath);
                    FileUtils.createFolder(this.folderPath);
                }
                catch (Throwable ex) {
                    Page5.this.closePopup();
                    Platform.showError("Can't create folder \"" + this.folderPath + "\": ", ex);
                }
                try {
                    FileUtils.checkFolder(path);
                    EditorSettings.setGameFolderPath(path);
                    Page5.this.feedback.nextPage();
                }
                catch (Exception ex) {
                    Page5.this.closePopup();
                    Platform.showError("Can't create file in this folder: ", ex);
                }
            }
        }).start();
    }

    @Override
    public void setPageContentBounds(IUIComponent pageContent, int x0, int y0, int w, int h) {
        if (pageContent != null) {
            ((ButtonCol)pageContent).setSizes(w - this.margin * 2, h - this.margin * 2, -1, true).setPos(x0 + w / 2, y0 + h - this.margin, 33);
        }
    }

    @Override
    protected IUIComponent initAndGetPageContent() {
        return this.list;
    }

    @Override
    protected void refreshFocusedComponents() {
        super.refreshFocusedComponents();
        this.list.setFocused(true);
    }

    static /* synthetic */ Button[] access$002(Page5 x0, Button[] x1) {
        x0.listButtons = x1;
        return x1;
    }

    private static class LoadingPopup
    extends AbstractPopupPage {
        int animOffset = 100;

        public LoadingPopup(String title, IPopupFeedback parent) {
            super(title, parent);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (this.hasParent()) {
                            animOffset += 10;
                            this.repaint();
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }, "loading anim").start();
        }

        @Override
        public boolean canBeFocused() {
            return true;
        }

        @Override
        protected Button[] getActionButtons() {
            return new Button[]{new Button("Cancel"){

                @Override
                public void buttonPressed() {
                }
            }.setIsActive(false)};
        }

        @Override
        protected IUIComponent initAndGetPageContent() {
            return new UIComponent(){

                @Override
                protected boolean handlePointerClicked(int x, int y) {
                    return false;
                }

                @Override
                protected boolean handleKeyPressed(int keyCode, int count) {
                    return false;
                }

                @Override
                public void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
                    g.setColor(0xFFFFFF);
                    int side = Math.min(w, h);
                    g.drawArc(x0 + (w - side) / 2, y0 + (h - side) / 2, side, side, animOffset % 360, (animOffset + 250) % 360);
                    g.drawString("Please", x0 + w / 2, y0 + h / 2, 33);
                    g.drawString("wait....", x0 + w / 2, y0 + h / 2, 17);
                }

                @Override
                public boolean canBeFocused() {
                    return false;
                }
            };
        }
    }
}

