/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor.setup;

import mobileapplication3.editor.EditorSettings;
import mobileapplication3.editor.setup.AbstractSetupWizardPage;
import mobileapplication3.editor.setup.Page1;
import mobileapplication3.editor.setup.Page2;
import mobileapplication3.editor.setup.Page3;
import mobileapplication3.editor.setup.Page4;
import mobileapplication3.editor.setup.Page5;
import mobileapplication3.platform.Logger;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.Container;
import mobileapplication3.ui.IUIComponent;

public class SetupWizard
extends Container {
    private int currentPageI = 0;
    private final FinishSetup finishSetup;
    private final Feedback pageSwitcher = new Feedback(){

        @Override
        public void nextPage() {
            Logger.log(SetupWizard.this.currentPageI + " - current. switching to next page");
            SetupWizard.this.setCurrentPage(SetupWizard.this.currentPageI + 1);
        }

        @Override
        public void prevPage() {
            Logger.log(SetupWizard.this.currentPageI + " - current. switching to prev page");
            SetupWizard.this.setCurrentPage(SetupWizard.this.currentPageI - 1);
        }

        @Override
        public void needRepaint() {
            SetupWizard.this.repaint();
        }
    };
    private AbstractSetupWizardPage[] pages;

    public SetupWizard(FinishSetup finishSetup) {
        this.finishSetup = finishSetup;
        this.pages = new AbstractSetupWizardPage[]{new Page1(new Button[]{this.getNewNextButton()}, this.pageSwitcher), new Page2(new Button[]{this.getNewPrevButton(), this.getNewNextButton()}, this.pageSwitcher), new Page3(new Button[]{this.getNewPrevButton(), this.getNewNextButton()}, this.pageSwitcher), new Page4(new Button[]{this.getNewPrevButton(), this.getNewNextButton()}, this.pageSwitcher), new Page5(new Button[]{this.getNewPrevButton(), this.getNewNextButton()}, this.pageSwitcher)};
    }

    @Override
    public void init() {
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i].setParent(this);
        }
        this.setCurrentPage(this.currentPageI);
    }

    private Button getNewNextButton() {
        return new Button("Next"){

            @Override
            public void buttonPressed() {
                SetupWizard.this.pageSwitcher.nextPage();
            }
        };
    }

    private Button getNewPrevButton() {
        return new Button("Back"){

            @Override
            public void buttonPressed() {
                SetupWizard.this.pageSwitcher.prevPage();
            }
        };
    }

    private void setCurrentPage(int i) {
        Logger.log("setting page i=" + i);
        this.pages[this.currentPageI].setParent(this);
        this.pages[this.currentPageI].setVisible(false);
        if (i < 0) {
            return;
        }
        if (i >= this.pages.length) {
            this.finishSetup();
            return;
        }
        this.currentPageI = i;
        this.pages[this.currentPageI].onShow();
        this.pages[this.currentPageI].setVisible(true);
        this.setComponents(new IUIComponent[]{this.pages[this.currentPageI]});
        if (this.w != 0 && this.h != 0) {
            this.setSize(this.w, this.h);
        }
    }

    private void finishSetup() {
        this.pages = null;
        this.finishSetup.onFinish();
        EditorSettings.setIsSetupWizardCompleted(true);
    }

    @Override
    public void onSetBounds(int x0, int y0, int w, int h) {
        this.pages[this.currentPageI].setSize(w, h);
    }

    public static interface Feedback {
        public void nextPage();

        public void prevPage();

        public void needRepaint();
    }

    public static interface FinishSetup {
        public void onFinish();
    }
}

