/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.game;

import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;
import java.io.IOException;
import mobileapplication3.game.GameplayCanvas;
import mobileapplication3.game.GenericMenu;
import mobileapplication3.game.GraphicsWorld;
import mobileapplication3.game.SettingsScreen;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.Image;
import mobileapplication3.platform.ui.RootContainer;

public class AboutScreen
extends GenericMenu
implements Runnable {
    private static final String URL = "https://github.com/vipaoL/mobap-game";
    private static final String URL_PREVIEW = "GitHub: vipaoL/mobap-game";
    private static final String URL2 = "https://t.me/mobapp_game";
    private static final String URL2_PREVIEW = "TG: @mobapp_game";
    private static final String[] STRINGS = new String[]{"A cross-platform game", "on emini physics engine"};
    private static final String COMMIT_HASH = Platform.getAppProperty("Commit");
    private static final String[] MENU_OPTS = new String[]{"", "GitHub: vipaoL/mobap-game", "TG: @mobapp_game", "Version: " + Platform.getAppVersion() + (COMMIT_HASH != null ? "-" + COMMIT_HASH : ""), "Back"};
    private Image qr;
    private Image qrBig;
    private int w;
    private int h;
    private int headerH;
    private int qrSide;
    private int menuH;
    private boolean bigQRIsDrawn = false;
    private int counter = 17;

    @Override
    public void init() {
        this.loadParams(MENU_OPTS, MENU_OPTS.length - 1);
        this.setFirstDrawable(1);
    }

    @Override
    public void postInit() {
        new Thread((Runnable)this, "about").start();
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        super.onSetBounds(x0, y0, w, h);
        if (this.w == w && this.h == h && this.qr != null) {
            return;
        }
        this.w = w;
        this.h = h;
        this.qrSide = Math.min(this.h / 2, this.h - new Font(8).getHeight() * (STRINGS.length + MENU_OPTS.length));
        this.qrSide = Math.max(this.qrSide, 66);
        this.qrSide = Math.min(this.qrSide, w * 7 / 8);
        int totalTextH = this.h - this.qrSide;
        this.menuH = totalTextH * (MENU_OPTS.length - 1) / (MENU_OPTS.length - 1 + STRINGS.length);
        this.headerH = totalTextH - this.menuH;
        this.loadCanvasParams(0, h - this.menuH, this.w, this.menuH);
        try {
            this.qr = Image.createImage("/qr.png").scale(this.qrSide, this.qrSide);
        }
        catch (IOException ex) {
            try {
                this.qr = Image.createImage("resource://qr.png").scale(this.qrSide, this.qrSide);
            }
            catch (IOException e) {
                ex.printStackTrace();
                e.printStackTrace();
            }
        }
        try {
            this.qrBig = Image.createImage("/qr.png").scale(Math.min(this.w, this.h), Math.min(this.w, this.h));
        }
        catch (IOException ex) {
            try {
                this.qrBig = Image.createImage("resource://qr.png").scale(Math.min(this.w, this.h), Math.min(this.w, this.h));
            }
            catch (IOException e) {
                ex.printStackTrace();
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        while (!this.isStopped) {
            long sleep;
            if (!this.isPaused) {
                long start = System.currentTimeMillis();
                this.repaint();
                sleep = 50L - (System.currentTimeMillis() - start);
                sleep = Math.max(sleep, 0L);
            } else {
                sleep = 200L;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (this.bigQRIsDrawn) {
            return;
        }
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.w, this.h);
        this.drawHeader(g);
        this.drawQR(g);
        super.onPaint(g, x0, y0 + h - this.menuH, w, this.menuH, forceInactive);
        this.tick();
        if (this.selected == 0) {
            this.drawBigQR(g);
        } else {
            this.bigQRIsDrawn = false;
        }
    }

    private void drawHeader(Graphics g) {
        g.setColor(0xFFFFFF);
        int dY = this.headerH / (STRINGS.length + 1);
        for (int i = 0; i < STRINGS.length; ++i) {
            int y = (i + 1) * dY;
            g.drawString(STRINGS[i], this.w / 2, y, 3);
        }
    }

    private void drawQR(Graphics g) {
        if (this.selected != 0) {
            try {
                g.drawImage(this.qr, this.w / 2, this.headerH, 17);
            }
            catch (NullPointerException ex) {
                int leftX = this.w / 2 - this.qrSide / 2;
                int topY = this.headerH;
                int d = this.qrSide;
                while (d > 0) {
                    int c = 255 - 255 * d / this.qrSide;
                    g.setColor(c, c, c);
                    g.fillRect(leftX, topY, d, d);
                    d -= 2;
                    ++topY;
                    ++leftX;
                }
                int x = this.w / 2;
                int y = this.headerH + this.qrSide / 2;
                g.setColor(0);
                g.drawString("Your ad", x, y, 33);
                g.drawString("could be here.", x, y, 17);
            }
        }
    }

    private void drawBigQR(Graphics g) {
        try {
            g.drawImage(this.qrBig, this.w / 2, this.h / 2, 3);
        }
        catch (NullPointerException ex) {
            this.bigQRIsDrawn = true;
        }
    }

    private void openLink(String url) {
        Logger.log(url);
        if (Platform.platformRequest(url)) {
            Platform.exit();
        }
    }

    @Override
    protected void selectPressed() {
        int selected = this.selected;
        if (selected == MENU_OPTS.length - 4) {
            this.openLink(URL);
        }
        if (selected == MENU_OPTS.length - 3) {
            this.openLink(URL2);
        }
        if (selected == MENU_OPTS.length - 2) {
            ++this.counter;
            if (this.counter >= 20) {
                this.isStopped = true;
                World test3 = new World();
                test3.setGravity(FXVector.newVector(10, 100));
                GraphicsWorld.bgOverride = true;
                GraphicsWorld test2 = new GraphicsWorld(test3);
                GameplayCanvas test = new GameplayCanvas(test2).disablePointCounter();
                test.uninterestingDebug = true;
                RootContainer.setRootUIComponent(test);
            }
        }
        if (selected == MENU_OPTS.length - 1) {
            this.isStopped = true;
            RootContainer.setRootUIComponent(new SettingsScreen());
        }
    }
}

