/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.game;

import mobileapplication3.game.GenericMenu;
import mobileapplication3.game.GraphicsWorld;
import mobileapplication3.game.SettingsScreen;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Sound;
import mobileapplication3.platform.ui.RootContainer;
import utils.MobappGameSettings;

public class DebugMenu
extends GenericMenu
implements Runnable {
    private static final String[] MENU_OPTS = new String[]{"Enable debug", "Show log", "Structure debug", "Simulation mode", "GAMING MODE", "What?", "Physics precision", "Music", "Back"};
    public static boolean isDebugEnabled = false;
    public static boolean closerWorldgen = false;
    public static boolean coordinates = false;
    public static boolean discoMode = false;
    public static boolean speedo = false;
    public static boolean cheat = false;
    public static boolean music = false;
    public static boolean showFontSize = false;
    public static boolean mgstructOnly = false;
    public static boolean dontCountFlips = false;
    public static boolean showAngle = false;
    public static boolean showLinePoints = false;
    public static boolean simulationMode = false;
    public static boolean whatTheGame = false;
    public static boolean showContacts = false;
    public static boolean structureDebug = false;

    public DebugMenu() {
        this.loadParams(MENU_OPTS);
        this.loadStatemap(new int[MENU_OPTS.length]);
    }

    @Override
    public void init() {
        this.getFontSize();
        this.setSpecialOption(0);
        this.refreshStates();
        new Thread((Runnable)this, "debug menu").start();
    }

    @Override
    public void run() {
        while (!this.isStopped) {
            long sleep;
            if (!this.isPaused) {
                long start = System.currentTimeMillis();
                this.repaint();
                this.tick();
                sleep = 50L - (System.currentTimeMillis() - start);
                sleep = Math.max(sleep, 0L);
            } else {
                sleep = 200L;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    void selectPressed() {
        int selected = this.selected;
        switch (selected) {
            case 0: {
                coordinates = isDebugEnabled = !isDebugEnabled;
                this.setIsSpecialOptnActivated(isDebugEnabled);
                Logger.logToStdout(isDebugEnabled);
                break;
            }
            case 1: {
                boolean bl = RootContainer.enableOnScreenLog = !RootContainer.enableOnScreenLog;
                if (RootContainer.enableOnScreenLog) {
                    Logger.enableOnScreenLog(this.h);
                    break;
                }
                Logger.disableOnScreenLog();
                break;
            }
            case 2: {
                structureDebug = !structureDebug;
                break;
            }
            case 3: {
                simulationMode = !simulationMode;
                break;
            }
            case 4: {
                GraphicsWorld.bgOverride = discoMode = !discoMode;
                break;
            }
            case 5: {
                whatTheGame = !whatTheGame;
                break;
            }
            case 6: {
                int value = MobappGameSettings.getPhysicsPrecision();
                if (value == 0) {
                    value = 1;
                } else if ((value *= 2) > 16) {
                    value = 0;
                }
                MobappGameSettings.setPhysicsPrecision(value);
                break;
            }
            case 7: {
                boolean bl = music = !music;
                if (!music) break;
                Sound sound = new Sound();
                sound.start();
                break;
            }
        }
        if (selected == MENU_OPTS.length - 1) {
            this.isStopped = true;
            RootContainer.setRootUIComponent(new SettingsScreen());
        } else {
            this.refreshStates();
        }
    }

    void refreshStates() {
        int physicsPrecision = MobappGameSettings.getPhysicsPrecision();
        DebugMenu.MENU_OPTS[6] = "Physics precision: ";
        MENU_OPTS[6] = physicsPrecision == 0 ? MENU_OPTS[6] + "Auto" : (physicsPrecision == -1 ? MENU_OPTS[6] + "Dynamic" : MENU_OPTS[6] + String.valueOf(physicsPrecision));
        this.setIsSpecialOptnActivated(isDebugEnabled);
        this.setEnabledFor(RootContainer.enableOnScreenLog, 1);
        this.setEnabledFor(structureDebug, 2);
        this.setEnabledFor(simulationMode, 3);
        this.setEnabledFor(discoMode, 4);
        this.setEnabledFor(whatTheGame, 5);
        this.setEnabledFor(physicsPrecision != 0, 6);
        this.setStateFor(-1, 7);
    }
}

