/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.game;

import at.emini.physics2D.Body;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.Shape;
import at.emini.physics2D.util.FXVector;
import mobileapplication3.game.GraphicsWorld;
import mobileapplication3.game.MUserData;
import mobileapplication3.game.WorldGen;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Mathh;
import utils.MobappGameSettings;

public class ElementPlacer {
    public static final short EOF = 0;
    public static final short END_POINT = 1;
    public static final short LINE = 2;
    public static final short CIRCLE = 3;
    public static final short BROKEN_LINE = 4;
    public static final short BROKEN_CIRCLE = 5;
    public static final short SINE = 6;
    public static final short ACCELERATOR = 7;
    public static final short TRAMPOLINE = 8;
    public static final short LEVEL_START = 9;
    public static final short LEVEL_FINISH = 10;
    public static final short LAVA = 11;
    public static final int DRAWING_DATA_ID_LINE = 1;
    public static final int DRAWING_DATA_ID_PATH = 2;
    public static final int DRAWING_DATA_ID_CIRCLE = 3;
    public static final int DRAWING_DATA_ID_ARC = 4;
    private static final int DETAIL_LEVEL = ElementPlacer.readDetailLevelSetting();
    private int lineCount = 0;
    private final GraphicsWorld w;
    private final Landscape landscape;
    private final boolean dontPlaceBodies;
    private int[] drawingData;

    public ElementPlacer(GraphicsWorld world, boolean dontPlaceBodies) {
        this.w = world;
        this.landscape = world.getLandscape();
        this.dontPlaceBodies = dontPlaceBodies;
        this.drawingData = null;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void place(short[] data, int originX, int originY) {
        int prevLowestY = this.w.lowestY;
        short id = data[0];
        switch (id) {
            case 2: {
                this.line(originX + data[1], originY + data[2], originX + data[3], originY + data[4]);
                break;
            }
            case 3: {
                this.arc(originX + data[1], originY + data[2], data[3], data[4], data[5], data[6] / 10, data[7] / 10);
                break;
            }
            case 4: {
                if (this.dontPlaceBodies) break;
                short x1 = data[1];
                short y1 = data[2];
                short x2 = data[3];
                short y2 = data[4];
                int dx = x2 - x1;
                int dy = y2 - y1;
                short platfH = data[5];
                short platfL = data[6];
                short spacing = data[7];
                short l = data[8];
                short ang = data[9];
                int n = (l + spacing) / (platfL + spacing);
                Shape rect = Shape.createRectangle(platfL, platfH);
                rect.setMass(1);
                rect.setFriction(10);
                rect.setElasticity(0);
                int spX = spacing * (dx /= l / platfL) / l;
                int spY = spacing * (dy /= l / platfL) / l;
                int offsetX = platfL / 2 * Mathh.cos(ang) / 1000;
                int offsetY = platfL / 2 * Mathh.sin(ang) / 1000;
                for (int i = 0; i < n; ++i) {
                    Body fallinPlatf = new Body(originX + x1 + i * (dx + spX) + offsetX, originY + y1 + i * (dy + spY) + offsetY, rect, false);
                    fallinPlatf.setRotation2FX(292817 * ang);
                    fallinPlatf.setUserData(new MUserData(10, new short[]{20}));
                    this.w.addBody(fallinPlatf);
                }
                this.updateLowestY(Math.max(y1, y2) + platfH);
                break;
            }
            case 5: {
                this.arc(originX + data[1], originY + data[2], data[3], 360, 0);
                break;
            }
            case 6: {
                this.sin(originX + data[1], originY + data[2], data[3], data[4], data[5], data[6]);
                break;
            }
            case 7: {
                int blue;
                int x = originX + data[1];
                int y = originY + data[2];
                short l = data[3];
                short thickness = data[4];
                short ang = data[5];
                short effectID = 0;
                short effectDuration = data[8];
                short directionOffset = data[6];
                short speedMultiplier = data[7];
                int centerX = x + l * Mathh.cos(ang) / 2000;
                int centerY = y + l * Mathh.sin(ang) / 2000;
                int colorModifier = (speedMultiplier - 100) * 3;
                int red = Math.min(255, Math.max(0, colorModifier));
                int green = blue = Math.min(255, Math.max(0, -colorModifier));
                if (red < 50 && blue < 50) {
                    red = 50;
                    blue = 50;
                }
                int color = (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                Shape plate = Shape.createRectangle(l, thickness);
                Body pressurePlate = new Body(centerX, centerY, plate, false);
                MUserData mUserData = new MUserData(11, new short[]{effectID, effectDuration, directionOffset, speedMultiplier});
                mUserData.color = color;
                pressurePlate.setUserData(mUserData);
                pressurePlate.setRotation2FX(292817 * ang);
                this.w.addBody(pressurePlate);
                this.updateLowestY(y + Math.max(l, thickness));
                break;
            }
            case 8: {
                int x = originX + data[1];
                int y = originY + data[2];
                short l = data[3];
                short thickness = data[4];
                short ang = data[5];
                short elasticity = data[6];
                Shape plate = Shape.createRectangle(l, thickness);
                plate.setElasticity(elasticity);
                Body pressurePlate = new Body(x, y, plate, false);
                MUserData mUserData = new MUserData(13, null);
                pressurePlate.setUserData(mUserData);
                pressurePlate.setRotation2FX(292817 * ang);
                this.w.addBody(pressurePlate);
                this.updateLowestY(y + Math.max(l, thickness));
                break;
            }
            case 10: {
                int x = originX + data[1];
                int y = originY + data[2];
                short l = data[3];
                short thickness = data[4];
                short ang = data[5];
                Shape plate = Shape.createRectangle(l, thickness);
                Body pressurePlate = new Body(x, y, plate, false);
                MUserData mUserData = new MUserData(12, null);
                pressurePlate.setUserData(mUserData);
                pressurePlate.setRotation2FX(292817 * ang);
                this.w.addBody(pressurePlate);
                this.updateLowestY(y + Math.max(l, thickness));
                break;
            }
            case 11: {
                int x = originX + data[1];
                int y = originY + data[2];
                short l = data[3];
                short thickness = data[4];
                short ang = data[5];
                Shape plate = Shape.createRectangle(l, thickness);
                Body pressurePlate = new Body(x, y, plate, false);
                MUserData mUserData = new MUserData(14, null);
                pressurePlate.setUserData(mUserData);
                pressurePlate.setRotation2FX(292817 * ang);
                this.w.addBody(pressurePlate);
                this.updateLowestY(y + Math.max(l, thickness));
                break;
            }
        }
        if (this.w.lowestY != prevLowestY) {
            Logger.log("lowestY=", this.w.lowestY);
        }
    }

    public void sin(int x, int y, int l, int halfPeriods, int startAngle, int amp) {
        int pointCount = 0;
        if (amp == 0) {
            this.line(x, y, x + l, y);
        } else {
            int nextPointY;
            int nextPointX;
            int step = 30 / DETAIL_LEVEL;
            int endAngle = startAngle + halfPeriods * 180;
            int a = endAngle - startAngle;
            int prevPointX = x;
            int prevPointY = y + amp * Mathh.sin(startAngle) / 1000;
            int[] points = new int[2 * (endAngle - startAngle) / step + 10];
            points[0] = prevPointX;
            points[1] = prevPointY;
            ++pointCount;
            for (int i = startAngle; i <= endAngle; i += step) {
                nextPointX = x + (i - startAngle) * l / a;
                nextPointY = y + amp * Mathh.sin(i) / 1000;
                this.line(prevPointX, prevPointY, nextPointX, nextPointY, 1, false);
                prevPointX = nextPointX;
                prevPointY = nextPointY;
                points[pointCount * 2] = prevPointX;
                points[pointCount++ * 2 + 1] = prevPointY;
            }
            if (a % step != 0) {
                nextPointX = x + l;
                nextPointY = y + amp * Mathh.sin(endAngle) / 1000;
                this.line(prevPointX, prevPointY, nextPointX, nextPointY, 1, false);
                prevPointX = nextPointX;
                prevPointY = nextPointY;
                points[2 + pointCount * 2] = prevPointX;
                points[2 + pointCount++ * 2 + 1] = prevPointY;
            }
            int[] drawingData = new int[2 + pointCount * 2];
            drawingData[0] = 2;
            drawingData[1] = pointCount;
            System.arraycopy(points, 0, drawingData, 2, pointCount * 2);
            this.appendDrawingData(drawingData);
        }
        this.updateLowestY(y + amp);
    }

    public void arc(int x, int y, int r, int angle, int startAngle) {
        this.arc(x, y, r, angle, startAngle, 10, 10);
    }

    public void arc(int x, int y, int r, int angle, int startAngle, int kx, int ky) {
        int step = 10000 / (140 + r);
        if ((step /= DETAIL_LEVEL) <= 2) {
            this.arcSmooth(x, y, r, angle, startAngle, kx, ky);
        }
        step = Mathh.constrain(10 / DETAIL_LEVEL, step, 72 / DETAIL_LEVEL);
        while (startAngle < 0) {
            startAngle += 360;
        }
        int linesFacing = 0;
        if (Math.abs(angle) == 360) {
            linesFacing = 1;
        }
        int lastAng = 0;
        if (angle < 0) {
            step = -step;
        }
        for (int i = 0; i <= angle - step && angle > 0 || i >= angle - step && angle < 0; i += step) {
            this.line(x + Mathh.cos(i + startAngle) * kx * r / 10000, y + Mathh.sin(i + startAngle) * ky * r / 10000, x + Mathh.cos(i + step + startAngle) * kx * r / 10000, y + Mathh.sin(i + step + startAngle) * ky * r / 10000, linesFacing, false);
            lastAng = i + step;
        }
        if (Math.abs(angle) % Math.abs(step) != 0) {
            this.line(x + Mathh.cos(lastAng + startAngle) * kx * r / 10000, y + Mathh.sin(lastAng + startAngle) * ky * r / 10000, x + Mathh.cos(angle + startAngle) * kx * r / 10000, y + Mathh.sin(angle + startAngle) * ky * r / 10000, linesFacing, false);
        }
        this.updateLowestY(y + r);
        if (angle == 360 && startAngle == 0 && kx == 10 && ky == 10) {
            this.appendDrawingData(new int[]{3, x, y, r});
        } else {
            this.appendDrawingData(new int[]{4, x, y, r, startAngle, angle, kx, ky});
        }
    }

    public void arcSmooth(int x, int y, int r, int angle, int startAngle, int kx, int ky) {
        double startAngleD;
        double angleD = Math.PI * (double)angle / 180.0;
        double step = Math.PI * 10 / (double)(140 + r) / 180.0 / (double)DETAIL_LEVEL;
        step = Mathh.constrain(0.17453292519943295 / (double)DETAIL_LEVEL, step, 1.2566370614359172 / (double)DETAIL_LEVEL);
        for (startAngleD = Math.PI * (double)startAngle / 180.0; startAngleD < 0.0; startAngleD += Math.PI) {
        }
        int linesFacing = 0;
        if (angle == 360) {
            linesFacing = 1;
        }
        double lastAng = 0.0;
        for (double i = 0.0; i <= angleD - step; i += step) {
            this.line((int)((double)x + Math.cos(i + startAngleD) * (double)kx * (double)r / 10.0), (int)((double)y + Math.sin(i + startAngleD) * (double)ky * (double)r / 10.0), (int)((double)x + Math.cos(i + step + startAngleD) * (double)kx * (double)r / 10.0), (int)((double)y + Math.sin(i + step + startAngleD) * (double)ky * (double)r / 10.0), linesFacing, false);
            lastAng = i + step;
        }
        if (angleD % step != 0.0) {
            this.line((int)((double)x + Math.cos(lastAng + startAngleD) * (double)kx * (double)r / 10.0), (int)((double)y + Math.sin(lastAng + startAngleD) * (double)ky * (double)r / 10.0), (int)((double)x + Math.cos(angleD + startAngleD) * (double)kx * (double)r / 10.0), (int)((double)y + Math.sin(angleD + startAngleD) * (double)ky * (double)r / 10.0), linesFacing, false);
        }
        this.updateLowestY(y + r);
        if (angle == 360 && startAngle == 0 && kx == 10 && ky == 10) {
            this.appendDrawingData(new int[]{3, x, y, r});
        } else {
            this.appendDrawingData(new int[]{4, x, y, r, startAngle, angle, kx, ky});
        }
    }

    public void line(int x1, int y1, int x2, int y2) {
        this.line(x1, y1, x2, y2, 0, true);
    }

    public void line1(int x1, int y1, int x2, int y2) {
        this.line(x1, y1, x2, y2, 1, true);
    }

    public void line(int x1, int y1, int x2, int y2, int facing) {
        this.line(x1, y1, x2, y2, facing, true);
    }

    public void line(int x1, int y1, int x2, int y2, int facing, boolean saveDrawingData) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx == 0 && dy == 0) {
            return;
        }
        this.landscape.addSegment(FXVector.newVector(x1, y1), FXVector.newVector(x2, y2), (short)facing);
        ++this.lineCount;
        this.updateLowestY(Math.max(y1, y2));
        if (saveDrawingData) {
            this.appendDrawingData(new int[]{1, x1, y1, x2, y2});
        }
    }

    private void appendDrawingData(int[] newData) {
        this.drawingData = WorldGen.concatArrays(this.drawingData, newData);
    }

    private void updateLowestY(int y) {
        this.w.lowestY = Math.max(y, this.w.lowestY);
    }

    public int[] getDrawingData() {
        return this.drawingData;
    }

    private static int readDetailLevelSetting() {
        try {
            Logger.log("placer: reading settings");
            return MobappGameSettings.getDetailLevel();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return 1;
        }
    }
}

