/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.game;

import at.emini.physics2D.Body;
import at.emini.physics2D.Contact;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import java.util.Vector;
import mobileapplication3.game.DebugMenu;
import mobileapplication3.game.GraphicsWorld;
import mobileapplication3.game.LevelCompletedScreen;
import mobileapplication3.game.MUserData;
import mobileapplication3.game.MenuCanvas;
import mobileapplication3.game.StructurePlacer;
import mobileapplication3.game.WorldGen;
import mobileapplication3.platform.Battery;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.Records;
import mobileapplication3.platform.Sound;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.CanvasComponent;
import mobileapplication3.ui.IUIComponent;
import utils.MobappGameSettings;

public class GameplayCanvas
extends CanvasComponent
implements Runnable {
    public static final int TICK_DURATION = 50;
    private static final String[] MENU_HINT = new String[]{"MENU", "(LSoft, #, 9)"};
    private static final String[] PAUSE_HINT = new String[]{"PAUSE", "(RSoft, *, 3)"};
    public static final short EFFECT_SPEED = 0;
    private static final int BATT_UPD_PERIOD = 10000;
    private static final int GAME_MODE_ENDLESS = 1;
    private static final int GAME_MODE_LEVEL = 2;
    private static final int GAME_MODE_EMINI_WORLD = 3;
    private static final int GAME_OVER_DAMAGE = 8;
    private static final int GAME_OVER_STUCK_TIME = 1000;
    private static final int PAUSE_DELAY = 5;
    private int pauseDelay = 5;
    private boolean wasPaused = false;
    private int gameMode = 1;
    private static boolean isFirstStart = true;
    public boolean uninterestingDebug = false;
    public boolean shouldWait = false;
    public boolean isWaiting = false;
    private boolean isWorldLoaded = false;
    private int hintVisibleTimer = 120;
    private boolean showFPS = false;
    private boolean battIndicator = false;
    private int batLevel;
    private boolean paused = false;
    private boolean stopped = false;
    private boolean isStopping = false;
    private boolean gameOver = false;
    private boolean feltUnderTheWorld = false;
    private int scW;
    private int scH;
    private int maxScSide;
    private int carVelocitySqr;
    private int carAngle = 0;
    public int carSpawnX = 100;
    public int carSpawnY = -400;
    private int prevCarX;
    private int prevCarY;
    private boolean motorTurnedOn = false;
    private int flipIndicator = 255;
    private int posResetIndicator = 0;
    private int loadingProgress = 0;
    private int speedoState = 0;
    private int tickTime;
    private int fps;
    private int tps;
    private int physicsIterations;
    private int debugTickTime;
    private int debugPaintTime;
    private String statusMessage = null;
    private int debugTextOffset;
    private int pointerX = 0;
    private int pointerY = 0;
    private boolean pauseTouched = false;
    private boolean menuTouched = false;
    public int points = 0;
    private boolean countPoints = true;
    private int damage;
    private int timeStuck = 0;
    public int timeFlying = 10;
    private int ticksMotorTurnedOff = 50;
    private long lastBigTickTime;
    private int bgTick = 0;
    private int framesFromLastFPSMeasure = 0;
    private int ticksFromLastTPSMeasure = 0;
    public short[][] currentEffects = new short[1][];
    private short[][] level = null;
    private static final Font smallfont = Font.getFont(0, 0, 8);
    private static final Font largefont = Font.getFont(0, 0, 16);
    private Font currentFont = largefont;
    private int currentFontH = this.currentFont.getHeight();
    private GraphicsWorld world;
    private WorldGen worldgen;
    private FlipCounter flipCounter;
    private IUIComponent prevScreen = null;
    private Thread gameThread = null;
    private int baseTimestepFX = 0;
    private Vector deferredStructures = null;
    private Thread stopperThread;
    private boolean openMenu;

    public GameplayCanvas() {
        this.log("game: constructor");
        this.repaintOnlyOnFlushGraphics = true;
    }

    public GameplayCanvas(GraphicsWorld w) {
        this();
        this.gameMode = 3;
        this.world = w;
        this.world.setGame(this);
    }

    public GameplayCanvas(IUIComponent prevScreen) {
        this();
        this.prevScreen = prevScreen;
        this.world = new GraphicsWorld();
        this.world.setGame(this);
    }

    public GameplayCanvas addDeferredStructure(short[][] structureData) {
        if (this.worldgen == null) {
            if (this.deferredStructures == null) {
                this.deferredStructures = new Vector();
            }
            this.deferredStructures.addElement(structureData);
        } else {
            this.worldgen.addDeferredStructure(structureData);
        }
        return this;
    }

    public GameplayCanvas loadLevel(short[][] levelData) {
        this.level = levelData;
        this.gameMode = 2;
        StructurePlacer.place(this.world, false, levelData, 0, 0);
        if (levelData[0][0] == 9) {
            this.carSpawnX = levelData[0][1];
            this.carSpawnY = levelData[0][2];
        }
        this.world.removeBodies = false;
        return this;
    }

    public GameplayCanvas disablePointCounter() {
        this.countPoints = false;
        return this;
    }

    @Override
    public void init() {
        if (this.gameThread == null || !this.gameThread.isAlive()) {
            this.log("starting game thread");
            this.gameThread = new Thread((Runnable)this, "game canvas");
            this.gameThread.start();
        }
    }

    private void reset() {
        this.log("resetting the world");
        this.points = 0;
        this.damage = 0;
        this.countPoints = true;
        boolean bl = WorldGen.isEnabled = this.gameMode == 1;
        if (WorldGen.isEnabled) {
            if (this.worldgen == null) {
                this.log("starting wg");
                this.worldgen = new WorldGen(this, this.world);
            }
            if (this.deferredStructures != null) {
                for (int i = 0; i < this.deferredStructures.size(); ++i) {
                    this.worldgen.addDeferredStructure((short[][])this.deferredStructures.elementAt(i));
                }
            }
            this.flipCounter = new FlipCounter();
            this.log("wg started");
        }
        this.setLoadingProgress(50);
        if (WorldGen.isEnabled) {
            this.carSpawnX = -3000;
        }
        if (this.world.carbody == null) {
            this.world.addCar(this.carSpawnX, this.carSpawnY, 8784510);
        }
        this.setLoadingProgress(60);
    }

    private void initWorld() {
        this.log("initing world");
        this.world.setGravity(FXVector.newVector(0, 1000));
        this.world.getLandscape().getBody().shape().setElasticity(5);
        this.setLoadingProgress(40);
        this.reset();
        this.isWorldLoaded = true;
    }

    private void setDefaultWorld() {
        this.setLoadingProgress(25);
        this.log("creating world");
        this.world = new GraphicsWorld();
        this.world.setGame(this);
        this.setLoadingProgress(30);
        this.log("setting the world");
        this.initWorld();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.log("game thread started");
            this.shouldWait = false;
            this.isWaiting = false;
            this.timeFlying = 10;
            boolean wasPaused = true;
            this.tickTime = 50;
            int physicsIterationsSetting = 0;
            int maxFrameTime = 16;
            try {
                this.log("reading settings");
                physicsIterationsSetting = MobappGameSettings.getPhysicsPrecision();
                maxFrameTime = MobappGameSettings.getFrameTime();
                this.showFPS = MobappGameSettings.isFPSShown(this.showFPS);
                this.battIndicator = MobappGameSettings.isBattIndicatorEnabled(this.battIndicator) && Battery.checkAndInit();
            }
            catch (Throwable ex) {
                Platform.showError("Can't read settings", ex);
            }
            boolean dynamicPhysicsPrecision = physicsIterationsSetting == -1;
            boolean lockPhysicsPrecision = !dynamicPhysicsPrecision && physicsIterationsSetting != 0;
            this.physicsIterations = physicsIterationsSetting;
            if (this.physicsIterations <= 0) {
                this.physicsIterations = 2;
            }
            if (this.world == null) {
                this.setDefaultWorld();
            } else {
                this.initWorld();
            }
            this.world.refreshScreenParameters(this.scW, this.scH);
            Logger.setLogMessageDelay(50);
            this.currentEffects = new short[1][];
            if (DebugMenu.isDebugEnabled || DebugMenu.simulationMode || this.deferredStructures != null) {
                this.disablePointCounter();
            }
            this.setLoadingProgress(80);
            if (DebugMenu.music) {
                this.log("starting sound");
                Sound sound = new Sound();
                sound.start();
            }
            if (DebugMenu.simulationMode) {
                this.world.rightWheel.setDynamic(false);
                this.world.carbody.setDynamic(false);
                this.world.leftWheel.setDynamic(false);
            }
            this.setLoadingProgress(100);
            this.log("starting game cycle");
            Logger.setLogMessageDelay(0);
            if (this.baseTimestepFX == 0) {
                this.baseTimestepFX = this.world.getTimestepFX();
            }
            long lastFPSMeasureTime = System.currentTimeMillis();
            long lastBattUpdateTime = 0L;
            int physicsIterationsUnalteredCount = 0;
            Object wgLock = this.worldgen != null ? this.worldgen.lock : new Object();
            try {
                for (int i = 0; !this.hasParent() && i < 30; ++i) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            long start = System.currentTimeMillis();
            int bigTickN = 0;
            while (!this.stopped && this.hasParent()) {
                try {
                    long sleep;
                    if (!this.paused) {
                        boolean isNotFlying;
                        boolean bigTick;
                        int dtFromLastFPSMeasure = (int)(System.currentTimeMillis() - lastFPSMeasureTime);
                        if (dtFromLastFPSMeasure > 1000) {
                            lastFPSMeasureTime = System.currentTimeMillis();
                            this.fps = this.framesFromLastFPSMeasure * 1000 / dtFromLastFPSMeasure;
                            this.framesFromLastFPSMeasure = 0;
                            this.tps = this.ticksFromLastTPSMeasure * 1000 / dtFromLastFPSMeasure;
                            this.ticksFromLastTPSMeasure = 0;
                        }
                        if (!lockPhysicsPrecision && this.framesFromLastFPSMeasure == 0) {
                            int prevValue = this.physicsIterations;
                            if (this.fps != 0) {
                                this.physicsIterations = Mathh.constrain(1, 140 / this.fps + 1, 10);
                                if (this.physicsIterations == prevValue) {
                                    if (!dynamicPhysicsPrecision && ++physicsIterationsUnalteredCount >= 3) {
                                        Logger.log("locking precision multiplier: ", this.physicsIterations);
                                        lockPhysicsPrecision = true;
                                    }
                                } else {
                                    physicsIterationsUnalteredCount = 0;
                                }
                            } else {
                                physicsIterationsUnalteredCount = 0;
                            }
                        }
                        if (this.fps < 20) {
                            this.tryReduceLags();
                        }
                        if (!wasPaused) {
                            this.tickTime = (int)(System.currentTimeMillis() - start);
                            this.world.setTimestepFX(Math.max(1, this.baseTimestepFX * Math.min(this.tickTime, 100) / 50 / this.physicsIterations));
                        } else {
                            wasPaused = false;
                        }
                        start = System.currentTimeMillis();
                        Contact[][] carContacts = this.getCarContacts();
                        Object object = wgLock;
                        synchronized (object) {
                            this.setSimulationArea();
                            long tickStart = System.currentTimeMillis();
                            for (int i = 0; i < this.physicsIterations; ++i) {
                                this.world.tick();
                                carContacts = this.getCarContacts();
                                this.tickCustomBodyInteractions(carContacts);
                                ++this.ticksFromLastTPSMeasure;
                            }
                            this.debugTickTime = (int)(System.currentTimeMillis() - tickStart);
                            long paintStart = System.currentTimeMillis();
                            this.paint();
                            this.debugPaintTime = (int)(System.currentTimeMillis() - paintStart);
                        }
                        boolean leftWheelContacts = carContacts[0][0] != null;
                        boolean carBodyContacts = carContacts[1][0] != null;
                        boolean rightWheelContacts = carContacts[2][0] != null;
                        boolean bl = bigTick = start - this.lastBigTickTime > 50L;
                        if (bigTick) {
                            this.timeFlying = !leftWheelContacts && !rightWheelContacts ? ++this.timeFlying : 0;
                            if (this.isWorldLoaded) {
                                --this.hintVisibleTimer;
                            }
                            if (this.pauseDelay > 0) {
                                --this.pauseDelay;
                            }
                            if (WorldGen.isEnabled) {
                                if (this.flipIndicator < 255) {
                                    this.flipIndicator += 64;
                                    if (this.flipIndicator >= 255) {
                                        this.flipIndicator = 255;
                                    }
                                }
                                this.flipCounter.tick();
                                if (this.posResetIndicator > 0) {
                                    this.posResetIndicator -= 16;
                                    if (this.posResetIndicator <= 0) {
                                        this.posResetIndicator = 0;
                                    }
                                }
                            }
                            if (DebugMenu.simulationMode) {
                                this.world.carbody.translate(new FXVector(409600, 0), 0);
                                this.world.leftWheel.translate(new FXVector(409600, 0), 0);
                                this.world.rightWheel.translate(new FXVector(409600, 0), 0);
                            }
                            this.tickEffects();
                            if (bigTickN < 3) {
                                if (bigTickN == 1) {
                                    this.world.tickCustomBodies();
                                }
                                ++bigTickN;
                            } else {
                                bigTickN = 0;
                                this.tickDamage();
                                if (System.currentTimeMillis() - lastBattUpdateTime > 10000L && this.battIndicator) {
                                    this.batLevel = Battery.getBatteryLevel();
                                    lastBattUpdateTime = System.currentTimeMillis();
                                }
                            }
                            this.lastBigTickTime = start;
                        }
                        this.carAngle = 360 - FXUtil.angleInDegrees2FX(this.world.carbody.rotation2FX());
                        FXVector carVelocityFX = this.world.carbody.velocityFX();
                        int vX = carVelocityFX.xAsInt();
                        int vY = carVelocityFX.yAsInt();
                        this.limitTopHeight();
                        boolean bl2 = isNotFlying = this.timeFlying <= 2;
                        if (this.motorTurnedOn) {
                            this.ticksMotorTurnedOff = 0;
                            if (isNotFlying || this.uninterestingDebug) {
                                int speedMultiplier;
                                if (this.currentEffects[0] != null && this.currentEffects[0][0] > 0 && this.currentEffects[0][2] != 0) {
                                    vX = vX * 100 / this.currentEffects[0][2];
                                    vY = vY * 100 / this.currentEffects[0][2];
                                }
                                if (this.uninterestingDebug) {
                                    speedMultiplier = 250000;
                                } else {
                                    this.carVelocitySqr = (vX * vX + vY * vY) / 4;
                                    if (this.carVelocitySqr > 1000000) {
                                        speedMultiplier = 16000;
                                        this.speedoState = 2;
                                    } else if (this.carVelocitySqr > 100000) {
                                        speedMultiplier = 123000;
                                        this.speedoState = 1;
                                    } else {
                                        speedMultiplier = 160000;
                                        this.speedoState = 0;
                                    }
                                }
                                int directionOffset = 0;
                                if (this.currentEffects[0] != null && this.currentEffects[0][0] > 0) {
                                    directionOffset = this.currentEffects[0][1];
                                    speedMultiplier = speedMultiplier * this.currentEffects[0][2] / 100;
                                }
                                int motorForceX = Mathh.cos(this.carAngle - 15 + directionOffset) * speedMultiplier / 50;
                                int motorForceY = Mathh.sin(this.carAngle - 15 + directionOffset) * speedMultiplier / -50;
                                this.world.carbody.applyMomentum(new FXVector(this.convertByTimestep(motorForceX), this.convertByTimestep(motorForceY)));
                                if (!leftWheelContacts && carBodyContacts || rightWheelContacts) {
                                    int torque = rightWheelContacts ? -100000000 : -50000000;
                                    this.world.carbody.applyTorque(this.convertByTimestep(torque));
                                }
                            } else if (this.world.carbody.rotationVelocity2FX() < 100000000) {
                                int torque = this.convertByTimestep(-80000000);
                                if (carBodyContacts && this.carAngle > 170 && this.carAngle < 300) {
                                    torque <<= 1;
                                }
                                this.world.carbody.applyTorque(torque);
                            }
                        } else if (this.ticksMotorTurnedOff < 40 && !this.uninterestingDebug) {
                            try {
                                if (this.world.carbody.angularVelocity2FX() > 0) {
                                    this.world.carbody.applyTorque(2 * this.convertByTimestep(this.world.carbody.angularVelocity2FX()));
                                }
                                if (isNotFlying && !this.uninterestingDebug) {
                                    this.world.carbody.applyMomentum(new FXVector(this.convertByTimestep(-this.world.carbody.velocityFX().xFX / 2), this.convertByTimestep(-this.world.carbody.velocityFX().yFX / 2)));
                                }
                                if (bigTick) {
                                    ++this.ticksMotorTurnedOff;
                                    if (isNotFlying) {
                                        ++this.ticksMotorTurnedOff;
                                    }
                                }
                            }
                            catch (NullPointerException ex) {
                                Logger.log(ex);
                            }
                        }
                        if (this.motorTurnedOn && Math.abs(this.world.carX - this.prevCarX) <= 1 && Math.abs(this.world.carY - this.prevCarY) <= 1) {
                            for (int i = 0; i < carContacts.length; ++i) {
                                for (int j = 0; j < carContacts[i].length; ++j) {
                                    if (carContacts[i][j] == null) continue;
                                    Body body = carContacts[i][j].body1();
                                    UserData userData = body.getUserData();
                                    if (!(userData instanceof MUserData)) {
                                        body = carContacts[i][j].body2();
                                        userData = body.getUserData();
                                    }
                                    if (!(userData instanceof MUserData) || ((MUserData)userData).bodyType != 10 || body.isDynamic()) continue;
                                    this.timeStuck = 0;
                                }
                            }
                            this.timeStuck += this.tickTime;
                            if (this.timeStuck > 1000) {
                                this.gameOver();
                            }
                        } else {
                            this.timeStuck = 0;
                        }
                        this.prevCarX = this.world.carX;
                        this.prevCarY = this.world.carY;
                        if (this.worldgen != null && this.world.carX + this.world.viewField > this.worldgen.lastX) {
                            this.shouldWait = true;
                            Logger.log("wg can't keep up, locking game thread...");
                        }
                        if (this.shouldWait && !this.isStopping) {
                            this.isWaiting = true;
                            wasPaused = true;
                            Logger.log("waiting for wg to get ready...");
                            this.paint();
                            Object object2 = wgLock;
                            synchronized (object2) {
                                wgLock.wait();
                            }
                            Logger.log("resuming");
                        }
                        this.isWaiting = false;
                        Thread.yield();
                        sleep = (long)maxFrameTime - (System.currentTimeMillis() - start);
                        sleep = Math.max(sleep, 0L);
                    } else {
                        wasPaused = true;
                        sleep = 200L;
                        if (this.isVisible) {
                            this.paint();
                        }
                    }
                    try {
                        if (sleep > 0L) {
                            Thread.sleep(sleep);
                            continue;
                        }
                        if (System.currentTimeMillis() != start) continue;
                        Thread thread = Thread.currentThread();
                        while (System.currentTimeMillis() == start) {
                            Thread thread2 = thread;
                            synchronized (thread2) {
                                thread.wait(0L, 30);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Logger.log(e);
                    }
                }
                catch (Exception ex) {
                    Logger.log(ex);
                }
            }
        }
        catch (NullPointerException ex) {
            Platform.showError(ex);
        }
        Logger.log("game thread stopped");
    }

    private void tryReduceLags() {
        if (this.gameMode == 1) {
            int layer = 5;
            this.world.getLandscape().getBody().addCollisionLayer(layer);
            Body[] bodies = this.world.getBodies();
            for (int i = 0; i < this.world.getBodyCount(); ++i) {
                Body body = bodies[i];
                if (body == this.world.leftWheel || body == this.world.carbody || body == this.world.rightWheel || !body.isDynamic() || (body.getColissionBitFlag() & 1 << layer) != 0) continue;
                body.addCollisionLayer(layer);
                break;
            }
        }
    }

    private void limitTopHeight() {
        int d;
        FXVector carVelocityFX = this.world.carbody.velocityFX();
        if (this.worldgen != null && carVelocityFX.yAsInt() < 0 && (d = this.worldgen.lastY - this.world.carY - 7000) > 1) {
            this.world.carbody.applyMomentum(new FXVector(0, FXUtil.divideFX(carVelocityFX.yFX, FXUtil.toFX(-Math.max(100000 / d, 1)))));
        }
    }

    private void tickDamage() {
        int lowestY = this.getLowestSafeY();
        boolean bl = this.feltUnderTheWorld = this.world.carY > 2000 + lowestY;
        if (this.feltUnderTheWorld || this.carAngle > 140 && this.carAngle < 220 && this.world.carbody.getContacts()[0] != null || this.gameOver) {
            if (this.uninterestingDebug) {
                this.damage = 0;
            }
            if (this.damage < 8) {
                ++this.damage;
            } else {
                this.gameOver();
            }
        } else {
            this.damage = this.damage > 0 ? --this.damage : 0;
        }
    }

    private int convertByTimestep(int valueInDefaultTimestep) {
        return valueInDefaultTimestep / 50 * this.tickTime;
    }

    private int getLowestSafeY() {
        if (this.gameMode != 3) {
            return this.world.lowestY;
        }
        return 10000;
    }

    private void setSimulationArea() {
        this.world.refreshCarPos();
        this.world.setSimulationArea(this.world.carX - this.world.viewField, this.world.carX + this.world.viewField);
    }

    private Contact[][] getCarContacts() {
        return new Contact[][]{this.world.getContactsForBody(this.world.leftWheel), this.world.getContactsForBody(this.world.carbody), this.world.getContactsForBody(this.world.rightWheel)};
    }

    private void tickCustomBodyInteractions(Contact[][] carContacts) {
        for (int j = 0; j < carContacts.length; ++j) {
            block7: for (int i = 0; i < carContacts[j].length; ++i) {
                UserData userData;
                if (carContacts[j][i] == null) continue;
                Body body = carContacts[j][i].body1();
                if (body == this.world.leftWheel || body == this.world.carbody || body == this.world.rightWheel) {
                    body = carContacts[j][i].body2();
                }
                if (body == null || !((userData = body.getUserData()) instanceof MUserData)) continue;
                MUserData bodyUserData = (MUserData)body.getUserData();
                int bodyType = bodyUserData.bodyType;
                switch (bodyType) {
                    case 10: {
                        if (this.world.waitingForDynamic.contains(body)) continue block7;
                        this.world.waitingForDynamic.addElement(body);
                        this.world.waitingTime.addElement(Integer.valueOf(String.valueOf(600)));
                        if (!this.uninterestingDebug) continue block7;
                        this.world.removeBody(body);
                        continue block7;
                    }
                    case 11: {
                        this.giveEffect(bodyUserData.data);
                        this.world.setWheelColor(bodyUserData.color);
                        continue block7;
                    }
                    case 12: {
                        if (this.isPopupShown()) continue block7;
                        this.showPopup(new LevelCompletedScreen(this));
                        continue block7;
                    }
                    case 14: {
                        this.world.destroyCar();
                        this.stop(true, false);
                    }
                }
            }
        }
    }

    private void tickEffects() {
        for (int i = 0; i < this.currentEffects.length; ++i) {
            if (this.currentEffects[i] == null) continue;
            if (this.currentEffects[i][0] > 0) {
                short[] sArray = this.currentEffects[i];
                sArray[0] = (short)(sArray[0] - 1);
                continue;
            }
            if (this.currentEffects[i][0] != 0) continue;
            this.currentEffects[i] = null;
        }
    }

    public boolean drawAsBG(Graphics g) {
        if (this.feltUnderTheWorld || this.world.currColBodies == 0 && this.world.currColBg == 0) {
            return false;
        }
        this.world.setTimestepFX(this.baseTimestepFX / 7);
        this.world.refreshCarPos();
        this.setSimulationArea();
        this.world.tickCustomBodies();
        this.tickEffects();
        for (int i = 0; i < 7; ++i) {
            this.world.tick();
        }
        this.tickCustomBodyInteractions(this.getCarContacts());
        this.tickDamage();
        if (this.worldgen != null) {
            this.worldgen.tick();
        }
        if (this.worldgen != null) {
            this.world.drawWorld(g, this.worldgen.getStructures(), this.worldgen.getStructuresRingBufferOffset(), this.worldgen.getStructuresCount());
        } else {
            this.world.drawWorld(g, null, 0, 0);
        }
        this.limitTopHeight();
        if (this.world.carY > this.getLowestSafeY()) {
            if (this.bgTick % 10 == 0) {
                this.dimColors();
                this.bgTick = 0;
            } else {
                ++this.bgTick;
            }
        }
        return true;
    }

    private void drawBg(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.maxScSide, this.maxScSide);
    }

    @Override
    protected void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        this.drawBg(g);
        if (this.loadingProgress < 100) {
            this.drawLoading(g);
            Logger.paint(g);
        } else {
            if (this.worldgen != null) {
                this.world.drawWorld(g, this.worldgen.getStructures(), this.worldgen.getStructuresRingBufferOffset(), this.worldgen.getStructuresCount());
            } else {
                this.world.drawWorld(g, null, 0, 0);
            }
            this.drawHUD(g);
        }
    }

    private synchronized void paint() {
        if (!this.gameOver) {
            try {
                Graphics g = this.getUGraphics();
                this.paint(g);
                this.flushGraphics();
                ++this.framesFromLastFPSMeasure;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String nameBody(Body body) {
        if (body == null) {
            return " ";
        }
        if (body == this.world.getLandscape().getBody()) {
            return "GND";
        }
        if (body == this.world.leftWheel) {
            return "Lw";
        }
        if (body == this.world.carbody) {
            return "Cb";
        }
        if (body == this.world.rightWheel) {
            return "Rw";
        }
        return "?";
    }

    private String contactsToString(Contact[] contacts) {
        StringBuffer ret = new StringBuffer(" ");
        for (int i = 0; i < contacts.length; ++i) {
            if (contacts[i] != null) {
                ret.append(this.nameBody(contacts[i].body1()));
                ret.append("-");
                ret.append(this.nameBody(contacts[i].body2()));
            }
            ret.append(" ");
        }
        return ret.toString();
    }

    private void drawHUD(Graphics g) {
        if (isFirstStart && this.hintVisibleTimer > 0) {
            int i;
            int color = 255 * this.hintVisibleTimer / 120;
            g.setColor(0, 0, color / 4);
            int btnW = this.scW / 3;
            int btnH = this.scH / 6;
            int btnRoundingD = Math.min(btnW, btnH) / 4;
            if (color / 4 > 7) {
                g.fillRoundRect(0, 0, btnW, btnH, btnRoundingD, btnRoundingD);
                g.fillRoundRect(this.w - btnW, 0, btnW, btnH, btnRoundingD, btnRoundingD);
            }
            g.setColor(color / 2, color / 2, color);
            this.setFont(new Font(0), g);
            for (i = 0; i < MENU_HINT.length; ++i) {
                g.drawString(MENU_HINT[i], this.scW / 6, i * this.currentFontH + this.scH / 12 - this.currentFontH * MENU_HINT.length / 2, 17);
            }
            for (i = 0; i < PAUSE_HINT.length; ++i) {
                g.drawString(PAUSE_HINT[i], this.scW * 5 / 6, i * this.currentFontH + this.scH / 12 - this.currentFontH * PAUSE_HINT.length / 2, 17);
            }
        }
        this.setFont(smallfont, g);
        this.debugTextOffset = 0;
        if (this.battIndicator) {
            if (this.batLevel < 6) {
                g.setColor(65280);
            } else if (this.batLevel < 10) {
                g.setColor(0xFF8000);
            } else if (this.batLevel < 30) {
                g.setColor(0xFFFF00);
            } else {
                g.setColor(65280);
            }
            this.drawDebugText(g, "BAT: " + this.batLevel + "%");
        }
        g.setColor(0xFFFFFF);
        if (DebugMenu.showContacts) {
            Contact[][] contacts = this.getCarContacts();
            String[] names = new String[]{"LW", "CB", "RW"};
            for (int i = 0; i < contacts.length; ++i) {
                this.drawDebugText(g, names[i] + this.contactsToString(contacts[i]));
            }
        }
        if (DebugMenu.isDebugEnabled) {
            if (DebugMenu.speedo) {
                switch (this.speedoState) {
                    case 0: {
                        g.setColor(0, 255, 0);
                        break;
                    }
                    case 1: {
                        g.setColor(255, 255, 0);
                        break;
                    }
                    default: {
                        g.setColor(255, 0, 0);
                    }
                }
                g.fillRect(0, this.debugTextOffset, this.currentFontH * 5, this.currentFontH);
                g.setColor(255, 255, 255);
                this.drawDebugText(g, String.valueOf(this.carVelocitySqr));
            }
            if (DebugMenu.showAngle) {
                if (this.timeFlying > 0) {
                    g.setColor(0, 0, 255);
                } else {
                    g.setColor(255, 255, 255);
                }
                this.drawDebugText(g, String.valueOf(FXUtil.angleInDegrees2FX(this.world.carbody.rotation2FX())));
            }
            this.drawDebugText(g, "physics: " + this.debugTickTime + "ms, paint: " + this.debugPaintTime + "ms");
            if (this.flipCounter != null) {
                int x = this.world.xToPX(this.flipCounter.lastFlipX);
                g.drawLine(x, 0, x, this.h);
            }
        }
        if (DebugMenu.coordinates) {
            g.setColor(127, 127, 127);
            this.drawDebugText(g, this.world.carX + " " + this.world.carY);
        }
        if (this.showFPS) {
            g.setColor(0, 255, 0);
            if (this.tps < 100) {
                g.setColor(255, 200, 0);
                if (this.fps < 45) {
                    g.setColor(255, 0, 0);
                }
            }
            this.drawDebugText(g, "FPS:" + this.fps + " TPS:" + this.tps + " m=" + this.physicsIterations);
        }
        try {
            if (DebugMenu.isDebugEnabled) {
                switch (this.worldgen.currStep) {
                    case 0: {
                        g.setColor(0, 255, 0);
                        break;
                    }
                    case 1: {
                        g.setColor(127, 127, 255);
                        break;
                    }
                    case 2: {
                        g.setColor(255, 0, 0);
                        break;
                    }
                    case 3: {
                        g.setColor(127, 127, 0);
                        break;
                    }
                }
                this.drawDebugText(g, "wg: mspt" + this.worldgen.mspt + " step:" + this.worldgen.currStep);
                this.drawDebugText(g, "sgs" + this.worldgen.getSegmentCount() + " bds" + this.world.getBodyCount());
            }
        }
        catch (NullPointerException x) {
            // empty catch block
        }
        if (this.damage > 1 && !this.gameOver) {
            g.setFont(largefont);
            g.setColor(255, 0, 0);
            g.drawString("!", this.scW / 2, this.scH / 3 + this.currentFontH / 2, 17);
            g.setColor(0, 0, Math.min(127 * (8 - this.damage) / 8, 255));
            g.fillRect(0, 0, this.scW, this.scH * this.damage / 8 / 2 + 1);
            g.fillRect(0, this.scH - this.scH * this.damage / 8 / 2, this.scW, this.scH - 1);
        }
        if (WorldGen.isEnabled && this.world != null) {
            int d;
            if (this.countPoints || this.flipIndicator < 127) {
                g.setColor(this.flipIndicator, this.flipIndicator, 255);
            } else {
                g.setColor(127, 31, 31);
            }
            this.setFont(largefont, g);
            g.drawString(String.valueOf(this.points), this.scW / 2, this.scH - this.currentFontH * 3 / 2, 17);
            if (DebugMenu.isDebugEnabled && this.posResetIndicator > 0) {
                g.setColor(this.posResetIndicator, 0, 0);
                int d2 = this.h / 20;
                g.fillArc(this.x0, this.y0 + this.h - d2, d2, d2, 0, 360);
            }
            if (this.worldgen.firstDeferredStructureX != -1 && (d = (this.worldgen.firstDeferredStructureX - this.world.carX) / 100 * 100) >= 0) {
                int c = Mathh.constrain(0, d / 20, 255);
                g.setColor(c, c, c);
                this.drawDebugText(g, d + " ->");
            }
        }
        if (this.paused) {
            int d = this.scH / 40;
            if (!DebugMenu.isDebugEnabled) {
                g.setColor(0, 0, 255);
            } else {
                g.setColor(0, 255, 0);
            }
            if (this.shouldWait) {
                g.setColor(127, 0, 0);
            }
            for (int i = 0; i <= this.scH; ++i) {
                g.drawLine(this.scW / 2, 0, d * i, this.scH);
            }
            if (this.shouldWait) {
                g.setColor(255, 0, 0);
                g.drawString("Thread is locked", 0, 0, 0);
                g.drawString("(WorldGen is busy)", 0, g.getFont().getHeight(), 0);
            }
            this.setFont(largefont, g);
            g.setColor(255, 255, 255);
            g.drawString("PAUSED", this.scW / 2, this.scH / 3 + this.currentFontH / 2, 17);
        }
    }

    private void drawDebugText(Graphics g, String str) {
        g.drawString(str, 0, this.debugTextOffset, 0);
        this.debugTextOffset += this.currentFontH;
    }

    private void drawLoading(Graphics g) {
        g.setColor(255, 255, 255);
        int l = this.scW * 2 / 3;
        int h = this.scH / 24;
        g.drawRect(this.scW / 2 - l / 2, this.scH * 2 / 3, l, h);
        g.fillRect(this.scW / 2 - l / 2, this.scH * 2 / 3, l * this.loadingProgress / 100, h);
        if (this.statusMessage != null) {
            g.drawString(this.statusMessage, this.w / 2, this.h, 33);
        }
    }

    private void setLoadingProgress(int percents) {
        this.loadingProgress = percents;
        Logger.log(percents + "%");
        this.paint();
    }

    private void setFont(Font font, Graphics g) {
        g.setFont(font);
        this.currentFont = font;
        this.currentFontH = this.currentFont.getHeight();
    }

    private void log(String text) {
        this.statusMessage = text;
        Logger.log(text);
        if (Thread.currentThread() == this.gameThread && (Logger.isOnScreenLogEnabled() || this.loadingProgress < 100)) {
            this.paint();
        }
    }

    private void giveEffect(short[] data) {
        short id = data[0];
        int dataLength = data.length - 1;
        this.currentEffects[id] = new short[dataLength];
        System.arraycopy(data, 1, this.currentEffects[id], 0, data.length - 1);
    }

    private void gameOver() {
        if (this.gameOver) {
            return;
        }
        if (this.feltUnderTheWorld) {
            this.stop(true, false);
            return;
        }
        this.gameOver = true;
        this.motorTurnedOn = false;
        this.world.destroyCar();
        this.dimColors();
        this.stop(true, false);
    }

    private void dimColors() {
        this.world.currColLandscape = this.dimColor(this.world.currColLandscape, 80);
        this.world.currColBodies = this.dimColor(this.world.currColBodies, 80);
        this.world.currColBg = this.world.currColBodies > 0 ? this.dimColor(Math.max(21, this.world.currColBg), 105) : this.dimColor(this.world.currColBg, 70);
    }

    private int dimColor(int color, int percent) {
        int r = this.getColorRedComponent(color) * percent / 100;
        int g = this.getColorGreenComponent(color) * percent / 100;
        int b = this.getColorBlueComponent(color) * percent / 100;
        r = Mathh.constrain(0, r, 255);
        g = Mathh.constrain(0, g, 255);
        b = Mathh.constrain(0, b, 255);
        return (r << 16) + (g << 8) + b;
    }

    private int getColorRedComponent(int color) {
        return color >> 16 & 0xFF;
    }

    private int getColorGreenComponent(int color) {
        return color >> 8 & 0xFF;
    }

    private int getColorBlueComponent(int color) {
        return color & 0xFF;
    }

    public void stop(boolean openMenu, boolean blockUntilCompleted) {
        this.stop(openMenu, blockUntilCompleted, 0);
    }

    public void stop(boolean openMenu, final boolean blockUntilCompleted, final int delay) {
        this.openMenu = openMenu;
        this.log("stopping game thread");
        if (this.isStopping) {
            return;
        }
        if (this.stopperThread != null) {
            return;
        }
        final GameplayCanvas inst = this;
        Runnable stopperRunnable = new Runnable(){

            @Override
            public void run() {
                if (!blockUntilCompleted) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ex) {
                        Logger.log(ex);
                    }
                }
                GameplayCanvas.this.isStopping = true;
                GameplayCanvas.this.stopped = true;
                isFirstStart = false;
                if (GameplayCanvas.this.gameMode == 1 && GameplayCanvas.this.countPoints) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Records.saveRecord(GameplayCanvas.this.points, 9);
                            }
                            catch (Exception ex) {
                                Platform.showError("Can't save record:", ex);
                            }
                        }
                    }, "record saver").start();
                }
                if (GameplayCanvas.this.worldgen != null) {
                    GameplayCanvas.this.worldgen.stop();
                }
                boolean succeed = GameplayCanvas.this.gameThread == null;
                try {
                    while (!succeed) {
                        GameplayCanvas.this.gameThread.join();
                        succeed = true;
                    }
                    GameplayCanvas.this.log("game: stopped");
                }
                catch (InterruptedException ex) {
                    Logger.log(ex);
                }
                if (GameplayCanvas.this.openMenu) {
                    if (GameplayCanvas.this.prevScreen == null) {
                        RootContainer.setRootUIComponent(new MenuCanvas(inst));
                    } else {
                        RootContainer.setRootUIComponent(GameplayCanvas.this.prevScreen);
                    }
                }
            }
        };
        if (blockUntilCompleted) {
            stopperRunnable.run();
        } else {
            this.stopperThread = new Thread(stopperRunnable);
            this.stopperThread.start();
        }
    }

    public void startAgain() {
        if (this.stopperThread != null && this.stopperThread.isAlive()) {
            this.stopperThread.interrupt();
        }
        this.stopperThread = null;
        this.isStopping = false;
        this.stopped = false;
        this.gameOver = false;
        this.init();
        if (this.worldgen != null) {
            this.worldgen.start();
        }
    }

    private void resume() {
        this.paused = false;
        if (this.worldgen != null) {
            this.worldgen.resume();
        }
    }

    public void onPosReset(int dx) {
        this.posResetIndicator = 255;
        if (this.flipCounter != null) {
            this.flipCounter.onPosReset(dx);
        }
    }

    @Override
    public void onHide() {
        this.log("onHide");
        this.paused = true;
        if (this.worldgen != null) {
            this.worldgen.pause();
        }
        if (this.pauseDelay > 0 && !this.wasPaused) {
            this.resume();
        }
    }

    @Override
    public void onShow() {
        this.log("onShow");
        this.pauseDelay = 5;
        this.wasPaused = this.paused;
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        this.scW = w;
        this.scH = h;
        this.maxScSide = Math.max(this.scW, this.scH);
        if (this.world != null) {
            this.world.refreshScreenParameters(w, h);
        }
    }

    private void pauseButtonPressed() {
        if (!this.paused) {
            this.pauseDelay = 0;
            this.onHide();
        } else {
            this.resume();
        }
    }

    private void restart() {
        this.stop(false, true);
        if (this.worldgen != null) {
            this.worldgen.reset();
        } else {
            this.world.cleanWorld();
        }
        this.reset();
        if (this.level != null) {
            this.loadLevel(this.level);
        }
        this.startAgain();
    }

    @Override
    public boolean handleMouseEvent(int event, int x, int y) {
        if (event == -2) {
            this.restart();
            this.motorTurnedOn = false;
            return true;
        }
        if (event == -3) {
            this.stop(true, false);
        }
        return false;
    }

    @Override
    public boolean handleKeyReleased(int keyCode, int count) {
        if (this.gameOver) {
            return false;
        }
        this.motorTurnedOn = false;
        if (this.timeFlying > 0) {
            this.timeFlying = Math.max(5, this.timeFlying);
        }
        return true;
    }

    @Override
    public boolean handleKeyPressed(int keyCode, int count) {
        if (this.gameOver) {
            return false;
        }
        switch (keyCode) {
            case -6: 
            case 35: 
            case 48: 
            case 57: {
                this.stop(true, false);
                break;
            }
            case -7: 
            case 42: 
            case 51: {
                this.pauseButtonPressed();
                break;
            }
            case 54: {
                this.world.destroyCar();
                this.disablePointCounter();
                break;
            }
            case 55: {
                this.restart();
                break;
            }
            default: {
                int gameAction = RootContainer.getAction(keyCode);
                if (gameAction == 12) {
                    this.stop(true, false);
                    break;
                }
                if (gameAction == 10) {
                    this.pauseButtonPressed();
                    break;
                }
                this.motorTurnedOn = true;
            }
        }
        return true;
    }

    @Override
    public boolean handleKeyRepeated(int keyCode, int pressedCount) {
        return !this.gameOver;
    }

    @Override
    public boolean handlePointerPressed(int x, int y) {
        if (x > this.scW * 2 / 3 && y < this.scH / 6) {
            this.pauseTouched = true;
        } else if (x < this.scW / 3 && y < this.scH / 6) {
            this.menuTouched = true;
        } else if (!this.gameOver) {
            this.motorTurnedOn = true;
        }
        this.pointerX = x;
        this.pointerY = y;
        return !this.gameOver;
    }

    @Override
    public boolean handlePointerDragged(int x, int y) {
        if (this.gameOver) {
            return false;
        }
        if ((this.pauseTouched || this.menuTouched) && (x - this.pointerX > 3 || y - this.pointerY > 3)) {
            this.pauseTouched = false;
            this.menuTouched = false;
        }
        this.pointerX = x;
        this.pointerY = y;
        return true;
    }

    @Override
    public boolean handlePointerReleased(int x, int y) {
        if (this.pauseTouched) {
            this.pauseButtonPressed();
        }
        if (this.menuTouched) {
            this.stop(true, false);
        }
        this.pauseTouched = false;
        this.menuTouched = false;
        this.motorTurnedOn = false;
        return !this.gameOver;
    }

    @Override
    public boolean canBeFocused() {
        return true;
    }

    private class FlipCounter {
        int step = 0;
        boolean flipDirection = false;
        boolean prevFlipDirection = false;
        int lastFlipX = -3000;

        private FlipCounter() {
        }

        void tick() {
            boolean isInNormalPos;
            if (DebugMenu.dontCountFlips) {
                return;
            }
            boolean bl = this.flipDirection = ((GameplayCanvas)GameplayCanvas.this).world.carbody.rotationVelocity2FX() >= 0;
            if (this.flipDirection != this.prevFlipDirection || GameplayCanvas.this.timeFlying < 1 && !GameplayCanvas.this.uninterestingDebug) {
                this.step = 0;
            }
            this.prevFlipDirection = this.flipDirection;
            int ang = GameplayCanvas.this.carAngle;
            boolean bl2 = isInNormalPos = ang < 45 || ang > 315;
            if (isInNormalPos && this.step % 2 == 0) {
                if (((GameplayCanvas)GameplayCanvas.this).world.carX > this.lastFlipX || this.step < 1) {
                    ++this.step;
                    if (this.step > 1) {
                        if (this.flipDirection) {
                            if ((this.step - 1) % 4 == 0) {
                                this.afterFlip();
                            }
                        } else {
                            this.afterFlip();
                        }
                    }
                }
            } else if (!isInNormalPos && this.step % 2 != 0) {
                ++this.step;
            }
        }

        public void afterFlip() {
            GameplayCanvas.this.flipIndicator = 0;
            ++GameplayCanvas.this.points;
            this.lastFlipX = ((GameplayCanvas)GameplayCanvas.this).world.carX;
        }

        public void onPosReset(int dx) {
            this.lastFlipX += dx;
        }
    }
}

