/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.game;

import mobileapplication3.game.DebugMenu;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.CanvasComponent;

public abstract class GenericMenu
extends CanvasComponent {
    private static final int PAUSE_DELAY = 5;
    public int x0;
    public int y0;
    public int w;
    public int h;
    private int fontH;
    private int tick = 0;
    private int k = 10;
    private int keyPressDelay = 0;
    private int keyPressDelayAfterShowing = 5;
    private int firstReachable = 0;
    private int lastReachable = -2;
    private int firstDrawable = 0;
    private int specialOption = -1;
    private int pauseDelay = 5;
    private int lastKeyCode = 0;
    public int selected;
    protected int normalColor = 0xFFFFFF;
    protected int selectedColor = 0xFF4040;
    protected int pressedColor = 14694456;
    protected int specialOptionActivatedColor = 0xFFFF00;
    protected int colUnreachable = 0x888888;
    protected int colReachableEnabled = 0x88FF00;
    protected int bgColor = 0;
    private String[] options;
    private boolean isPressedByPointerNow;
    private boolean firstload = true;
    private boolean isSpecialOptionActivated = false;
    private boolean isSelectPressed = false;
    private boolean fontFound = false;
    private boolean isKnownButton = true;
    private boolean isInited = false;
    public boolean isPaused = false;
    public boolean isStopped = false;
    private Font font;
    private int[] stateMap = null;
    public static final int STATE_INACTIVE = -1;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_NORMAL_ENABLED = 1;
    public static final int SIEMENS_KEY_FIRE = -26;
    public static final int SIEMENS_KEY_UP = -59;
    public static final int SIEMENS_KEY_DOWN = -60;
    public static final int SIEMENS_KEY_LEFT = -61;
    public static final int SIEMENS_KEY_RIGHT = -62;

    @Override
    protected void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (this.bgColor >= 0) {
            g.setColor(this.bgColor);
            g.fillRect(x0, y0, Math.max(w, h), Math.max(w, h));
        }
        if (this.isInited && this.options != null) {
            for (int i = this.firstDrawable; i < this.options.length; ++i) {
                if (this.font != null) {
                    g.setFont(this.font);
                }
                g.setColor(this.normalColor);
                int offset = 0;
                if (i == this.selected) {
                    offset = Mathh.sin(this.tick * 360 / 10);
                    g.setColor(this.selectedColor);
                    if (this.isPressedByPointerNow) {
                        g.setColor(this.pressedColor);
                        g.setFont(Font.getFont(0, 1, this.font.getSize()));
                    }
                }
                if (this.stateMap != null) {
                    if (this.stateMap[i] == 1) {
                        g.setColor(this.colReachableEnabled);
                    } else if (this.stateMap[i] == -1) {
                        g.setColor(this.colUnreachable);
                    }
                }
                if (i == this.specialOption && this.isSpecialOptionActivated) {
                    g.setColor(this.specialOptionActivatedColor);
                }
                int x = x0 + w / 2;
                int y = y0 + this.k * (i + 1 - this.firstDrawable) - this.fontH / 2 - h / (this.options.length + 1 - this.firstDrawable) / 2 + offset * Font.getDefaultFont().getHeight() / 8000;
                if (this.options[i] != null) {
                    g.drawString(this.options[i], x, y, 17);
                }
                if (!DebugMenu.isDebugEnabled || !DebugMenu.showFontSize) continue;
                g.drawString(String.valueOf(this.font.getSize()), x0, y0, 0);
            }
            if (!this.isKnownButton) {
                g.setColor(0x808080);
                g.drawString(this.lastKeyCode + " - unknown keyCode", w, h, 40);
            }
        } else {
            g.setColor(0x808080);
            g.drawString("Loading the menu...", w / 2, h, 33);
        }
    }

    public int findOptimalFont(int canvW, int canvH, String[] options) {
        this.font = new Font(16);
        if (this.font.getHeight() * (options.length - this.firstDrawable) >= canvH - canvH / 16) {
            this.font = new Font(0);
        }
        if (this.font.getHeight() * (options.length - this.firstDrawable) >= canvH - canvH / 16) {
            this.font = new Font(8);
        }
        if (this.font.getSize() != 8) {
            for (int i = this.firstDrawable; i < options.length - 1; ++i) {
                if (this.font.stringWidth(options[i]) < canvW - canvW / 16) continue;
                this.font = new Font(0);
                if (this.font.stringWidth(options[i]) < canvW - canvW / 16) continue;
                this.font = new Font(8);
                break;
            }
        }
        return this.font.getHeight();
    }

    private boolean isOptionAvailable(int n) {
        if (this.stateMap != null) {
            if (n >= this.stateMap.length) {
                return false;
            }
            if (this.stateMap[n] == -1) {
                return false;
            }
        }
        return n >= this.firstReachable && n <= this.getLastReachable();
    }

    public boolean isMenuInited() {
        return this.isInited;
    }

    @Override
    public boolean handlePointerPressed(int x, int y) {
        this.handlePointer(x, y);
        return true;
    }

    @Override
    public boolean handlePointerDragged(int x, int y) {
        this.handlePointer(x, y);
        return true;
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        if (this.handlePointer(x, y)) {
            this.selectPressed();
        }
        return true;
    }

    public boolean handlePointer(int x, int y) {
        x -= this.x0;
        this.isPaused = false;
        int selected = this.firstDrawable + (y -= this.y0) / this.k;
        if (selected < this.firstReachable && this.firstReachable < this.firstDrawable) {
            selected = this.firstReachable;
        }
        if (!this.isOptionAvailable(selected)) {
            this.isPressedByPointerNow = false;
            return false;
        }
        this.selected = selected;
        this.isPressedByPointerNow = true;
        return this.stateMap == null || this.stateMap[selected] != -1;
    }

    private boolean handleKeyStates(int keyStates) {
        boolean needRepeat;
        if (keyStates == 0) {
            return false;
        }
        int lastReachable = this.getLastReachable();
        this.isPaused = false;
        switch (keyStates) {
            case 2: {
                this.selected = lastReachable;
            }
            case 5: 
            case 8: {
                this.isSelectPressed = true;
                this.isKnownButton = true;
                return this.stateMap == null || this.stateMap[this.selected] != -1;
            }
        }
        do {
            switch (keyStates) {
                case 1: {
                    this.isKnownButton = true;
                    this.isPaused = false;
                    if (this.selected > this.firstReachable) {
                        --this.selected;
                        break;
                    }
                    this.selected = lastReachable;
                    break;
                }
                case 6: {
                    this.isKnownButton = true;
                    this.isPaused = false;
                    if (this.selected < lastReachable) {
                        ++this.selected;
                        break;
                    }
                    this.selected = this.firstReachable;
                }
            }
        } while (needRepeat = !this.isSelectPressed && this.stateMap != null && this.stateMap[this.selected] == -1);
        return this.isSelectPressed;
    }

    @Override
    public boolean handleKeyRepeated(int keyCode, int pressedCount) {
        this.handleKeyPressed(keyCode);
        return true;
    }

    @Override
    public boolean handleKeyPressed(int keyCode, int count) {
        if (this.handleKeyPressed(keyCode)) {
            this.selectPressed();
            this.isSelectPressed = false;
        }
        return true;
    }

    public boolean handleKeyPressed(int keyCode) {
        this.lastKeyCode = keyCode;
        this.isKnownButton = false;
        this.isPaused = false;
        boolean pressed = false;
        int selected = -1;
        switch (keyCode) {
            case 49: {
                selected = 0;
                pressed = true;
                break;
            }
            case 50: {
                selected = 1;
                pressed = true;
                break;
            }
            case 51: {
                selected = 2;
                pressed = true;
                break;
            }
            case 52: {
                selected = 3;
                pressed = true;
                break;
            }
            case 53: {
                selected = 4;
                pressed = true;
                break;
            }
            case 54: {
                selected = 5;
                pressed = true;
                break;
            }
            case 55: {
                selected = 6;
                pressed = true;
                break;
            }
            case 56: {
                selected = 7;
                pressed = true;
                break;
            }
            case 57: {
                selected = 8;
                pressed = true;
                break;
            }
            case 42: {
                selected = 9;
                pressed = true;
                break;
            }
            case -59: {
                this.isKnownButton = true;
                this.handleKeyStates(1);
                break;
            }
            case -60: {
                this.isKnownButton = true;
                this.handleKeyStates(6);
                break;
            }
            case -62: 
            case -7: 
            case 48: {
                return this.handleKeyStates(2);
            }
            case -61: 
            case -26: 
            case -6: 
            case 35: {
                return this.handleKeyStates(8);
            }
            default: {
                return this.handleKeyStates(RootContainer.getAction(keyCode));
            }
        }
        selected += this.firstReachable;
        if (pressed) {
            this.isKnownButton = true;
            if (this.isOptionAvailable(selected)) {
                this.selected = selected;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleKeyReleased(int keyCode, int count) {
        this.keyPressDelay = 0;
        this.isSelectPressed = false;
        return true;
    }

    protected void loadCanvasParams(int x0, int y0, int w, int h) {
        this.x0 = x0;
        this.y0 = y0;
        if (w <= 0 || h <= 0) {
            return;
        }
        this.w = w;
        this.h = h;
        if (this.options != null) {
            this.k = (h + h / (this.options.length + 1 - this.firstDrawable)) / (this.options.length + 1 - this.firstDrawable);
            this.fontH = this.findOptimalFont(w, h, this.options);
            this.fontFound = true;
        }
    }

    public void reloadCanvasParameters(int scW, int scH) {
        this.reloadCanvasParameters(this.x0, this.y0, scW, scH);
    }

    public void reloadCanvasParameters(int x0, int y0, int w, int h) {
        this.loadCanvasParams(x0, y0, w, h);
    }

    @Override
    public void onShow() {
        Logger.log("menu:showNotify");
        this.isPaused = false;
        this.pauseDelay = 5;
    }

    @Override
    public void onHide() {
        Logger.log("menu:hideNotify");
        if (this.pauseDelay <= 0) {
            this.isPaused = true;
        }
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        this.w = w;
        this.h = h;
        this.reloadCanvasParameters(w, h);
    }

    @Override
    public boolean canBeFocused() {
        return true;
    }

    public void loadParams(String[] options) {
        this.loadParams(options, options.length - 1);
    }

    public void loadParams(String[] options, int defaultSelected) {
        this.options = options;
        this.stateMap = new int[options.length];
        if (this.firstload) {
            this.selected = defaultSelected;
            this.firstload = false;
        }
        this.isInited = true;
    }

    public void setFirstReachable(int firstReachable) {
        this.firstReachable = firstReachable;
    }

    private int getLastReachable() {
        return this.lastReachable != -2 ? this.lastReachable : this.options.length - 1;
    }

    public void setLastReachable(int lastReachable) {
        this.lastReachable = lastReachable;
    }

    public void loadStatemap(int[] stateMap) {
        if (stateMap != null) {
            if (stateMap.length == this.options.length) {
                this.stateMap = stateMap;
                Logger.log("stateMap loaded");
            } else {
                Platform.showError("incorrect stateMap length: " + stateMap.length + " " + this.getClass().getName());
            }
        }
    }

    public void setDefaultColor(int color_hex) {
        this.normalColor = color_hex;
    }

    public void setSelectedColor(int color_hex) {
        this.selectedColor = color_hex;
    }

    public void setPressedColor(int color_hex) {
        this.pressedColor = color_hex;
    }

    public void setColorEnabledOption(int color_hex) {
        this.colReachableEnabled = color_hex;
    }

    public void setColorUnreachableOption(int color_hex) {
        this.colUnreachable = color_hex;
    }

    public void setSpecialOptnActColor(int colorActivated) {
        this.specialOptionActivatedColor = colorActivated;
    }

    public void setSpecialOption(int n) {
        this.specialOption = n;
    }

    public void setIsSpecialOptnActivated(boolean isActivated) {
        this.isSpecialOptionActivated = isActivated;
    }

    public void setFirstDrawable(int n) {
        this.firstDrawable = n;
        this.k = (this.h + this.h / (this.options.length + 1 - this.firstDrawable)) / (this.options.length + 1 - this.firstDrawable);
    }

    public void setEnabledFor(boolean enabled, int i) {
        if (enabled) {
            this.setStateFor(1, i);
        } else {
            this.setStateFor(0, i);
        }
    }

    public void setStateFor(int state, int i) {
        if (this.stateMap == null) {
            return;
        }
        this.stateMap[i] = state;
    }

    public int getFontSize() {
        if (this.fontFound) {
            return this.font.getSize();
        }
        return -1;
    }

    public void tick() {
        this.tick = this.tick > 9 ? 0 : ++this.tick;
        if (this.pauseDelay > 0) {
            --this.pauseDelay;
        }
        if (this.keyPressDelayAfterShowing > 0) {
            --this.keyPressDelayAfterShowing;
        }
        if (this.keyPressDelay > 0) {
            --this.keyPressDelay;
        }
    }

    abstract void selectPressed();
}

