/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.game;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Joint;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.Shape;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import java.util.Random;
import java.util.Vector;
import mobileapplication3.game.DebugMenu;
import mobileapplication3.game.GameplayCanvas;
import mobileapplication3.game.MUserData;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Graphics;
import utils.MobappGameSettings;

public class GraphicsWorld
extends World {
    public static int DEFAULT_LANDSCAPE_COLOR = 0x4444FF;
    private static final int BIG_SCREEN_SIDE = 480;
    private static final int CAR_COLLISION_LAYER = 1;
    public int colBg = 0;
    public int colLandscape = DEFAULT_LANDSCAPE_COLOR;
    int colBodies = 0xFFFFFF;
    int currColBg;
    int currColWheel;
    int currColLandscape = this.colLandscape;
    int currColBodies;
    public static int scWidth = 200;
    private int halfScWidth = scWidth / 2;
    public static int scHeight = 200;
    private int scMinSide = Math.min(scWidth, scHeight);
    public boolean removeBodies = true;
    private boolean betterGraphics;
    private boolean bg;
    private boolean legacyDrawingMethod;
    public static boolean bgOverride = false;
    private int bgLineStep = this.scMinSide / 3;
    private int bgLineThickness;
    public int bgXOffset = 0;
    int zoomOutBase = 0;
    int zoomOut = 100;
    int offsetX = 0;
    int offsetY = 0;
    public int viewField;
    public int carX = 0;
    public int carY = 0;
    private GameplayCanvas game = null;
    public Body carbody;
    public Body leftWheel;
    public Body rightWheel;
    private Joint leftjoint;
    private Joint rightjoint;
    private final Random random = new Random();
    public Vector waitingForDynamic = new Vector();
    public Vector waitingTime = new Vector();
    long prevBodyTickTime = System.currentTimeMillis();
    public int barrierX = Integer.MIN_VALUE;
    public int lowestY;

    public GraphicsWorld() {
        this.init();
    }

    public GraphicsWorld(World w) {
        super(w);
        this.init();
    }

    private void init() {
        if (DebugMenu.whatTheGame) {
            this.currColWheel = 0x888888;
            this.colBg = 4437;
            this.colBodies = 0x555555;
        }
        this.currColWheel = this.colBg;
        this.currColBg = this.colBg;
        this.currColBodies = this.colBodies;
    }

    public void setGame(GameplayCanvas game) {
        this.game = game;
    }

    @Override
    public void removeBody(Body body) {
        if (body == this.leftWheel) {
            Logger.log("Deleting leftWheel...");
        } else if (body == this.carbody) {
            Logger.log("Deleting carbody...");
        } else if (body == this.rightWheel) {
            Logger.log("Deleting rightWheel...");
        }
        super.removeBody(body);
    }

    public void cleanWorld() {
        Constraint[] constraints = this.getConstraints();
        while (this.getConstraintCount() > 0) {
            this.removeConstraint(constraints[0]);
        }
        this.rmAllBodies();
        this.rmLandscapeSegments();
    }

    private void rmLandscapeSegments() {
        Landscape landscape = this.getLandscape();
        while (landscape.segmentCount() > 0) {
            landscape.removeSegment(0);
        }
    }

    private void rmAllBodies() {
        Body[] bodies = this.getBodies();
        while (this.getBodyCount() > 0) {
            this.removeBody(bodies[0]);
        }
        this.leftWheel = null;
        this.carbody = null;
        this.rightWheel = null;
    }

    public void addCar(int spawnX, int spawnY, int ang2FX) {
        this.carX = spawnX;
        this.carY = spawnY;
        int carBodyLength = 240;
        int carBodyHeight = 40;
        int wheelRadius = 40;
        Shape carbodyShape = Shape.createRectangle(carBodyLength, carBodyHeight);
        carbodyShape.setMass(1);
        carbodyShape.setFriction(0);
        carbodyShape.setElasticity(100);
        carbodyShape.correctCentroid();
        this.carbody = new Body(spawnX, spawnY, carbodyShape, true);
        this.carbody.setRotation2FX(ang2FX);
        int ang = (int)((long)ang2FX * 360L / 105414356L) + 1;
        Shape wheelShape = Shape.createCircle(wheelRadius);
        wheelShape.setElasticity(100);
        wheelShape.setFriction(0);
        wheelShape.setMass(2);
        wheelShape.correctCentroid();
        int lwX = spawnX - (carBodyLength / 2 - wheelRadius - 2) * Mathh.cos(ang) / 1000;
        int lwY = spawnY + wheelRadius / 2 - (carBodyLength / 2 - wheelRadius) * Mathh.sin(ang) / 1000;
        int rwX = spawnX + (carBodyLength / 2 - wheelRadius + 2) * Mathh.cos(ang) / 1000;
        int rwY = spawnY + wheelRadius / 2 + (carBodyLength / 2 - wheelRadius) * Mathh.sin(ang) / 1000;
        this.leftWheel = new Body(lwX, lwY, wheelShape, true);
        this.rightWheel = new Body(rwX, rwY, wheelShape, true);
        super.removeBody(this.carbody);
        super.removeBody(this.leftWheel);
        super.removeBody(this.rightWheel);
        this.addBody(this.carbody);
        this.carbody.addCollisionLayer(1);
        this.addBody(this.leftWheel);
        this.leftWheel.addCollisionLayer(1);
        this.addBody(this.rightWheel);
        this.rightWheel.addCollisionLayer(1);
        this.leftjoint = new Joint(this.carbody, this.leftWheel, FXVector.newVector(-carBodyLength / 2 + wheelRadius - 2, wheelRadius * 2 / 3), FXVector.newVector(0, 0), false);
        this.rightjoint = new Joint(this.carbody, this.rightWheel, FXVector.newVector(carBodyLength / 2 - wheelRadius + 2, wheelRadius * 2 / 3), FXVector.newVector(0, 0), false);
        this.addConstraint(this.leftjoint);
        this.addConstraint(this.rightjoint);
        this.bgXOffset = spawnX;
    }

    public void destroyCar() {
        this.removeConstraint(this.leftjoint);
        this.removeConstraint(this.rightjoint);
        this.leftWheel.removeCollisionLayer(1);
        this.carbody.removeCollisionLayer(1);
        this.rightWheel.removeCollisionLayer(1);
        int forceFX = -2048000;
        this.leftWheel.applyMomentum(new FXVector(-forceFX, forceFX));
        this.rightWheel.applyMomentum(new FXVector(forceFX, forceFX));
        this.leftWheel.shape().setElasticity(100);
        this.carbody.shape().setElasticity(100);
        this.getLandscape().getShape().setElasticity(200);
    }

    public void tickCustomBodies() {
        int i;
        int diffTime = (int)(System.currentTimeMillis() - this.prevBodyTickTime);
        for (i = 0; i < this.waitingForDynamic.size(); ++i) {
            try {
                int intValue = (Integer)this.waitingTime.elementAt(i);
                this.waitingTime.setElementAt(Integer.valueOf(String.valueOf(intValue -= diffTime)), i);
                if (intValue > 0) continue;
                ((Body)this.waitingForDynamic.elementAt(i)).setDynamic(true);
                this.waitingForDynamic.removeElementAt(i);
                this.waitingTime.removeElementAt(i);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException intValue) {
                // empty catch block
            }
        }
        if (this.removeBodies) {
            for (i = 0; i < this.getBodyCount() && this.viewField >= 100; ++i) {
                Body[] bodies = this.getBodies();
                Body body = bodies[i];
                if (body.positionFX().xAsInt() >= this.barrierX && body.positionFX().yAsInt() <= this.lowestY + 2000 || body == this.carbody || body == this.leftWheel || body == this.rightWheel) continue;
                this.removeBody(body);
            }
        }
        this.prevBodyTickTime = System.currentTimeMillis();
    }

    public void setWheelColor(int color) {
        this.currColWheel = color;
    }

    public void drawWorld(Graphics g, int[][] structuresData, int structureRingBufferOffset, int structureCount) {
        g.setColor(this.currColBg);
        g.fillRect(0, 0, scWidth, scHeight);
        try {
            this.carX = this.carbody.positionFX().xAsInt();
            this.carY = this.carbody.positionFX().yAsInt();
            this.calcZoomOut();
            this.calcOffset();
            this.drawBg(g);
            if (structuresData != null && !this.legacyDrawingMethod) {
                try {
                    this.drawLandscape(g, structuresData, structureRingBufferOffset, structureCount);
                }
                catch (Exception ex) {
                    Logger.log(ex);
                }
            } else {
                this.drawLandscape(g);
            }
            this.drawBodies(g);
            this.drawCar(g);
        }
        catch (NullPointerException ex) {
            int l = scWidth * 2 / 3;
            int h = scHeight / 24;
            g.drawRect(scWidth / 2 - l / 2, scHeight * 2 / 3, l, h);
            g.fillRect(scWidth / 2 - l / 2, scHeight * 2 / 3, l / 5, h);
            Logger.log(ex);
        }
    }

    private void drawBg(Graphics g) {
        if (this.game.points == 292) {
            this.currColBg = 0x2F92FF;
            this.currColLandscape = 0xFFFFFF;
        } else if (this.game.points == 293) {
            this.currColBg = this.colBg;
            this.currColLandscape = this.colLandscape;
        }
        if (this.bg) {
            int i;
            int sunR = Math.min(scWidth, scHeight) / 4;
            int sunCenterY = scHeight - scHeight * 3 / 5;
            g.setColor(191, 0, 127);
            int offset = (this.carX - this.bgXOffset) / 32;
            int l = scWidth * 4;
            int y1 = sunCenterY + sunR;
            int y2 = scHeight;
            int ii = 0;
            int n = l / this.bgLineStep;
            for (i = 0; i < n; ++i) {
                int x2 = -(ii + offset % this.bgLineStep - l / 2);
                ii += this.bgLineStep;
                int x1 = x2 / 4;
                int thickness = this.bgLineThickness;
                if (Math.abs(i * 8 - n * 4) > n) {
                    --thickness;
                }
                this.drawLine(g, x1 + this.halfScWidth, y1, x2 + this.halfScWidth, y2, thickness, false);
            }
            n = scHeight * 2 / this.bgLineStep;
            for (i = 0; i < n; ++i) {
                if (i == 1) continue;
                int y = y1 + (y2 - y1) * i * i / n / n;
                this.drawLine(g, 0, y, scWidth, y, 1, false);
            }
            g.setColor(255, 170, 0);
            int lines = 6;
            g.fillArc(this.halfScWidth - sunR, sunCenterY - sunR, sunR * 2, sunR * 2, 0, 360);
            g.setColor(this.currColBg);
            for (int i2 = 0; i2 < lines; ++i2) {
                int y = i2 * sunR / lines + sunCenterY - sunR / 12;
                this.drawLine(g, 0, y, scWidth, y, this.bgLineThickness * 2 * (i2 + 1) / lines, false);
            }
        }
    }

    private void drawBodies(Graphics g) {
        Body[] bodies = this.getBodies();
        int bodyCount = this.getBodyCount();
        for (int i = 0; i < bodyCount; ++i) {
            if (bodies[i] == this.leftWheel || bodies[i] == this.rightWheel) continue;
            UserData userData = bodies[i].getUserData();
            if (userData instanceof MUserData) {
                MUserData mUserData = (MUserData)userData;
                int bodyType = mUserData.bodyType;
                switch (bodyType) {
                    case 11: {
                        g.setColor(mUserData.color);
                        break;
                    }
                    case 13: {
                        g.setColor(0xFFAA00);
                        break;
                    }
                    case 12: {
                        g.setColor(65280);
                        break;
                    }
                    case 14: {
                        g.setColor(0xFF5500);
                        break;
                    }
                    default: {
                        g.setColor(this.currColBodies);
                        break;
                    }
                }
            } else {
                g.setColor(this.currColBodies);
            }
            this.drawBody(g, bodies[i]);
        }
    }

    private void drawBody(Graphics g, Body b) {
        FXVector[] positions = b.getVertices();
        if (positions.length == 1) {
            int radius = FXUtil.fromFX(b.shape().getBoundingRadiusFX());
            this.drawArc(g, this.xToPX(b.positionFX().xAsInt() - radius), this.yToPX(b.positionFX().yAsInt() - radius), radius * 2000 / this.zoomOut, radius * 2000 / this.zoomOut, 0, 360, 10, this.currColBg);
        } else {
            if (b == this.carbody) {
                int prevColor = g.getColor();
                g.setColor(this.currColBg);
                if (DebugMenu.whatTheGame) {
                    g.setColor(0xFF0000);
                }
                g.fillTriangle(this.xToPX(positions[0].xAsInt()), this.yToPX(positions[0].yAsInt()), this.xToPX(positions[1].xAsInt()), this.yToPX(positions[1].yAsInt()), this.xToPX(positions[2].xAsInt()), this.yToPX(positions[2].yAsInt()));
                g.fillTriangle(this.xToPX(positions[0].xAsInt()), this.yToPX(positions[0].yAsInt()), this.xToPX(positions[3].xAsInt()), this.yToPX(positions[3].yAsInt()), this.xToPX(positions[2].xAsInt()), this.yToPX(positions[2].yAsInt()));
                g.setColor(prevColor);
            }
            for (int i = 0; i < positions.length - 1; ++i) {
                this.drawLine(g, this.xToPX(positions[i].xAsInt()), this.yToPX(positions[i].yAsInt()), this.xToPX(positions[i + 1].xAsInt()), this.yToPX(positions[i + 1].yAsInt()), 10);
                if (b == this.carbody) continue;
                g.fillTriangle(this.xToPX(positions[0].xAsInt()), this.yToPX(positions[0].yAsInt()), this.xToPX(positions[i].xAsInt()), this.yToPX(positions[i].yAsInt()), this.xToPX(positions[i + 1].xAsInt()), this.yToPX(positions[i + 1].yAsInt()));
            }
            this.drawLine(g, this.xToPX(positions[positions.length - 1].xAsInt()), this.yToPX(positions[positions.length - 1].yAsInt()), this.xToPX(positions[0].xAsInt()), this.yToPX(positions[0].yAsInt()), 10);
        }
    }

    private void drawCar(Graphics g) {
        this.drawWheel(g, this.leftWheel);
        this.drawWheel(g, this.rightWheel);
    }

    private void drawLandscape(Graphics g) {
        Landscape landscape = this.getLandscape();
        for (int i = 0; i < landscape.segmentCount(); ++i) {
            int stPointX = this.xToPX(landscape.startPoint(i).xAsInt());
            int stPointY = this.yToPX(landscape.startPoint(i).yAsInt());
            int endPointX = this.xToPX(landscape.endPoint(i).xAsInt());
            int endPointY = this.yToPX(landscape.endPoint(i).yAsInt());
            if (!(stPointX < scWidth | endPointX > 0)) continue;
            if (!DebugMenu.isDebugEnabled) {
                g.setColor(this.currColLandscape);
            } else {
                g.setColor(255, 255, 255);
            }
            if (DebugMenu.whatTheGame) {
                this.drawGroundLine(g, stPointX, stPointY, endPointX, endPointY, 24);
            } else {
                this.drawLine(g, stPointX, stPointY, endPointX, endPointY, 24);
            }
            g.setColor(0xFF0000);
            if (!DebugMenu.showLinePoints) continue;
            g.fillArc(stPointX - 1, stPointY - 1, 2, 2, 0, 360);
            g.fillArc(endPointX - 1, endPointY - 1, 2, 2, 0, 360);
        }
    }

    private void drawLandscape(Graphics g, int[][] structuresData, int structureRingBufferOffset, int structureCount) {
        int prevStructureEndX = 0;
        int prevStructureEndY = 0;
        for (int i = structureRingBufferOffset; i < structureRingBufferOffset + structureCount; ++i) {
            int[] structureData = structuresData[i % structuresData.length];
            int c = 0;
            int endX = structureData[c++];
            int endY = structureData[c++];
            int lineCount = structureData[c++];
            int structureID = structureData[c++];
            int color = this.currColLandscape;
            if (DebugMenu.structureDebug) {
                Random random = new Random(structureID);
                g.setColor(64 + random.nextInt(192), 64 + random.nextInt(192), 64 + random.nextInt(192));
                color = g.getColor();
            } else if (DebugMenu.isDebugEnabled) {
                g.setColor(0xFFFFFF);
            } else {
                g.setColor(this.currColLandscape);
            }
            if (this.xToPX(endX) < 0) {
                prevStructureEndX = endX;
                prevStructureEndY = endY;
                continue;
            }
            block7: while (c < structureData.length - 1) {
                int id = structureData[c++];
                switch (id) {
                    case 1: {
                        int x1 = this.xToPX(structureData[c++]);
                        int y1 = this.yToPX(structureData[c++]);
                        this.drawLine(g, x1, y1, this.xToPX(structureData[c++]), this.yToPX(structureData[c++]), 24);
                        break;
                    }
                    case 2: {
                        int pointsCount = structureData[c++];
                        int prevX = this.xToPX(structureData[c++]);
                        int prevY = this.yToPX(structureData[c++]);
                        for (int j = 1; j < pointsCount; ++j) {
                            int n = prevX;
                            int n2 = prevY;
                            prevX = this.xToPX(structureData[c++]);
                            prevY = this.yToPX(structureData[c++]);
                            this.drawLine(g, n, n2, prevX, prevY, 24);
                        }
                        continue block7;
                    }
                    case 3: {
                        int x = structureData[c++];
                        int y = structureData[c++];
                        int r = structureData[c++];
                        g.drawArc(this.xToPX(x - r), this.yToPX(y - r), r * 2 * 1000 / this.zoomOut, r * 2 * 1000 / this.zoomOut, 0, 360, 24, this.zoomOut, this.betterGraphics, true, true);
                        break;
                    }
                    case 4: {
                        int x = structureData[c++];
                        int y = structureData[c++];
                        int r = structureData[c++];
                        int startAngle = structureData[c++];
                        int arcAngle = structureData[c++];
                        if (arcAngle == 0) {
                            arcAngle = 360;
                        }
                        int kx = structureData[c++];
                        int ky = structureData[c++];
                        if (DebugMenu.structureDebug && !DebugMenu.simulationMode) {
                            g.drawString("startAngle=" + startAngle, this.xToPX(x), this.yToPX(y), 33);
                            g.drawString("arcAngle=" + arcAngle, this.xToPX(x), this.yToPX(y), 17);
                        }
                        g.drawArc(this.xToPX(x - r * kx / 10), this.yToPX(y - r * ky / 10), r * 2 * kx * 100 / this.zoomOut, r * 2 * ky * 100 / this.zoomOut, startAngle, arcAngle, 24, this.zoomOut, this.betterGraphics, true, true);
                        break;
                    }
                }
            }
            if (DebugMenu.structureDebug) {
                if (prevStructureEndX == 0) {
                    prevStructureEndX = endX - 1000;
                    prevStructureEndY = endY - 100;
                }
                g.setColor(51);
                String str = String.valueOf(lineCount);
                int x = this.xToPX((endX + prevStructureEndX) / 2);
                int y = this.yToPX((endY + prevStructureEndY) / 2);
                int w = g.stringWidth(str);
                int h = g.getFontHeight();
                g.fillRect(x - w / 2, y - h / 2, w, h);
                g.setColor(color);
                g.drawLine(this.xToPX(endX), 0, this.xToPX(endX), scHeight);
                g.drawString(str, x, y, 3);
            }
            prevStructureEndX = endX;
            prevStructureEndY = endY;
            if (this.xToPX(endX) >= scWidth) break;
        }
    }

    private void drawWheel(Graphics g, Body b) {
        int radius = FXUtil.fromFX(b.shape().getBoundingRadiusFX());
        if (this.game.currentEffects[0] == null) {
            this.currColWheel = this.currColBg;
            if (DebugMenu.discoMode) {
                this.currColWheel = this.random.nextInt(0x1000000);
                this.currColBodies = this.random.nextInt(0x1000000);
            }
        }
        g.setColor(this.currColWheel);
        g.fillArc(this.xToPX(b.positionFX().xAsInt() - radius), this.yToPX(b.positionFX().yAsInt() - radius), radius * 2000 / this.zoomOut, radius * 2000 / this.zoomOut, 0, 360);
        g.setColor(this.currColBodies);
        this.drawArc(g, this.xToPX(b.positionFX().xAsInt() - radius), this.yToPX(b.positionFX().yAsInt() - radius), radius * 2000 / this.zoomOut, radius * 2000 / this.zoomOut, 0, 360, 10, this.currColWheel);
    }

    private void drawLine(Graphics g, int x1, int y1, int x2, int y2, int thickness) {
        this.drawLine(g, x1, y1, x2, y2, thickness, true);
    }

    private void drawLine(Graphics g, int x1, int y1, int x2, int y2, int thickness, boolean zoomThickness) {
        if (DebugMenu.discoMode) {
            g.setColor(this.random.nextInt(0x1000000));
        }
        g.drawLine(x1, y1, x2, y2, thickness, this.zoomOut, this.betterGraphics, zoomThickness);
    }

    private void drawGroundLine(Graphics g, int x1, int y1, int x2, int y2, int thickness) {
        g.setColor(0x333300);
        if (DebugMenu.discoMode) {
            g.setColor(this.random.nextInt(0x1000000));
        }
        int y3 = Math.max(y1, y2);
        int x3 = x1;
        if (y3 == y1) {
            x3 = x2;
        }
        g.fillTriangle(x1, y1, x2, y2, x3, y3);
        g.fillRect(x1, y3, x2 - x1, scHeight - y3);
        g.setColor(65280);
        g.drawLine(x1, y1, x2, y2, thickness, this.zoomOut, this.betterGraphics);
    }

    private void drawArc(Graphics g, int x, int y, int w, int h, int startAngle, int arcAngle, int thickness, int fillColor) {
        int prevColor = g.getColor();
        if ((thickness = thickness * 500 / this.zoomOut * 2) > 1 && this.betterGraphics) {
            g.fillArc(x - thickness / 2, y - thickness / 2, w + thickness, h + thickness, startAngle, arcAngle);
            g.setColor(fillColor);
            g.fillArc(x + thickness / 2, y + thickness / 2, w - thickness, h - thickness, startAngle, arcAngle);
            g.setColor(prevColor);
        } else {
            g.drawArc(x, y, w, h, startAngle, arcAngle);
        }
    }

    public int xToPX(int c) {
        return c * 1000 / this.zoomOut + this.offsetX;
    }

    public int yToPX(int c) {
        return c * 1000 / this.zoomOut + this.offsetY;
    }

    public void refreshCarPos() {
        if (this.carbody != null) {
            FXVector posFX = this.carbody.positionFX();
            this.carX = posFX.xAsInt();
            this.carY = posFX.yAsInt();
        } else {
            this.carX = -8000;
            this.carY = 0;
        }
    }

    public void refreshScreenParameters(int w, int h) {
        Logger.log("world:refreshing screen params:");
        Logger.log(w + " " + h);
        if (w <= 0 || h <= 0) {
            return;
        }
        scWidth = w;
        this.halfScWidth = scWidth / 2;
        scHeight = h;
        this.scMinSide = Math.min(scWidth, scHeight);
        this.bgLineStep = this.scMinSide / 3;
        this.zoomOutBase = 2000000 / this.scMinSide;
        this.calcZoomOut();
        this.bgLineThickness = Math.max(w, h) / 250;
        this.bg = bgOverride;
        try {
            this.betterGraphics = MobappGameSettings.isBetterGraphicsEnabled(Math.max(scWidth, scHeight) >= 480);
            this.currColLandscape = this.colLandscape = MobappGameSettings.getLandscapeColor();
            this.bg = this.bg || MobappGameSettings.isBGEnabled(false);
            this.legacyDrawingMethod = MobappGameSettings.isLegacyDrawingMethodEnabled(false);
        }
        catch (Throwable ex) {
            Logger.log(ex);
        }
        if (this.bg) {
            this.colBg = 1376305;
        }
    }

    private void calcZoomOut() {
        if (DebugMenu.simulationMode) {
            this.zoomOut = 50000;
        } else {
            this.zoomOut = 1000 * (this.carY - 1000) / this.scMinSide;
            int zoomOutBase = this.zoomOutBase;
            if (this.game.currentEffects[0] != null && this.game.currentEffects[0][0] > 0) {
                this.zoomOut = this.zoomOut * this.game.currentEffects[0][2] / 100;
                zoomOutBase = zoomOutBase * this.game.currentEffects[0][2] / 100;
            }
            if (this.zoomOut < 1) {
                this.zoomOut = -this.zoomOut;
                ++this.zoomOut;
            }
            this.zoomOut += zoomOutBase;
            if (Math.abs(this.zoomOut) < 500000 / this.scMinSide) {
                this.zoomOut = 500000 / this.scMinSide * Mathh.sign(this.zoomOut);
            }
        }
        this.viewField = scWidth * this.zoomOut / 1000;
        if (DebugMenu.isDebugEnabled && DebugMenu.closerWorldgen || DebugMenu.simulationMode) {
            this.viewField /= 4;
        }
    }

    private void calcOffset() {
        this.offsetX = -this.carX * 1000 / this.zoomOut + scWidth / 3;
        this.offsetY = -this.carY * 1000 / this.zoomOut + scHeight * 2 / 3;
        this.offsetY += this.carY * this.scMinSide / 20000;
        this.offsetY = Mathh.constrain(-this.carY * 1000 / this.zoomOut + scHeight / 16, this.offsetY, -this.carY * 1000 / this.zoomOut + scHeight * 4 / 5);
    }

    public void moveBg(int dx) {
        this.bgXOffset += dx;
    }
}

