/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.game;

import at.emini.physics2D.World;
import at.emini.physics2D.util.PhysicsFileReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import mobileapplication3.game.GameplayCanvas;
import mobileapplication3.game.GenericMenu;
import mobileapplication3.game.GraphicsWorld;
import mobileapplication3.game.MenuCanvas;
import mobileapplication3.platform.FileUtils;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.RootContainer;
import utils.GameFileUtils;
import utils.MgStruct;

public class Levels
extends GenericMenu
implements Runnable {
    private static final String LEVELS_FOLDER_NAME = "MobappGame/Levels";
    private static int defaultSelected = 1;
    private String[] levelPaths = new String[0];
    private String[] buttons;
    private int builtinLevelsCount = 0;
    private boolean loadingLevel = false;

    public Levels() {
        Logger.log("Levels:constr");
        this.buttons = new String[2];
        this.builtinLevelsCount = this.seekForLevelsInRes();
        if (this.builtinLevelsCount > 0) {
            this.buttons = new String[this.builtinLevelsCount + 3];
            this.buttons[0] = "Levels";
            for (int i = 1; i <= this.builtinLevelsCount; ++i) {
                this.buttons[i] = "Level " + i;
            }
            this.buttons[this.buttons.length - 2] = "Load custom level";
        } else {
            this.seekForLevelsInFS();
        }
        this.refreshButtons();
    }

    private void refreshButtons() {
        this.buttons[this.buttons.length - 1] = "Back";
        defaultSelected = Math.min(defaultSelected, this.buttons.length - 1);
        this.loadParams(this.buttons, defaultSelected);
        this.setFirstReachable(1);
        this.selected = defaultSelected;
        if (this.w != 0 && this.h != 0) {
            this.loadCanvasParams(this.x0, this.y0, this.w, this.h);
        }
    }

    private void seekForLevelsInFS() {
        this.builtinLevelsCount = 0;
        try {
            this.levelPaths = this.getLevels();
            this.buttons = new String[this.levelPaths.length + 2];
            for (int i = 0; i < this.levelPaths.length; ++i) {
                this.buttons[1 + i] = this.getLevelName(this.levelPaths[i]);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            this.buttons[0] = "no read permission";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.buttons[0] = e.toString();
        }
        this.buttons[0] = "Load custom level or emini world";
        this.refreshButtons();
    }

    private int seekForLevelsInRes() {
        int c = 0;
        int i = 1;
        while (this.tryRes(this.getLevelResPath(i))) {
            Logger.log(this.getLevelResPath(i));
            ++c;
            ++i;
        }
        return c;
    }

    private String getLevelResPath(int i) {
        return "/l" + i + ".mglvl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryRes(String path) {
        InputStream is = null;
        try {
            is = Platform.getResource(path);
            DataInputStream dis = new DataInputStream(is);
            dis.readShort();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            Logger.log(path + " " + ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void openFromRes(String path) {
        if (this.isStopped || this.loadingLevel) {
            return;
        }
        this.loadingLevel = true;
        InputStream is = null;
        try {
            is = Platform.getResource(path);
            RootContainer.setRootUIComponent(Levels.openLevel(new DataInputStream(is)));
            this.isStopped = true;
        }
        catch (Exception ex) {
            Platform.showError("Can't open level!", ex);
            this.loadingLevel = false;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void init() {
        this.isStopped = false;
        this.getFontSize();
        new Thread((Runnable)this, "levels").start();
    }

    public String[] getLevels() {
        Logger.log("Levels:getLevels()");
        return GameFileUtils.listFilesInAllPlaces(LEVELS_FOLDER_NAME);
    }

    private String getLevelName(String path) {
        if (path != null) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return null;
    }

    public synchronized void openFromFS(final String path) {
        if (this.isStopped || this.loadingLevel) {
            return;
        }
        this.loadingLevel = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    GameplayCanvas gameCanvas = null;
                    if (path.endsWith(".phy")) {
                        gameCanvas = new GameplayCanvas(Levels.this.readWorldFile(path));
                    } else if (path.endsWith(".mglvl")) {
                        gameCanvas = Levels.openLevel(path);
                    }
                    if (gameCanvas != null) {
                        RootContainer.setRootUIComponent(gameCanvas);
                        Levels.this.isStopped = true;
                    }
                }
                catch (Exception ex) {
                    Platform.showError(ex);
                    Levels.this.loadingLevel = false;
                }
            }
        }).start();
    }

    private static GameplayCanvas openLevel(String path) {
        return Levels.openLevel(FileUtils.fileToDataInputStream(path));
    }

    private static GameplayCanvas openLevel(DataInputStream dis) {
        try {
            short[][] level = MgStruct.readFromDataInputStream(dis);
            if (level != null) {
                return new GameplayCanvas(new GraphicsWorld()).loadLevel(level);
            }
        }
        catch (IOException ex) {
            Platform.showError(ex);
        }
        return null;
    }

    public GraphicsWorld readWorldFile(String path) {
        DataInputStream is = FileUtils.fileToDataInputStream(path);
        PhysicsFileReader reader = new PhysicsFileReader(is);
        GraphicsWorld w = new GraphicsWorld(World.loadWorld(reader));
        reader.close();
        return w;
    }

    @Override
    public void selectPressed() {
        defaultSelected = this.selected;
        if (this.selected == this.buttons.length - 1) {
            this.isStopped = true;
            RootContainer.setRootUIComponent(new MenuCanvas());
        } else if (this.builtinLevelsCount > 0) {
            if (this.selected == this.buttons.length - 2) {
                this.seekForLevelsInFS();
            } else {
                this.openFromRes(this.getLevelResPath(this.selected));
            }
        } else {
            try {
                this.openFromFS(this.levelPaths[this.selected - 1]);
            }
            catch (Exception ex) {
                Platform.showError(ex);
            }
        }
    }

    @Override
    public void run() {
        Logger.log("Levels:run()");
        long sleep = 0L;
        long start = 0L;
        this.isPaused = false;
        while (!this.isStopped) {
            if (!this.isPaused) {
                start = System.currentTimeMillis();
                this.repaint();
                this.tick();
                sleep = 50L - (System.currentTimeMillis() - start);
                sleep = Math.max(sleep, 0L);
            } else {
                sleep = 100L;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

