/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.game;

import mobileapplication3.game.GameplayCanvas;
import mobileapplication3.game.GenericMenu;
import mobileapplication3.game.Levels;
import mobileapplication3.game.RecordsScreen;
import mobileapplication3.game.SettingsScreen;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import utils.MgStruct;

public class MenuCanvas
extends GenericMenu
implements Runnable {
    private final String[] menuOptions = new String[]{"", "Play", "Load Structures", "Levels", "Editor", "Records", "Settings", "Exit", ""};
    private static int defaultSelected = 1;
    private boolean isInited = false;
    private boolean isGameStarted = false;
    private int c = 0;
    private MgStruct mgStruct;
    private GameplayCanvas bg = null;
    private static boolean areExtStructsLoaded = false;
    private Thread menuThread = null;

    public MenuCanvas(GameplayCanvas bg) {
        this();
        this.bg = bg;
        if (bg != null) {
            this.bgColor = -1;
        }
    }

    public MenuCanvas() {
        Logger.log("menu:constr");
        this.loadParams(this.menuOptions, defaultSelected);
        this.setFirstReachable(1);
        this.setLastReachable(this.menuOptions.length - 2);
    }

    @Override
    public void init() {
        Logger.log("menu:init");
        if (areExtStructsLoaded) {
            this.setStateFor(1, 2);
            this.menuOptions[2] = "Reload";
        }
        try {
            Class.forName("mobileapplication3.editor.Editor");
        }
        catch (ClassNotFoundException ex) {
            this.setStateFor(-1, 4);
        }
        this.isInited = true;
    }

    @Override
    public void postInit() {
        if (this.menuThread == null) {
            this.menuThread = new Thread((Runnable)this, "menu canvas");
            this.menuThread.start();
        }
    }

    @Override
    public void run() {
        long sleep = 0L;
        long start = 0L;
        while (!this.isStopped) {
            if (!this.isPaused && this.hasParent()) {
                start = System.currentTimeMillis();
                this.repaint();
                sleep = 50L - (System.currentTimeMillis() - start);
                sleep = Math.max(sleep, 0L);
            } else {
                sleep = 100L;
            }
            if (this.c == 3 && this.bg != null) {
                this.bg.startAgain();
                this.bg.disablePointCounter();
                RootContainer.setRootUIComponent(this.bg);
                this.bg = null;
                this.stop();
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.menuThread = null;
    }

    @Override
    protected void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        try {
            if (this.bg != null && !this.bg.drawAsBG(g)) {
                this.bg = null;
            }
            if (this.isInited) {
                super.onPaint(g, x0, y0, w, h, forceInactive);
                this.tick();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        super.onSetBounds(x0, y0, w, h);
        if (this.bg != null) {
            this.bg.setSize(w, h);
        }
    }

    private synchronized void startGame() {
        if (this.isGameStarted) {
            return;
        }
        this.isGameStarted = true;
        Logger.log("menu:startGame()");
        this.repaint();
        try {
            this.stopBG();
            this.log("menu:new gCanvas");
            GameplayCanvas gameCanvas = new GameplayCanvas();
            this.log("menu:setting gCanvas displayable");
            RootContainer.setRootUIComponent(gameCanvas);
            this.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Platform.showError(ex);
            Logger.enableOnScreenLog(this.h);
            Logger.log("ex in startGame():");
            Logger.log(ex);
            this.repaint();
            this.isGameStarted = false;
        }
    }

    @Override
    public boolean handleKeyPressed(int keyCode, int count) {
        if (keyCode == 42 | keyCode == -10) {
            if (!Logger.isOnScreenLogEnabled()) {
                Logger.enableOnScreenLog(this.h);
            } else {
                Logger.disableOnScreenLog();
            }
        } else if (keyCode == 57) {
            ++this.c;
        }
        return super.handleKeyPressed(keyCode, count);
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        if (x < this.w / 32 && y < this.h / 32) {
            ++this.c;
            return true;
        }
        return super.handlePointerClicked(x, y);
    }

    @Override
    void selectPressed() {
        defaultSelected = this.selected;
        if (this.selected == 1) {
            this.startGame();
        }
        if (this.selected == 2) {
            this.loadMG();
        }
        if (this.selected == 3) {
            this.stop();
            RootContainer.setRootUIComponent(new Levels());
        }
        if (this.selected == 4) {
            this.stop();
            try {
                Class.forName("mobileapplication3.editor.Editor").newInstance();
            }
            catch (Exception ex) {
                Logger.log("Can't open editor: " + ex);
            }
            Logger.log("opened editor");
        }
        if (this.selected == 5) {
            this.stop();
            RootContainer.setRootUIComponent(new RecordsScreen());
        }
        if (this.selected == 6) {
            this.stop();
            RootContainer.setRootUIComponent(new SettingsScreen());
        }
        if (this.selected == 7) {
            this.stop();
            Platform.exit();
        }
    }

    private void stop() {
        this.isStopped = true;
        this.stopBG();
    }

    private void stopBG() {
        if (this.bg != null) {
            this.bg.stop(false, true);
        }
    }

    private void log(String s) {
        Logger.log(s);
        this.repaint();
    }

    private void loadMG() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ((MenuCanvas)MenuCanvas.this).menuOptions[2] = "Loading...";
                MenuCanvas.this.setStateFor(1, 2);
                MenuCanvas.this.mgStruct = new MgStruct();
                if (MenuCanvas.this.mgStruct.loadFromFiles()) {
                    areExtStructsLoaded = true;
                    ((MenuCanvas)MenuCanvas.this).menuOptions[2] = MgStruct.loadedStructsNumber - MgStruct.loadedFromResNumber + " loaded";
                    MenuCanvas.this.setColorEnabledOption(0x99FF00);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    ((MenuCanvas)MenuCanvas.this).menuOptions[2] = "Reload";
                } else {
                    areExtStructsLoaded = false;
                    ((MenuCanvas)MenuCanvas.this).menuOptions[2] = !((MenuCanvas)MenuCanvas.this).mgStruct.loadCancelled ? "Nothing loaded" : "Cancelled";
                    MenuCanvas.this.setColorEnabledOption(0x880000);
                }
            }
        }).start();
    }
}

