/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.game;

import java.util.Random;
import mobileapplication3.game.AboutScreen;
import mobileapplication3.game.DebugMenu;
import mobileapplication3.game.GenericMenu;
import mobileapplication3.game.GraphicsWorld;
import mobileapplication3.game.MenuCanvas;
import mobileapplication3.platform.Battery;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import utils.MobappGameSettings;

public class SettingsScreen
extends GenericMenu
implements Runnable {
    private static final int LANDSCAPE_COLOR = 0;
    private static final int HI_RES_GRAPHICS = 1;
    private static final int LEGACY_DRAWING_METHOD = 2;
    private static final int FRAME_TIME = 3;
    private static final int SHOW_FPS = 4;
    private static final int BATTERY = 5;
    private static final int DEBUG = 6;
    private static final int ABOUT = 7;
    private static final int BACK = 8;
    private static final int[] LANDSCAPE_COLORS = new int[]{GraphicsWorld.DEFAULT_LANDSCAPE_COLOR, 0x44AAFF, 0xAAAAFF, 0xFFFFFF, 0x44FFAA, 0xAAFF44, 0xFF44AA, 0xFFAA44};
    private static final String[] LANDSCAPE_COLOR_NAMES = new String[]{"blue", "light blue", "pale blue", "white", "light green", "lime", "pink", "orange"};
    private static String[] menuOpts = new String[9];
    private final int[] statemap = new int[menuOpts.length];
    private boolean batFailed = false;

    public SettingsScreen() {
        this.bgColor = -1;
        this.loadParams(menuOpts);
        this.loadStatemap(this.statemap);
    }

    @Override
    public void init() {
        this.getFontSize();
        this.setSpecialOption(6);
        this.setIsSpecialOptnActivated(DebugMenu.isDebugEnabled);
        this.refreshStates();
        new Thread((Runnable)this, "debug menu").start();
    }

    @Override
    public void run() {
        if (!this.isMenuInited()) {
            this.init();
        }
        while (!this.isStopped) {
            long sleep;
            if (!this.isPaused) {
                long start = System.currentTimeMillis();
                this.repaint();
                this.tick();
                sleep = 50L - (System.currentTimeMillis() - start);
                sleep = Math.max(sleep, 0L);
            } else {
                sleep = 200L;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (this.selected == 0) {
            int x;
            int color = MobappGameSettings.getLandscapeColor();
            Random random = new Random(color);
            int minScreenSide = Math.min(w, h);
            int d = minScreenSide / 16 + random.nextInt(minScreenSide / 8);
            while (Mathh.strictIneq(w / 3, (x = random.nextInt(w - d)) + d / 2, w * 2 / 3)) {
            }
            int y = random.nextInt(h - d);
            g.setColor(color);
            g.fillArc(x, y, d, d, 0, 360);
        }
        super.onPaint(g, x0, y0, w, h, forceInactive);
    }

    @Override
    void selectPressed() {
        int selected = this.selected;
        switch (selected) {
            case 2: {
                MobappGameSettings.toggleLegacyDrawingMethod();
                break;
            }
            case 3: {
                int value;
                int newFrameTime = value = MobappGameSettings.getFrameTime();
                if (newFrameTime <= 1) {
                    newFrameTime = 100;
                } else {
                    int prevFps = 1000 / value;
                    while (1000 / newFrameTime <= prevFps) {
                        --newFrameTime;
                    }
                }
                MobappGameSettings.setFrameTime(newFrameTime);
                break;
            }
            case 1: {
                MobappGameSettings.toggleBetterGraphics();
                break;
            }
            case 4: {
                MobappGameSettings.toggleFPSShown();
                break;
            }
            case 0: {
                MobappGameSettings.setLandscapeColor(LANDSCAPE_COLORS[(this.findArrayIndex(LANDSCAPE_COLORS, MobappGameSettings.getLandscapeColor()) + 1) % LANDSCAPE_COLORS.length]);
                break;
            }
            case 5: {
                if (!MobappGameSettings.isBattIndicatorEnabled()) {
                    if (!Battery.checkAndInit()) {
                        this.batFailed = true;
                        Logger.log("Battery init failed");
                        break;
                    }
                    int batLevel = Battery.getBatteryLevel();
                    if (batLevel == -1) {
                        String err;
                        SettingsScreen.menuOpts[selected] = err = "Can't get battery level";
                        Logger.log(err);
                        break;
                    }
                    SettingsScreen.menuOpts[selected] = "Battery: " + batLevel + "%";
                    Logger.log("bat method: " + Battery.getMethod());
                }
                MobappGameSettings.toggleBattIndicator();
                break;
            }
            case 6: {
                this.isStopped = true;
                RootContainer.setRootUIComponent(new DebugMenu());
                return;
            }
            case 7: {
                this.isStopped = true;
                RootContainer.setRootUIComponent(new AboutScreen());
                return;
            }
            case 8: {
                this.isStopped = true;
                RootContainer.setRootUIComponent(new MenuCanvas());
                return;
            }
        }
        this.refreshStates();
    }

    void refreshStates() {
        int frameTime = MobappGameSettings.getFrameTime();
        SettingsScreen.menuOpts[2] = "Legacy drawing method";
        SettingsScreen.menuOpts[3] = "FPS: " + this.round(1000.0f / (float)frameTime) + " (" + frameTime + "ms/frame)";
        SettingsScreen.menuOpts[1] = "Graphics for hi-res screens";
        SettingsScreen.menuOpts[4] = "Show FPS";
        SettingsScreen.menuOpts[0] = "Landscape color: " + LANDSCAPE_COLOR_NAMES[this.findArrayIndex(LANDSCAPE_COLORS, MobappGameSettings.getLandscapeColor())];
        SettingsScreen.menuOpts[5] = "Show battery level";
        SettingsScreen.menuOpts[6] = "Debug settings";
        SettingsScreen.menuOpts[7] = "About";
        SettingsScreen.menuOpts[8] = "Back";
        this.setEnabledFor(frameTime != 16, 3);
        this.setEnabledFor(MobappGameSettings.isLegacyDrawingMethodEnabled(), 2);
        this.setEnabledFor(MobappGameSettings.isBetterGraphicsEnabled(), 1);
        this.setEnabledFor(MobappGameSettings.isFPSShown(), 4);
        this.setEnabledFor(this.findArrayIndex(LANDSCAPE_COLORS, MobappGameSettings.getLandscapeColor()) != 0, 0);
        if (!this.batFailed) {
            this.setEnabledFor(MobappGameSettings.isBattIndicatorEnabled(), 5);
        } else {
            this.setStateFor(-1, 5);
        }
    }

    private double round(float d) {
        return Math.floor((double)(d * 100.0f) + 0.5) / 100.0;
    }

    private int findArrayIndex(int[] arr, int a) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != a) continue;
            return i;
        }
        return 0;
    }
}

