/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.game;

import at.emini.physics2D.Body;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import java.util.Random;
import java.util.Vector;
import mobileapplication3.game.DebugMenu;
import mobileapplication3.game.ElementPlacer;
import mobileapplication3.game.GameplayCanvas;
import mobileapplication3.game.GraphicsWorld;
import mobileapplication3.game.StructurePlacer;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Mathh;
import utils.MgStruct;

public class WorldGen
implements Runnable {
    private static final int BUILTIN_STRUCTS_NUMBER = 6;
    private static final int FLOOR_RANDOM_WEIGHT = 4;
    public final Object lock = new Object();
    public static boolean isEnabled = false;
    private int prevStructRandomId;
    private int nextStructRandomId;
    private boolean isResettingPosition = false;
    private Vector deferredStructures = null;
    public int firstDeferredStructureX = -1;
    public int lastX;
    public int lastY;
    private final int POINTS_DIVIDER = 2000;
    private int nextPointsCounterTargetX;
    int tick = 0;
    public int mspt;
    private boolean paused = false;
    private boolean needSpeed = true;
    private final Random rand;
    private final GameplayCanvas game;
    private final GraphicsWorld w;
    private final Landscape landscape;
    private StructLog structLogger;
    private Thread wgThread = null;
    public int currStep;
    public static final int STEP_IDLE = 0;
    public static final int STEP_ADD = 1;
    public static final int STEP_RES_POS = 2;
    public static final int STEP_CLEAN_SGS = 3;

    public WorldGen(GameplayCanvas game, GraphicsWorld w) {
        w.lowestY = 2000;
        Logger.log("wg:starting");
        this.game = game;
        this.w = w;
        this.landscape = w.getLandscape();
        Logger.log("wg:start()");
        this.rand = new Random();
        Logger.log("wg:loading mgstruct");
        new MgStruct();
        this.reset();
        this.start();
    }

    public void addDeferredStructure(short[][] structureData) {
        if (this.deferredStructures == null) {
            this.deferredStructures = new Vector();
        }
        this.deferredStructures.addElement(structureData);
    }

    @Override
    public void run() {
        Logger.log("wg:run()");
        while (isEnabled) {
            try {
                this.tick();
            }
            catch (NullPointerException ex) {
                Logger.log(ex);
            }
        }
        Logger.log("wg stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        long startTime = System.currentTimeMillis();
        if (!this.paused || this.needSpeed) {
            this.w.refreshCarPos();
            if (this.w.carX + this.w.viewField * 2 > this.lastX) {
                this.currStep = 1;
                this.placeNext();
            } else {
                if (!this.structLogger.shouldRmFirstStruct()) {
                    this.needSpeed = false;
                }
                this.game.shouldWait = false;
                if (this.game.isWaiting) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.notify();
                    }
                }
            }
            if (this.tick == 0) {
                this.currStep = 2;
                if (this.w.carX > 3000 && (this.game.timeFlying > -1 || this.game.uninterestingDebug)) {
                    this.resetPosition();
                }
                this.w.refreshCarPos();
                if (this.w.carX > this.nextPointsCounterTargetX) {
                    this.nextPointsCounterTargetX += 2000;
                    ++this.game.points;
                }
            }
            this.currStep = 3;
            this.structLogger.rmFarStructures();
        }
        this.currStep = 0;
        ++this.tick;
        if (this.tick >= 10) {
            this.tick = 0;
        }
        try {
            if (!this.needSpeed) {
                Thread.yield();
                Thread.sleep(20L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mspt = (int)(System.currentTimeMillis() - startTime);
    }

    private void placeNext() {
        int[] structData;
        int idsCount = DebugMenu.mgstructOnly ? MgStruct.loadedStructsNumber : 10 + MgStruct.loadedStructsNumber;
        while (this.nextStructRandomId == this.prevStructRandomId || DebugMenu.whatTheGame && (this.nextStructRandomId < 6 || this.nextStructRandomId > 9)) {
            this.nextStructRandomId = this.rand.nextInt(idsCount);
        }
        this.prevStructRandomId = this.nextStructRandomId;
        if (DebugMenu.mgstructOnly) {
            this.nextStructRandomId += 10;
        }
        if (this.lastY > 1000 | this.lastY < -1000) {
            Logger.log("normalizing height: (was " + this.lastY + ")");
            structData = StructurePlacer.floor(this.w, this.isResettingPosition, this.lastX, this.lastY, 1000 + this.rand.nextInt(4) * 100, (this.rand.nextInt(7) - 3) * 100);
        } else {
            Logger.log("+id", this.nextStructRandomId);
            if (this.deferredStructures != null && !this.needSpeed && !this.deferredStructures.isEmpty()) {
                if (this.firstDeferredStructureX == -1) {
                    this.firstDeferredStructureX = this.lastX;
                }
                structData = StructurePlacer.place(this.w, this.isResettingPosition, (short[][])this.deferredStructures.elementAt(0), this.lastX, this.lastY);
                this.deferredStructures.removeElementAt(0);
                if (this.deferredStructures.isEmpty()) {
                    this.deferredStructures = null;
                }
            } else {
                switch (this.nextStructRandomId) {
                    case 0: {
                        structData = StructurePlacer.arc1(this.w, this.isResettingPosition, this.lastX, this.lastY, 200 + Math.abs(this.rand.nextInt()) % 400);
                        break;
                    }
                    case 1: {
                        int halfPeriods = 4 + this.rand.nextInt(8);
                        int l = halfPeriods * 180;
                        int amp = 15;
                        structData = StructurePlacer.sinStruct(this.w, this.isResettingPosition, this.lastX, this.lastY, l, halfPeriods, 0, amp);
                        break;
                    }
                    case 2: {
                        structData = StructurePlacer.floorStat(this.w, this.isResettingPosition, this.lastX, this.lastY, 400 + this.rand.nextInt(10) * 100);
                        break;
                    }
                    case 3: {
                        structData = StructurePlacer.arc2(this.w, this.isResettingPosition, this.lastX, this.lastY, 500 + Math.abs(this.rand.nextInt()) % 500, 20);
                        break;
                    }
                    case 4: {
                        structData = StructurePlacer.abyss(this.w, this.isResettingPosition, this.lastX, this.lastY, this.rand.nextInt(6) * 1000);
                        break;
                    }
                    case 5: {
                        int n = this.rand.nextInt(6) + 5;
                        structData = StructurePlacer.slantedDottedLine(this.w, this.isResettingPosition, this.lastX, this.lastY, n);
                        break;
                    }
                    default: {
                        structData = Mathh.strictIneq(5, this.nextStructRandomId, 10) ? StructurePlacer.floor(this.w, this.isResettingPosition, this.lastX, this.lastY, 400 + this.rand.nextInt(10) * 100, (this.rand.nextInt(7) - 3) * 100) : this.placeMGStructByRelativeID(this.nextStructRandomId);
                    }
                }
            }
        }
        this.lastX = structData[0];
        this.lastY = structData[1];
        this.structLogger.add(structData);
        Logger.log("lastX=", this.lastX);
    }

    public void start() {
        isEnabled = true;
        if (this.wgThread == null || !this.wgThread.isAlive()) {
            this.wgThread = new Thread((Runnable)this, "wg");
            this.wgThread.start();
        }
    }

    public void pause() {
        Logger.log("wg pause");
        this.needSpeed = true;
        this.paused = true;
    }

    public void resume() {
        Logger.log("wg resume");
        this.paused = false;
    }

    public void stop() {
        boolean succeed;
        Logger.log("stopping wg thread...");
        isEnabled = false;
        boolean bl = succeed = this.wgThread == null;
        while (!succeed) {
            try {
                this.wgThread.join();
                succeed = true;
            }
            catch (InterruptedException ex) {
                Logger.log(ex);
            }
        }
        Logger.log("wg: stopped");
    }

    public void reset() {
        this.needSpeed = true;
        Logger.log("wg:restart()");
        this.prevStructRandomId = 1;
        this.nextStructRandomId = 2;
        this.lastX = -2900;
        this.nextPointsCounterTargetX = this.lastX + 2000;
        this.lastY = 0;
        try {
            Logger.log("wg:cleaning world");
            this.w.cleanWorld();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.structLogger = new StructLog(10);
        ElementPlacer elementPlacer = new ElementPlacer(this.w, this.isResettingPosition);
        int x1 = this.lastX - 600;
        int y1 = this.lastY - 100;
        elementPlacer.line(x1, y1, this.lastX, this.lastY);
        this.structLogger.add(WorldGen.concatArrays(new int[]{this.lastX, this.lastY, elementPlacer.getLineCount(), -1}, elementPlacer.getDrawingData()));
    }

    public int getSegmentCount() {
        try {
            return this.landscape.segmentCount();
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int[][] getStructures() {
        return this.structLogger.getStructures();
    }

    public int getStructuresCount() {
        return this.structLogger.getNumberOfLogged();
    }

    public int getStructuresRingBufferOffset() {
        return this.structLogger.getRingBufferOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPosition() {
        int dx;
        this.isResettingPosition = true;
        Object object = this.lock;
        synchronized (object) {
            dx = -3000 - this.w.carbody.positionFX().xAsInt();
            this.lastX += dx;
            Logger.log("resetting pos");
            this.moveLandscape(dx);
            this.moveBodies(dx);
            this.structLogger.moveXAllElements(dx);
            this.w.barrierX += dx;
            this.w.moveBg(dx);
            this.nextPointsCounterTargetX += dx;
            this.firstDeferredStructureX += dx;
            this.isResettingPosition = false;
        }
        this.game.onPosReset(dx);
    }

    private void moveLandscape(int dx) {
        this.movePoints(this.landscape.elementStartPoints(), dx);
        this.movePoints(this.landscape.elementEndPoints(), dx);
    }

    private void movePoints(FXVector[] points, int dx) {
        try {
            for (int i = 0; i < this.landscape.segmentCount(); ++i) {
                FXVector point = points[i];
                points[i] = new FXVector(point.xFX + FXUtil.toFX(dx), point.yFX);
            }
        }
        catch (NullPointerException ex) {
            Logger.log(ex);
        }
    }

    private void moveBodies(int dx) {
        Body[] bodies = this.w.getBodies();
        for (int i = 0; i < this.w.getBodyCount(); ++i) {
            bodies[i].translate(FXVector.newVector(dx, 0), 0);
        }
    }

    private int[] placeMGStructByRelativeID(int relID) {
        int id = relID - 4 - 6;
        return this.placeMGStructByID(id);
    }

    private int[] placeMGStructByID(int id) {
        short[][] data = MgStruct.structStorage[id];
        if (data.length < 1) {
            Logger.log("mgs" + id + " is broken: data.length=", data.length);
            return null;
        }
        Logger.log("+mgs", id);
        int[] structureData = StructurePlacer.place(this.w, this.isResettingPosition, data, this.lastX, this.lastY);
        structureData[3] = 6 + id;
        return structureData;
    }

    public static int[] concatArrays(int[] arr1, int[] arr2) {
        if (arr1 == null) {
            return arr2;
        }
        if (arr2 == null) {
            return arr1;
        }
        int[] structData = new int[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, structData, 0, arr1.length);
        System.arraycopy(arr2, 0, structData, arr1.length, arr2.length);
        return structData;
    }

    private class StructLog {
        private static final boolean DEBUG = false;
        public static final int MAX_DIST_TO_RM_STRUCT = 4000;
        public static final int MAX_DIST_TO_RM_STRUCT_IN_SIMULATION = 300;
        private int[][] structLog;
        private int numberOfLoggedStructs = 0;
        private int ringLogStart = 0;
        private boolean isLeftBarrierAdded = false;

        public StructLog(int structLogSize) {
            this.structLog = new int[structLogSize][];
        }

        public void add(int[] structureData) {
            if (this.numberOfLoggedStructs >= this.structLog.length) {
                int ns = this.structLog.length + 1;
                this.logDebug("structLog len => " + ns);
                this.increase(ns);
            }
            int nextID = (this.ringLogStart + this.numberOfLoggedStructs) % this.structLog.length;
            this.logDebug("logging struct to " + nextID);
            this.structLog[nextID] = structureData;
            ++this.numberOfLoggedStructs;
        }

        public void increase(int newSize) {
            if (newSize < this.structLog.length) {
                throw new IllegalArgumentException("newSize can't be less than current size");
            }
            int[][] tmp = this.structLog;
            this.structLog = new int[newSize][];
            System.arraycopy(tmp, this.ringLogStart, this.structLog, 0, tmp.length - this.ringLogStart);
            System.arraycopy(tmp, 0, this.structLog, tmp.length - this.ringLogStart, this.ringLogStart);
            this.ringLogStart = 0;
        }

        public int[] getElementAt(int i) {
            int id = this.getElementID(i);
            return this.structLog[id];
        }

        public int getElementID(int i) {
            return (this.ringLogStart + i) % this.structLog.length;
        }

        public int getNumberOfLogged() {
            return this.numberOfLoggedStructs;
        }

        public int getSize() {
            return this.structLog.length;
        }

        public int getRingBufferOffset() {
            return this.ringLogStart;
        }

        public int[][] getStructures() {
            return this.structLog;
        }

        public void rmFirstElement() {
            this.ringLogStart = (this.ringLogStart + 1) % this.structLog.length;
            --this.numberOfLoggedStructs;
        }

        public void moveXAllElements(int dx) {
            for (int i = 0; i < this.getSize(); ++i) {
                int[] structureData = this.getElementAt(i);
                if (structureData == null) continue;
                structureData[0] = structureData[0] + dx;
                if (structureData.length <= 4) continue;
                int c = 4;
                block7: while (c < structureData.length - 1) {
                    int id = structureData[c++];
                    switch (id) {
                        case 1: {
                            int n = c++;
                            structureData[n] = structureData[n] + dx;
                            int n2 = ++c;
                            ++c;
                            structureData[n2] = structureData[n2] + dx;
                            ++c;
                            break;
                        }
                        case 2: {
                            int pointsCount = structureData[c++];
                            for (int j = 0; j < pointsCount; ++j) {
                                int n = c++;
                                structureData[n] = structureData[n] + dx;
                                ++c;
                            }
                            continue block7;
                        }
                        case 3: {
                            int n = c++;
                            structureData[n] = structureData[n] + dx;
                            ++c;
                            ++c;
                            break;
                        }
                        case 4: {
                            int n = c++;
                            structureData[n] = structureData[n] + dx;
                            ++c;
                            ++c;
                            ++c;
                            ++c;
                            ++c;
                            ++c;
                        }
                    }
                }
            }
        }

        public void rmFarStructures() {
            if (this.shouldRmFirstStruct()) {
                if (!this.isLeftBarrierAdded) {
                    ((WorldGen)WorldGen.this).w.barrierX = this.structLog[this.getElementID(0)][0];
                    this.logDebug("barrier: x=" + ((WorldGen)WorldGen.this).w.barrierX);
                    WorldGen.this.landscape.addSegment(FXVector.newVector(((WorldGen)WorldGen.this).w.barrierX, -10000), FXVector.newVector(((WorldGen)WorldGen.this).w.barrierX, 10000), (short)1);
                    int[] nArray = this.structLog[this.getElementID(1)];
                    nArray[2] = nArray[2] + 1;
                    this.isLeftBarrierAdded = true;
                }
                int deletedSegments = 0;
                for (int i = 0; i < Math.min(this.getElementAt(0)[2], 3); ++i) {
                    WorldGen.this.landscape.removeSegment(0);
                    ++deletedSegments;
                }
                int id = this.getElementID(0);
                int[] nArray = this.structLog[id];
                nArray[2] = nArray[2] - deletedSegments;
                if (this.getElementAt(0)[2] == 0) {
                    this.isLeftBarrierAdded = false;
                    this.rmFirstElement();
                }
            }
        }

        public boolean shouldRmFirstStruct() {
            int maxDistToRemove = 4000;
            if (DebugMenu.simulationMode) {
                maxDistToRemove = 300;
            }
            try {
                if (this.getNumberOfLogged() > 0) {
                    return ((WorldGen)WorldGen.this).w.carX - this.getElementAt(0)[0] > maxDistToRemove;
                }
                return false;
            }
            catch (NullPointerException ex) {
                Logger.enableOnScreenLog(GraphicsWorld.scHeight);
                Logger.log(ex);
                Logger.logErr("structLog:critical err");
                return false;
            }
        }

        private void logDebug(String message) {
        }
    }
}

