/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.platform;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Vector;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;

public class FileUtils {
    public static final String PREFIX = "";
    public static final char SEP = '/';
    private static final String[] FOLDERS_ON_EACH_DRIVE = new String[]{""};
    private static final short[] TESTDATA = new short[]{0, 1, 2, 3};
    private static String storagePath = System.getProperty("user.dir", ".") + '/' + "Mobapp";

    public static void saveShortArrayToFile(short[] arr, String path) throws IOException, SecurityException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(arr.length * 2);
        DataOutputStream dos = new DataOutputStream(buf);
        for (int i = 0; i < arr.length; ++i) {
            dos.writeShort(arr[i]);
        }
        dos.flush();
        buf.flush();
        byte[] data = buf.toByteArray();
        dos.close();
        buf.close();
        FileOutputStream fos = new FileOutputStream(path);
        ((OutputStream)fos).write(data);
        ((OutputStream)fos).close();
        ((OutputStream)fos).close();
    }

    public static void saveStringToFile(String data, String path) {
        Logger.log("writing " + data + " to " + path);
        try {
            try {
                Files.createDirectories(Paths.get(path, new String[0]).getParent(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            Files.write(Paths.get(path, new String[0]), data != null ? data.getBytes() : new byte[]{}, new OpenOption[0]);
        }
        catch (Exception ex) {
            Platform.showError("Can't save " + data + " to " + path, ex);
        }
    }

    public static String readStringFromFile(String path) {
        Logger.log("reading string from " + path);
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])));
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.log(ex);
            Platform.showError(ex);
        }
        return null;
    }

    public static DataInputStream fileToDataInputStream(String path) {
        try {
            return new DataInputStream(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static String[] getRoots() {
        return new String[]{FileUtils.getAppStoragePath()};
    }

    public static String getAppStoragePath() {
        return FileUtils.getStoragePath() + '/';
    }

    public static String[] list(String path) throws IOException {
        return new File(path).list();
    }

    public static String[] enumToArray(Enumeration en) {
        Vector tmp = new Vector(5);
        while (en.hasMoreElements()) {
            tmp.addElement(en.nextElement());
        }
        String[] arr = new String[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            arr[i] = (String)tmp.elementAt(i);
        }
        return arr;
    }

    public static void createFolder(String path) throws IOException {
        File f = new File(path);
        f.mkdirs();
    }

    public static void checkFolder(String path) throws IOException {
        path = path + "test.mgstruct";
        FileUtils.saveShortArrayToFile(TESTDATA, path);
        new File(path).delete();
    }

    public static String[] getAllPlaces(String folderName) {
        String[] roots = FileUtils.getRoots();
        String[] paths = new String[roots.length * FOLDERS_ON_EACH_DRIVE.length];
        for (int i = 0; i < roots.length; ++i) {
            Logger.log("Searching for places in " + roots[i]);
            for (int j = 0; j < FOLDERS_ON_EACH_DRIVE.length; ++j) {
                paths[i * FileUtils.FOLDERS_ON_EACH_DRIVE.length + j] = roots[i] + FOLDERS_ON_EACH_DRIVE[j] + folderName + '/';
            }
        }
        return paths;
    }

    public static String getStoragePath() {
        return storagePath;
    }

    public static void setStoragePath(String storagePath) {
        FileUtils.storagePath = storagePath;
    }
}

