/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.platform;

public class Mathh {
    private static final int[] sin_t = new int[]{0, 174, 342, 500, 643, 766, 866, 940, 985, 1000};
    private static final int[] tg_t = new int[]{0, 17, 34, 52, 69, 87, 105, 122, 140, 158, 176, 194, 212, 230, 249, 267, 286, 305, 324, 344, 363, 383, 404, 424, 445, 466, 487, 509, 531, 554, 577, 600, 624, 649, 674, 700, 726, 753, 781, 809, 839, 869, 900, 932, 965, 999, 1035, 1072, 1110, 1150, 1191, 1234, 1279, 1327, 1376, 1428, 1482, 1539, 1600, 1664, 1732, 1804, 1880, 1962, 2050, 2144, 2246, 2355, 2475, 2605, 2747, 2904, 3077, 3270, 3487, 3732, 4010, 4331, 4704, 5144, 5671, 6313, 7115, 8144, 9514, 11430, 14300, 19081, 28636, 57289, Integer.MAX_VALUE};

    private static int sinus(int t) {
        int k = t / 10;
        if (t % 10 == 0) {
            return sin_t[k];
        }
        return (sin_t[k + 1] - sin_t[k]) * (t % 10) / 10 + sin_t[k];
    }

    public static int sin(int t) {
        int sign = 1;
        if ((t %= 360) < 0) {
            t = -t;
            sign = -1;
        }
        if (t <= 90) {
            return sign * Mathh.sinus(t);
        }
        if (t <= 180) {
            return sign * Mathh.sinus(180 - t);
        }
        if (t <= 270) {
            return -sign * Mathh.sinus(t - 180);
        }
        return -sign * Mathh.sinus(360 - t);
    }

    public static int cos(int t) {
        if ((t %= 360) < 0) {
            t = -t;
        }
        if (t <= 90) {
            return Mathh.sinus(90 - t);
        }
        if (t <= 180) {
            return -Mathh.sinus(t - 90);
        }
        if (t <= 270) {
            return -Mathh.sinus(270 - t);
        }
        return Mathh.sinus(t - 270);
    }

    public static int arctg(int x, int y) {
        if (x == 0) {
            if (y > 0) {
                return 90;
            }
            return 270;
        }
        if (y == 0) {
            if (x > 0) {
                return 0;
            }
            return 180;
        }
        int tg = Math.abs(1000 * y / x);
        int ang = Mathh.search(tg_t, tg);
        if (y >= 0) {
            if (x < 0) {
                ang = 180 - ang;
            }
        } else {
            ang = x < 0 ? (ang += 180) : 360 - ang;
        }
        return ang;
    }

    public static int search(int[] nums, int target) {
        int l = 0;
        int r = nums.length - 1;
        int mid = 0;
        while (l <= r) {
            mid = (l + r) / 2;
            if (nums[mid] == target) {
                return mid;
            }
            if (nums[mid] < target) {
                l = mid + 1;
                continue;
            }
            r = mid - 1;
        }
        return mid;
    }

    public static boolean strictIneq(int leftBound, int a, int rightBound) {
        return leftBound < a & a < rightBound;
    }

    public static boolean nonStrictIneq(int leftBound, int a, int rightBound) {
        return leftBound <= a & a <= rightBound;
    }

    public static int constrain(int leftBound, int a, int rightBound) {
        return Math.min(Math.max(leftBound, a), rightBound);
    }

    public static double constrain(double leftBound, double a, double rightBound) {
        return Math.min(Math.max(leftBound, a), rightBound);
    }

    public static boolean isPointOnArc(int a, int startAngle, int arcAngle) {
        if (Math.abs(arcAngle) >= 360) {
            return true;
        }
        if (arcAngle < 0) {
            arcAngle = -arcAngle;
            startAngle = -startAngle;
            a = -a;
        }
        if ((a = Mathh.normalizeAngle(a)) < (startAngle = Mathh.normalizeAngle(startAngle))) {
            a += 360;
        }
        return a >= startAngle && a <= startAngle + arcAngle;
    }

    public static int normalizeAngle(int a) {
        if ((a %= 360) < 0) {
            a += 360;
        }
        return a;
    }

    public static short calcDistance(int dx, int dy) {
        if (dy == 0) {
            return (short)Math.abs(dx);
        }
        if (dx == 0) {
            return (short)Math.abs(dy);
        }
        return (short)Math.sqrt(dx * dx + dy * dy);
    }

    public static int sign(int a) {
        if (a > 0) {
            return 1;
        }
        if (a < 0) {
            return -1;
        }
        return 0;
    }
}

