/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.platform;

import java.awt.Desktop;
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.jar.Manifest;
import mobileapplication3.platform.FileUtils;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.PlatformSettings;

public class Platform {
    private static Frame inst;

    public static void init(Frame instObj) {
        inst = instObj;
        if (PlatformSettings.getFullscreenMode()) {
            inst.getGraphicsConfiguration().getDevice().setFullScreenWindow(Platform.getAppInst());
        }
    }

    public static void showError(String message, Throwable ex) {
        message = message + " " + ex;
        Logger.log(ex);
        Platform.showError(message);
    }

    public static void showError(Throwable ex) {
        Logger.log(ex);
        Platform.showError(ex.toString());
    }

    public static void showError(String message) {
        Logger.log(message);
    }

    public static void vibrate(int ms) {
    }

    public static void storeString(String str, String storageName) {
        FileUtils.saveStringToFile(str, Platform.getStoragePath(storageName));
    }

    public static String readStoreAsString(String storageName) {
        return FileUtils.readStringFromFile(Platform.getStoragePath(storageName));
    }

    public static void storeShorts(short[] data, String storageName) throws IOException {
        FileUtils.saveShortArrayToFile(data, Platform.getStoragePath(storageName));
    }

    public static DataInputStream readStore(String storageName) {
        return FileUtils.fileToDataInputStream(Platform.getStoragePath(storageName));
    }

    public static void clearStore(String storageName) {
        try {
            new File(Platform.getStoragePath(storageName)).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getAppProperty(String key) {
        try {
            return new Manifest(Platform.getResource("/META-INF/MANIFEST.MF")).getMainAttributes().getValue(key);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getAppVersion() {
        return Platform.getAppProperty("Implementation-Version");
    }

    public static boolean platformRequest(String url) {
        try {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(URI.create(url));
            } else {
                Logger.logErr("Desktop.Action.BROWSE is not supported. Could not open " + url);
            }
        }
        catch (IOException ex) {
            Platform.showError(ex);
        }
        return false;
    }

    public static InputStream getResource(String path) {
        return inst.getClass().getResourceAsStream(path);
    }

    private static String getStoragePath(String storageName) {
        return FileUtils.getAppStoragePath() + storageName;
    }

    public static void exit() {
        System.exit(0);
    }

    public static Frame getAppInst() {
        return inst;
    }
}

