/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.platform;

import mobileapplication3.platform.Settings;

public class PlatformSettings {
    private static final int UNDEF = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final String STORE_NAME = "platformsettings";
    private static final String FONT_SIZE = "fontSize";
    private static final String FULLSCREEN_MODE = "fullscreen";
    private static Settings settingsInst = null;
    private static int fontSizeOverride = -1;
    private static int fullscreenModeOverride = -1;

    private PlatformSettings() {
    }

    private static Settings getSettingsInst() {
        if (settingsInst == null) {
            settingsInst = new Settings(new String[]{FONT_SIZE, FULLSCREEN_MODE}, STORE_NAME);
        }
        return settingsInst;
    }

    public static int getFontSize() {
        if (fontSizeOverride == -1) {
            return PlatformSettings.getSettingsInst().getInt(FONT_SIZE, 32);
        }
        return fontSizeOverride;
    }

    public static void setFontSize(int value) {
        PlatformSettings.getSettingsInst().set(FONT_SIZE, String.valueOf(value));
    }

    public static void setFontSizeOverride(int size) {
        fontSizeOverride = size;
    }

    public static boolean getFullscreenMode() {
        if (fullscreenModeOverride == -1) {
            return PlatformSettings.getSettingsInst().getBool(FULLSCREEN_MODE, false);
        }
        return fullscreenModeOverride == 1;
    }

    public static void setFullscreenMode(boolean value) {
        PlatformSettings.getSettingsInst().set(FULLSCREEN_MODE, value);
    }

    public static void setFullscreenModeOverride(boolean value) {
        fullscreenModeOverride = value ? 1 : 0;
    }
}

