/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.platform;

import mobileapplication3.platform.Platform;
import mobileapplication3.platform.Utils;

public class Records {
    private static final String STORE_NAME = "records";
    private static String recordsString = null;

    public static int[] getRecords() {
        if (recordsString == null) {
            recordsString = Platform.readStoreAsString(STORE_NAME);
        }
        if (recordsString == null || recordsString.equals("")) {
            return new int[0];
        }
        String[] valuesStrings = Utils.split(recordsString, " ");
        int[] records = new int[valuesStrings.length];
        for (int i = 0; i < valuesStrings.length; ++i) {
            records[i] = Integer.parseInt(valuesStrings[i]);
        }
        return records;
    }

    public static void saveRecord(int value, int maxStoreSize) {
        Records.insertRecord(value, Records.findIndexToInsertRecord(Records.getRecords(), value), maxStoreSize);
    }

    private static int findIndexToInsertRecord(int[] records, int value) {
        int i;
        for (i = records.length; i > 0; --i) {
            if (value >= records[i - 1]) continue;
            return i;
        }
        return i;
    }

    private static void insertRecord(int value, int i, int maxStoreSize) {
        if (i >= maxStoreSize) {
            return;
        }
        int[] oldRecords = Records.getRecords();
        int[] records = new int[oldRecords.length == maxStoreSize ? oldRecords.length : oldRecords.length + 1];
        System.arraycopy(oldRecords, 0, records, 0, oldRecords.length);
        if (i < records.length) {
            for (int j = records.length - 1; j > i; --j) {
                records[j] = records[j - 1];
            }
        }
        records[i] = value;
        StringBuffer toSave = new StringBuffer();
        for (int j = 0; j < records.length; ++j) {
            int a = records[j];
            toSave.append(a);
            toSave.append(" ");
        }
        recordsString = toSave.toString();
        Platform.storeString(recordsString, STORE_NAME);
    }
}

