/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.platform;

import mobileapplication3.platform.Platform;
import mobileapplication3.platform.Utils;

public class Settings {
    public static final String TRUE = "1";
    public static final String FALSE = "0";
    public static final String UNDEF = "";
    private static final char SEP = '\n';
    private final String storeName;
    private String[] settingsKeysVals;
    private final String[] keys;

    public Settings(String[] keys, String storeName) {
        this.keys = keys;
        this.storeName = "mobapp-settings-" + storeName;
    }

    public void saveToDisk() {
        Platform.storeString(this.getCurrentSettingsAsStr(), this.storeName);
    }

    public void resetSettings() {
        this.loadDefaults();
        this.saveToDisk();
    }

    public void loadDefaults() {
        this.settingsKeysVals = new String[this.keys.length * 2];
        for (int i = 0; i < this.keys.length; ++i) {
            this.settingsKeysVals[i * 2] = this.keys[i];
            this.settingsKeysVals[i * 2 + 1] = UNDEF;
        }
    }

    public void loadFromDisk() {
        this.loadFromString(Platform.readStoreAsString(this.storeName));
    }

    public void loadFromString(String str) {
        this.loadDefaults();
        if (str == null) {
            return;
        }
        String[] keyValueCouples = Utils.split(str.substring(0, str.length() - 1), "\n");
        for (int i = 0; i < keyValueCouples.length; ++i) {
            int splitterIndex = keyValueCouples[i].indexOf(32);
            String key = keyValueCouples[i].substring(0, splitterIndex);
            String value = keyValueCouples[i].substring(splitterIndex + 1);
            for (int j = 0; j < this.settingsKeysVals.length / 2; ++j) {
                if (!key.equals(this.settingsKeysVals[j * 2])) continue;
                this.settingsKeysVals[j * 2 + 1] = value;
            }
        }
    }

    public String getCurrentSettingsAsStr() {
        if (this.settingsKeysVals == null) {
            this.loadFromDisk();
        }
        StringBuffer sb = new StringBuffer(this.settingsKeysVals.length * 5);
        for (int i = 0; i < this.settingsKeysVals.length / 2; ++i) {
            sb.append(this.settingsKeysVals[i * 2]);
            sb.append(" ");
            sb.append(this.settingsKeysVals[i * 2 + 1]);
            sb.append('\n');
        }
        return sb.toString();
    }

    public boolean set(String key, String value) {
        if (this.settingsKeysVals == null) {
            this.loadDefaults();
            this.loadFromDisk();
        }
        for (int i = 0; i < this.settingsKeysVals.length / 2; ++i) {
            if (!this.settingsKeysVals[i * 2].equals(key)) continue;
            if (!this.settingsKeysVals[i * 2 + 1].equals(value)) {
                this.settingsKeysVals[i * 2 + 1] = value;
                this.saveToDisk();
            }
            return true;
        }
        return false;
    }

    public boolean set(String key, boolean value) {
        return this.set(key, value ? TRUE : FALSE);
    }

    public String getStr(String key) {
        if (this.settingsKeysVals == null) {
            this.loadDefaults();
            this.loadFromDisk();
        }
        for (int i = 0; i < this.settingsKeysVals.length / 2; ++i) {
            if (!this.settingsKeysVals[i * 2].equals(key)) continue;
            String value = this.settingsKeysVals[i * 2 + 1];
            if (value.equals(null)) {
                value = UNDEF;
            }
            return value;
        }
        return null;
    }

    public String getStr(String key, String defValue) {
        String value;
        if (this.settingsKeysVals == null) {
            this.loadFromDisk();
        }
        if (UNDEF.equals(value = this.getStr(key))) {
            value = defValue;
            this.set(key, value);
        }
        return value;
    }

    public boolean toggleBool(String key) {
        boolean newValue = !this.getBool(key);
        this.set(key, newValue);
        return newValue;
    }

    public boolean getBool(String key) {
        return TRUE.equals(this.getStr(key));
    }

    public boolean getBool(String key, boolean defaultValue) {
        return TRUE.equals(this.getStr(key, this.toStr(defaultValue)));
    }

    public int getInt(String key, int defaultValue) throws IllegalArgumentException {
        String value = this.getStr(key, String.valueOf(defaultValue));
        this.set(key, String.valueOf(value));
        return Integer.parseInt(value);
    }

    private String toStr(boolean b) {
        return b ? TRUE : FALSE;
    }
}

