/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.platform.ui;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Vector;
import mobileapplication3.platform.PlatformSettings;
import mobileapplication3.platform.ui.IFont;

public class Font
implements IFont {
    private static final int SMALL = PlatformSettings.getFontSize() * 3 / 4;
    private static final int MEDIUM = PlatformSettings.getFontSize();
    private static final int LARGE = PlatformSettings.getFontSize() * 3 / 2;
    private final java.awt.Font font;
    private int size;

    public Font(int face, int style, int size) {
        this(size);
    }

    public Font() {
        this(0);
    }

    public Font(int size) {
        this.size = size;
        switch (size) {
            case 8: {
                size = SMALL;
                break;
            }
            case 0: {
                size = MEDIUM;
                break;
            }
            case 16: {
                size = LARGE;
            }
        }
        this.font = new java.awt.Font(null, 0, size);
    }

    protected Font(java.awt.Font font) {
        this.font = font;
    }

    public java.awt.Font getAwtFont() {
        return this.font;
    }

    public static Font getFont(int face, int style, int size) {
        return new Font(face, style, size);
    }

    public static Font getDefaultFont() {
        return new Font(0);
    }

    public static int defaultFontStringWidth(String str) {
        return Font.getDefaultFont().stringWidth(str);
    }

    public static int defaultFontSubstringWidth(String str, int offset, int len) {
        return Font.getDefaultFont().substringWidth(str, offset, len);
    }

    public static int getDefaultFontHeight() {
        return Font.getDefaultFont().getHeight();
    }

    public static int getDefaultFontSize() {
        return Font.getDefaultFont().getSize();
    }

    @Override
    public int getFace() {
        return 0;
    }

    @Override
    public int getStyle() {
        return 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getHeight() {
        Graphics g = new BufferedImage(100, 100, 12).getGraphics();
        g.setFont(this.font);
        FontMetrics metrics = g.getFontMetrics(this.font);
        return metrics.getHeight();
    }

    @Override
    public int stringWidth(String str) {
        return this.substringWidth(str, 0, str.length());
    }

    @Override
    public int substringWidth(String str, int offset, int len) {
        Graphics g = new BufferedImage(100, 100, 12).getGraphics();
        g.setFont(this.font);
        FontMetrics metrics = g.getFontMetrics(this.font);
        return metrics.stringWidth(str.substring(offset, offset + len));
    }

    @Override
    public int[][] getLineBounds(String text, int w, int padding) {
        Vector<int[]> lineBoundsVector = new Vector<int[]>(text.length() / 5);
        int charOffset = 0;
        if (this.stringWidth(text) <= w - padding * 2 && text.indexOf(10) == -1) {
            lineBoundsVector.addElement(new int[]{0, text.length()});
        } else {
            while (charOffset < text.length()) {
                int maxSymsInCurrLine = 1;
                boolean maxLineLengthReached = false;
                boolean lineBreakSymFound = false;
                for (int lineLength = 1; lineLength <= text.length() - charOffset; ++lineLength) {
                    if (this.substringWidth(text, charOffset, lineLength) > w - padding * 2) {
                        maxLineLengthReached = true;
                        break;
                    }
                    maxSymsInCurrLine = lineLength;
                    if (charOffset + lineLength >= text.length() || text.charAt(charOffset + lineLength) != '\n') continue;
                    lineBoundsVector.addElement(new int[]{charOffset, lineLength});
                    charOffset = charOffset + lineLength + 1;
                    lineBreakSymFound = true;
                    break;
                }
                if (lineBreakSymFound) continue;
                boolean spaceFound = false;
                int maxRightBorder = charOffset + maxSymsInCurrLine;
                if (maxRightBorder >= text.length()) {
                    lineBoundsVector.addElement(new int[]{charOffset, maxSymsInCurrLine});
                    break;
                }
                if (!maxLineLengthReached) {
                    lineBoundsVector.addElement(new int[]{charOffset, maxSymsInCurrLine});
                    charOffset = maxRightBorder;
                    continue;
                }
                for (int i = maxRightBorder; i > charOffset; --i) {
                    if (text.charAt(i) != ' ') continue;
                    lineBoundsVector.addElement(new int[]{charOffset, i - charOffset});
                    charOffset = i + 1;
                    spaceFound = true;
                    break;
                }
                if (spaceFound) continue;
                lineBoundsVector.addElement(new int[]{charOffset, maxRightBorder - charOffset});
                charOffset = maxRightBorder;
            }
        }
        int[][] lineBounds = new int[lineBoundsVector.size()][];
        for (int i = 0; i < lineBoundsVector.size(); ++i) {
            lineBounds[i] = (int[])lineBoundsVector.elementAt(i);
        }
        return lineBounds;
    }
}

