/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.platform.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.IGraphics;
import mobileapplication3.platform.ui.Image;
import mobileapplication3.platform.ui.RootContainer;

public final class Graphics
implements IGraphics {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    private Font currentFont = Font.getDefaultFont();
    private Graphics2D g;

    public Graphics(java.awt.Graphics g) {
        if (g == null) {
            throw new NullPointerException();
        }
        this.g = (Graphics2D)g;
        this.setFont(this.currentFont);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc(x, y, width, height, startAngle, arcAngle, 1, 1000, false, false, false);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle, int thickness, int zoomOut, boolean drawThickness, boolean zoomThickness, boolean rounding) {
        if (drawThickness) {
            if (zoomOut < 0) {
                zoomOut = -zoomOut;
            }
            this.g.setStroke(new BasicStroke((float)thickness * (zoomThickness ? 1000.0f / (float)zoomOut : 1.0f), rounding ? 1 : 0, 1));
        } else {
            this.g.setStroke(new BasicStroke(1.0f));
        }
        this.g.drawArc(x, y, width, height, -startAngle, -arcAngle);
    }

    @Override
    public void drawImage(Image img, int x, int y, int anchor) {
        if (img == null || img.getImage() == null) {
            throw new NullPointerException("Can't draw null image");
        }
        int w = img.getWidth();
        int h = img.getHeight();
        if ((anchor & 1) != 0) {
            x -= w / 2;
        } else if ((anchor & 8) != 0) {
            x -= w;
        }
        if ((anchor & 2) != 0) {
            y -= h / 2;
        } else if ((anchor & 0x20) != 0) {
            y -= h;
        }
        this.g.drawImage((java.awt.Image)img.getImage(), x, y, null);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.setStroke(new BasicStroke());
        this.g.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.g.drawRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawString(String str, int x, int y, int anchor) {
        this.drawSubstring(str, 0, str.length(), x, y, anchor);
    }

    @Override
    public void drawSubstring(String str, int offset, int len, int x, int y, int anchor) {
        int w = this.substringWidth(str, offset, len);
        int h = this.getFontHeight();
        FontMetrics metrics = this.g.getFontMetrics(this.g.getFont());
        if ((anchor & 1) != 0) {
            x -= w / 2;
        } else if ((anchor & 8) != 0) {
            x -= w;
        }
        if ((anchor & 2) != 0) {
            y -= h / 2;
        } else if ((anchor & 0x20) != 0) {
            y -= h;
        }
        this.g.drawString(str.substring(offset, offset + len), x, y + metrics.getAscent());
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.fillArc(x, y, width, height, -startAngle, -arcAngle);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(x, y, width, height);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.g.fillPolygon(new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.g.setClip(x, y, width, height);
    }

    @Override
    public void setColor(int RGB) {
        this.g.setColor(new Color(RGB));
    }

    @Override
    public void setColor(int red, int green, int blue) {
        this.g.setColor(new Color(red, green, blue));
    }

    @Override
    public void setFont(int face, int style, int size) {
        this.setFont(new Font(face, style, size));
    }

    @Override
    public Font getFont() {
        return this.currentFont;
    }

    @Override
    public void setFont(Font font) {
        this.currentFont = font;
        this.g.setFont(this.currentFont.getAwtFont());
    }

    @Override
    public int getFontFace() {
        return this.currentFont.getFace();
    }

    @Override
    public int getFontStyle() {
        return this.currentFont.getStyle();
    }

    @Override
    public int getFontSize() {
        return this.currentFont.getSize();
    }

    @Override
    public void setFontSize(int size) {
        this.currentFont = new Font(size);
    }

    @Override
    public int getFontHeight() {
        return this.currentFont.getHeight();
    }

    @Override
    public int stringWidth(String str) {
        return this.currentFont.stringWidth(str);
    }

    @Override
    public int substringWidth(String str, int offset, int len) {
        return this.currentFont.substringWidth(str, offset, len);
    }

    @Override
    public int getFontHeight(int face, int style, int size) {
        return this.currentFont.getHeight();
    }

    @Override
    public int getClipWidth() {
        try {
            return this.g.getClipBounds().width;
        }
        catch (NullPointerException ex) {
            return RootContainer.getInst().w;
        }
    }

    @Override
    public int getClipHeight() {
        try {
            return this.g.getClipBounds().height;
        }
        catch (NullPointerException ex) {
            return RootContainer.getInst().h;
        }
    }

    @Override
    public int getClipX() {
        try {
            return this.g.getClipBounds().x;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    @Override
    public int getClipY() {
        try {
            return this.g.getClipBounds().y;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    @Override
    public int getColor() {
        return this.g.getColor().getRGB();
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, int thickness, int zoomOut, boolean drawThickness) {
        this.drawLine(x1, y1, x2, y2, thickness, zoomOut, drawThickness, true);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, int thickness, int zoomOut, boolean drawThickness, boolean zoomThickness) {
        this.drawLine(x1, y1, x2, y2, thickness, zoomOut, drawThickness, zoomThickness, true, false);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, int thickness, int zoomOut, boolean drawThickness, boolean zoomThickness, boolean rounding, boolean markSkeleton) {
        if (drawThickness) {
            if (zoomOut < 0) {
                zoomOut = -zoomOut;
            }
            this.g.setStroke(new BasicStroke((float)thickness * (zoomThickness ? 1000.0f / (float)zoomOut : 1.0f), rounding ? 1 : 0, 1));
        } else {
            this.g.setStroke(new BasicStroke(1.0f));
        }
        this.g.drawLine(x1, y1, x2, y2);
        if (markSkeleton && drawThickness && thickness * 1000 / zoomOut > 8) {
            int prevCol = this.getColor();
            this.setColor(0xFF0000);
            this.g.setStroke(new BasicStroke());
            this.g.drawLine(x1, y1, x2, y2);
            this.setColor(prevCol);
        }
    }

    @Override
    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, boolean fill) {
        if (!fill) {
            this.g.drawLine(x1, y1, x2, y2);
            this.g.drawLine(x2, y2, x3, y3);
            this.g.drawLine(x1, y1, x3, y3);
        } else {
            this.fillTriangle(x1, y1, x2, y2, x3, y3);
        }
    }

    @Override
    public void drawArrow(int x1, int y1, int x2, int y2, int thickness, int zoomOut, boolean drawThickness) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int arrowX = (x2 * 5 + x1) / 6;
        int arrowY = (y2 * 5 + y1) / 6;
        int arrowSideVecX = dy / 8;
        int arrowSideVecY = -dx / 8;
        this.drawLine(x1, y1, arrowX, arrowY, thickness, zoomOut, drawThickness, true, false, false);
        this.drawTriangle(x2, y2, arrowX + arrowSideVecX, arrowY + arrowSideVecY, arrowX - arrowSideVecX, arrowY - arrowSideVecY, drawThickness);
    }
}

