/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.platform.ui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.IImage;

public class Image
implements IImage {
    private BufferedImage image;

    public Image(BufferedImage image) {
        if (image == null) {
            Logger.log("got null image");
        }
        this.image = image;
    }

    public static Image createImage(int width, int height) {
        return new Image(new BufferedImage(width, height, 8));
    }

    public static Image createRGBImage(int[] rgb, int width, int height, boolean processAlpha) {
        BufferedImage image = new BufferedImage(width, height, processAlpha ? 2 : 8);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image.setRGB(x, y, rgb[y * width + x]);
            }
        }
        return new Image(image);
    }

    public static Image createImage(String source) throws IOException {
        try {
            Logger.log("reading resourse \"" + source + "\"");
            return new Image(ImageIO.read(Platform.getResource(source)));
        }
        catch (IOException | IllegalArgumentException | NullPointerException ex) {
            Logger.log(ex);
            throw new IOException("can't read image");
        }
    }

    public static void blurImg(Image img) {
        try {
            Graphics g = img.getGraphics();
            int x0 = 0;
            int y0 = 0;
            int w = img.getWidth();
            int h = img.getHeight();
            int x1 = 0;
            int y1 = 0;
            int x2 = 0;
            int y2 = 0;
            int a = 3;
            int offset = new Random().nextInt(a);
            x0 += offset;
            for (int i = -offset; i < (w + h) / a; ++i) {
                g.setColor(0x110033);
                g.drawLine(x1 + x0, y1 + y0, x2 + x0, y2 + y0);
                g.drawLine(x1 + x0, h - (y1 + y0), x2 + x0, h - (y2 + y0));
                if (y1 < h) {
                    y1 += a;
                } else {
                    x1 += a;
                }
                if (x2 < w) {
                    x2 += a;
                    continue;
                }
                y2 += a;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Graphics getGraphics() {
        return new Graphics(this.image.getGraphics());
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public void getRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height) {
        if (this.image != null) {
            this.image.getRGB(0, 0, this.getWidth(), this.getHeight(), rgbData, 0, this.getWidth());
        }
    }

    @Override
    public Image scale(int newWidth, int newHeight) {
        if (this.image == null) {
            return null;
        }
        int[] rawInput = new int[this.image.getHeight() * this.image.getWidth()];
        this.getRGB(rawInput, 0, this.image.getWidth(), 0, 0, this.image.getWidth(), this.image.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int YD = this.image.getHeight() / newHeight * this.image.getWidth() - this.image.getWidth();
        int YR = this.image.getHeight() % newHeight;
        int XD = this.image.getWidth() / newWidth;
        int XR = this.image.getWidth() % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int YE = 0;
        for (int y = newHeight; y > 0; --y) {
            int XE = 0;
            for (int x = newWidth; x > 0; --x) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += XD;
                if ((XE += XR) < newWidth) continue;
                XE -= newWidth;
                ++inOffset;
            }
            inOffset += YD;
            if ((YE += YR) < newHeight) continue;
            YE -= newHeight;
            inOffset += this.image.getWidth();
        }
        return Image.createRGBImage(rawOutput, newWidth, newHeight, true);
    }

    @Override
    public void blur() {
        Image.blurImg(this);
    }
}

