/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.platform.ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferStrategy;
import java.util.HashSet;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.IContainer;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.UISettings;

public class RootContainer
extends Canvas
implements IContainer,
IPopupFeedback,
KeyListener {
    private final Toolkit toolkit = Toolkit.getDefaultToolkit();
    private java.awt.Graphics g = null;
    private BufferStrategy bufferStrategy = null;
    private IUIComponent rootUIComponent = null;
    private final KeyboardHelper kbHelper;
    public static boolean displayKbHints = false;
    public static boolean enableOnScreenLog = false;
    public int w;
    public int h;
    private static RootContainer inst = null;
    private UISettings uiSettings;
    private static Thread repaintThread = null;
    private boolean wasDownEvent = false;
    private boolean wasDragged = false;
    private int lastPointerX;
    private int lastPointerY;
    private int pressedX;
    private int pressedY;
    private long pressedTime;
    private final HashSet<Integer> pressedKeys = new HashSet();
    private boolean rootUIComponentPostInitDone = false;

    public RootContainer() {
        inst = this;
        this.kbHelper = new KeyboardHelper();
        displayKbHints = false;
        this.setFocusable(true);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RootContainer.this.pressedX = e.getX();
                RootContainer.this.pressedY = e.getY();
                RootContainer.this.pressedTime = System.currentTimeMillis();
                int event = e.getButton() == 1 ? 1 : (e.getButton() == 2 ? 2 : 3);
                if (!RootContainer.this.mouseEvent(event, RootContainer.this.pressedX, RootContainer.this.pressedY)) {
                    RootContainer.this.pointerPressed(RootContainer.this.pressedX, RootContainer.this.pressedY);
                }
                RootContainer.this.wasDownEvent = true;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int event = e.getButton() == 1 ? 4 : (e.getButton() == 2 ? 5 : 6);
                if (!RootContainer.this.mouseEvent(event, e.getX(), e.getY())) {
                    RootContainer.this.pointerDragged(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int releasedX = e.getX();
                int releasedY = e.getY();
                int event = e.getButton() == 1 ? -1 : (e.getButton() == 3 ? -2 : -3);
                if (!RootContainer.this.mouseEvent(event, releasedX, releasedY)) {
                    if (!RootContainer.this.wasDragged && System.currentTimeMillis() - RootContainer.this.pressedTime < 1000L) {
                        RootContainer.this.pointerClicked(releasedX, releasedY);
                    }
                    RootContainer.this.pointerReleased(releasedX, releasedY);
                }
                RootContainer.this.wasDownEvent = false;
                RootContainer.this.wasDragged = false;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                RootContainer.this.mouseEvent(e.getWheelRotation() > 0 ? 7 : -7, e.getX(), e.getY());
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
        this.addKeyListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RootContainer.this.onSizeChanged(RootContainer.this.getWidth(), RootContainer.this.getHeight(), RootContainer.this.w, RootContainer.this.h);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                RootContainer.this.onHide();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                RootContainer.this.onShow();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.onShow();
        this.createBufferStrategy(3);
    }

    public static RootContainer getInst() {
        if (inst == null) {
            inst = new RootContainer();
        }
        return inst;
    }

    public static void init() {
        boolean bl = enableOnScreenLog = RootContainer.inst.uiSettings == null || RootContainer.inst.uiSettings.enableOnScreenLog();
        if (enableOnScreenLog) {
            if (RootContainer.inst.h > 0) {
                Logger.enableOnScreenLog(RootContainer.inst.h);
            }
        } else {
            Logger.disableOnScreenLog();
        }
        if (RootContainer.inst.rootUIComponent != null) {
            RootContainer.inst.rootUIComponent.init();
        }
    }

    public static RootContainer setUISettings(UISettings uiSettings) {
        RootContainer.getInst().uiSettings = uiSettings;
        if (uiSettings != null) {
            uiSettings.onChange();
        }
        return inst;
    }

    public static RootContainer setRootUIComponent(IUIComponent rootUIComponent) {
        RootContainer.inst.wasDownEvent = false;
        if (RootContainer.inst.rootUIComponent != null) {
            RootContainer.inst.rootUIComponent.setVisible(false);
            RootContainer.inst.rootUIComponent.setFocused(false);
        }
        if (rootUIComponent != null) {
            RootContainer.inst.rootUIComponent = rootUIComponent.setParent(inst).setVisible(true);
            RootContainer.inst.rootUIComponentPostInitDone = false;
            rootUIComponent.init();
            if (inst.getWidth() > 0 && inst.getHeight() > 0) {
                rootUIComponent.setSize(inst.getWidth(), inst.getHeight());
                rootUIComponent.postInit();
                rootUIComponent.setFocused(true);
                RootContainer.inst.rootUIComponentPostInitDone = true;
            }
            if (!rootUIComponent.repaintOnlyOnFlushGraphics() && repaintThread == null) {
                repaintThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (!inst.rootUIComponent.repaintOnlyOnFlushGraphics()) {
                            try {
                                Thread.yield();
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            inst.repaint();
                        }
                        repaintThread = null;
                    }
                });
                repaintThread.start();
            }
        } else {
            try {
                throw new Exception("setRootUIComponent(): got null");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return inst;
    }

    @Override
    public UISettings getUISettings() {
        return this.uiSettings;
    }

    @Override
    public boolean isOnScreen() {
        return true;
    }

    public static RootContainer setUiSettings(UISettings uiSettings) {
        RootContainer.getInst().uiSettings = uiSettings;
        return RootContainer.getInst();
    }

    @Override
    public synchronized void repaint() {
        if (this.rootUIComponent != null && !this.rootUIComponent.repaintOnlyOnFlushGraphics()) {
            this.paint();
        }
    }

    protected synchronized void paint() {
        Graphics g = this.getUGraphics();
        if (g == null) {
            Logger.log("got null Graphics, skipping paint");
            return;
        }
        if (this.rootUIComponent != null) {
            this.rootUIComponent.paint(g);
        } else {
            g.setColor(0xAAAAAA);
            g.drawString("Nothing to draw. " + this.rootUIComponent, this.w / 2, this.h, 33);
        }
        Logger.paint(g);
        this.flushGraphics();
    }

    @Override
    public void paint(java.awt.Graphics g) {
    }

    @Override
    public synchronized Graphics getUGraphics() {
        this.bufferStrategy = this.getBufferStrategy();
        this.g = this.bufferStrategy.getDrawGraphics();
        if (this.g == null) {
            return null;
        }
        this.g.clearRect(0, 0, this.getWidth(), this.getHeight());
        return new Graphics(this.g);
    }

    @Override
    public synchronized void flushGraphics() {
        if (this.g != null) {
            Logger.paint(new Graphics(this.g));
        }
        if (this.bufferStrategy != null) {
            this.bufferStrategy.show();
        }
        if (this.g != null) {
            this.g.dispose();
        }
        this.toolkit.sync();
    }

    public int getBgColor() {
        return this.getBackground().getRGB();
    }

    public void setBgColor(int bgColor) {
        this.setBackground(new Color(bgColor));
    }

    public static int getAction(int keyCode) {
        switch (keyCode) {
            case -1: 
            case 50: {
                return 1;
            }
            case -2: 
            case 56: {
                return 6;
            }
            case -3: 
            case 52: {
                return 2;
            }
            case -4: 
            case 54: {
                return 5;
            }
            case -5: 
            case 53: {
                return 8;
            }
            case 49: {
                return 9;
            }
            case 51: {
                return 10;
            }
            case 55: {
                return 11;
            }
            case 57: {
                return 12;
            }
        }
        return keyCode;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.pressedKeys.add(keyCode)) {
            keyCode = this.convertKeyCode(keyCode);
            this.kbHelper.keyPressed(keyCode);
            this.wasDownEvent = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.pressedKeys.contains(keyCode)) {
            this.pressedKeys.remove(keyCode);
        }
        keyCode = this.convertKeyCode(keyCode);
        this.kbHelper.keyReleased(keyCode);
    }

    private void handleKeyPressed(int keyCode, int count) {
        if (this.rootUIComponent != null) {
            this.rootUIComponent.setVisible(true);
            if (this.rootUIComponent.keyPressed(keyCode, count)) {
                if (!displayKbHints) {
                    displayKbHints = true;
                    if (this.uiSettings != null) {
                        this.uiSettings.onChange();
                    }
                }
                this.repaint();
            }
        }
    }

    private void handleKeyReleased(int keyCode, int count) {
        if (this.rootUIComponent != null && this.wasDownEvent) {
            this.rootUIComponent.setVisible(true);
            if (this.rootUIComponent.keyReleased(keyCode, count)) {
                this.repaint();
            }
        }
        this.wasDownEvent = false;
    }

    protected void handleKeyRepeated(int keyCode, int pressedCount) {
        if (RootContainer.getAction(keyCode) == 8) {
            return;
        }
        if (this.rootUIComponent != null && this.wasDownEvent && this.rootUIComponent.keyRepeated(keyCode, pressedCount)) {
            this.repaint();
        }
    }

    protected boolean mouseEvent(int event, int x, int y) {
        if (this.rootUIComponent != null) {
            this.rootUIComponent.setVisible(true);
            if (this.rootUIComponent.mouseEvent(event, x, y)) {
                this.repaint();
                return true;
            }
        }
        return false;
    }

    protected void pointerPressed(int x, int y) {
        this.lastPointerX = x;
        this.lastPointerY = y;
        if (this.rootUIComponent != null) {
            this.rootUIComponent.setVisible(true);
            if (this.rootUIComponent.pointerPressed(x, y)) {
                this.repaint();
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        int d;
        if (this.lastPointerX == x && this.lastPointerY == y) {
            return;
        }
        this.lastPointerX = x;
        this.lastPointerY = y;
        if (this.rootUIComponent != null && this.wasDownEvent && this.rootUIComponent.pointerDragged(x, y)) {
            this.repaint();
        }
        if (!this.wasDragged && (d = Math.abs(x - this.pressedX) + Math.abs(y - this.pressedY)) > 4) {
            this.wasDragged = true;
        }
    }

    protected void pointerReleased(int x, int y) {
        if (this.rootUIComponent != null && this.wasDownEvent && this.rootUIComponent.pointerReleased(x, y)) {
            this.repaint();
        }
    }

    protected void pointerClicked(int x, int y) {
        if (this.rootUIComponent != null && this.wasDownEvent && this.rootUIComponent.pointerClicked(x, y)) {
            this.repaint();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (w <= 0 || h <= 0) {
            return;
        }
        this.w = w;
        this.h = h;
        if (enableOnScreenLog) {
            Logger.enableOnScreenLog(h);
        }
        if (this.rootUIComponent != null) {
            this.rootUIComponent.setSize(w, h);
            if (!this.rootUIComponentPostInitDone) {
                this.rootUIComponent.postInit();
                this.rootUIComponent.setFocused(true);
                this.rootUIComponentPostInitDone = true;
            }
            this.repaint();
        }
    }

    protected void onShow() {
        this.kbHelper.show();
        if (this.rootUIComponent != null) {
            this.rootUIComponent.setVisible(true);
            this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
            this.rootUIComponent.onShow();
        }
        this.repaint();
    }

    protected void onHide() {
        this.kbHelper.hide();
        if (this.rootUIComponent != null) {
            this.rootUIComponent.onHide();
            this.rootUIComponent.setVisible(false);
        }
    }

    private int convertKeyCode(int javaSEKeyCode) {
        switch (javaSEKeyCode) {
            case 10: 
            case 32: {
                return 8;
            }
            case 38: 
            case 224: {
                return 1;
            }
            case 40: 
            case 225: {
                return 6;
            }
            case 37: 
            case 226: {
                return 2;
            }
            case 39: 
            case 227: {
                return 5;
            }
            case 45: 
            case 112: {
                return -6;
            }
            case 27: 
            case 61: 
            case 113: 
            case 521: {
                return -7;
            }
            case 48: 
            case 96: {
                return 48;
            }
            case 49: 
            case 97: {
                return 49;
            }
            case 50: 
            case 98: {
                return 50;
            }
            case 51: 
            case 99: {
                return 51;
            }
            case 52: 
            case 100: {
                return 52;
            }
            case 53: 
            case 101: {
                return 53;
            }
            case 54: 
            case 102: {
                return 54;
            }
            case 55: 
            case 82: 
            case 103: {
                return 55;
            }
            case 56: 
            case 104: {
                return 56;
            }
            case 57: 
            case 105: {
                return 57;
            }
            case 36: 
            case 106: 
            case 114: {
                return 42;
            }
            case 35: 
            case 111: 
            case 115: {
                return 35;
            }
        }
        return 0;
    }

    @Override
    public void closePopup() {
        Platform.exit();
    }

    private class KeyboardHelper {
        private Object tillPressed = new Object();
        private int lastKey;
        private int pressCount;
        private boolean pressState;
        private Thread repeatThread;
        private long lastEvent;

        private KeyboardHelper() {
        }

        public void show() {
            this.pressState = false;
            this.pressCount = 1;
            this.lastKey = 0;
            this.repeatThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            if (!KeyboardHelper.this.pressState) {
                                Object object = KeyboardHelper.this.tillPressed;
                                synchronized (object) {
                                    KeyboardHelper.this.tillPressed.wait();
                                }
                            }
                            try {
                                Thread.sleep(500L);
                                while (true) {
                                    RootContainer.this.handleKeyRepeated(KeyboardHelper.this.lastKey, KeyboardHelper.this.pressCount);
                                    Thread.sleep(150L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            };
            this.repeatThread.start();
        }

        public void hide() {
            if (this.repeatThread != null) {
                this.repeatThread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(int k) {
            this.pressCount = !this.isLastEventOld() && k == this.lastKey ? ++this.pressCount : 1;
            this.updateLastEventTime();
            this.lastKey = k;
            this.pressState = true;
            Object object = this.tillPressed;
            synchronized (object) {
                this.tillPressed.notify();
            }
            RootContainer.this.handleKeyPressed(k, this.pressCount);
        }

        public void keyReleased(int k) {
            this.updateLastEventTime();
            if (this.lastKey == k) {
                this.pressState = false;
            } else {
                this.pressCount = 0;
            }
            this.repeatThread.interrupt();
            RootContainer.this.handleKeyReleased(k, this.pressCount);
        }

        private boolean isLastEventOld() {
            return System.currentTimeMillis() - this.lastEvent > 200L;
        }

        private void updateLastEventTime() {
            this.lastEvent = System.currentTimeMillis();
        }
    }
}

