/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.ui.Button;
import mobileapplication3.ui.UIComponent;

public abstract class AbstractButtonSet
extends UIComponent {
    public static final int W_AUTO = -1;
    public static final int H_AUTO = -1;
    public Button[] buttons = null;
    protected int bgColor = -1;
    protected int buttonsBgColor = -2;
    protected int buttonsBgColorInactive = -2;
    protected int buttonsSelectedColor = -2;
    protected int buttonsBgPadding = 0;
    protected int selected = 0;
    protected int prevSelected = 0;
    protected boolean isSelectionEnabled = false;
    protected boolean isSelectionVisible = false;
    protected boolean ignoreKeyRepeated = true;
    protected boolean showKbHints;

    @Override
    public void init() {
        try {
            this.ignoreKeyRepeated = !this.getUISettings().getKeyRepeatedInListsEnabled();
            this.showKbHints = this.getUISettings().showKbHints();
            this.isSelectionVisible = this.isSelectionVisible || this.showKbHints;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AbstractButtonSet setButtons(Button[] buttons) {
        this.buttons = buttons;
        this.setButtonsBgColor(this.buttonsBgColor);
        this.setButtonsBgColorInactive(this.buttonsBgColorInactive);
        this.setSelectedColor(this.buttonsSelectedColor);
        this.setButtonsBgPadding(this.buttonsBgPadding);
        this.setIsSelectionEnabled(this.isSelectionEnabled);
        this.setIsSelectionVisible(this.isSelectionVisible);
        if (this.isSizeSet()) {
            this.recalcSize();
        }
        return this;
    }

    public AbstractButtonSet setButtonsBgColor(int color) {
        if (color == -2) {
            return this;
        }
        this.buttonsBgColor = color;
        if (this.buttons == null) {
            return this;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setBgColor(color);
        }
        return this;
    }

    public AbstractButtonSet setButtonsBgColorInactive(int color) {
        if (color == -2) {
            return this;
        }
        this.buttonsBgColorInactive = color;
        if (this.buttons == null) {
            return this;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setBgColorInactive(color);
        }
        return this;
    }

    public AbstractButtonSet setSelectedColor(int color) {
        if (color == -2) {
            return this;
        }
        this.buttonsSelectedColor = color;
        if (this.buttons == null) {
            return this;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setSelectedColor(color);
        }
        return this;
    }

    public AbstractButtonSet setButtonsBgPadding(int padding) {
        this.buttonsBgPadding = padding;
        if (this.buttons == null) {
            return this;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setBgPadding(padding);
        }
        return this;
    }

    public AbstractButtonSet setIsSelectionEnabled(boolean selectionEnabled) {
        this.isSelectionEnabled = selectionEnabled;
        return this;
    }

    public AbstractButtonSet setIsSelectionVisible(boolean isSelectionVisible) {
        this.isSelectionVisible = isSelectionVisible;
        return this;
    }

    public AbstractButtonSet setSelected(int selected) {
        this.selected = selected;
        return this;
    }

    public int getSelected() {
        return this.selected;
    }

    public int getButtonCount() {
        if (this.buttons != null) {
            return this.buttons.length;
        }
        return 0;
    }

    @Override
    public boolean canBeFocused() {
        if (this.buttons == null || !this.isSelectionEnabled) {
            return false;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] == null || !this.buttons[i].isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleKeyRepeated(int keyCode, int pressedCount) {
        if (this.ignoreKeyRepeated) {
            return this.isSelectionEnabled && this.isFocused && this.isVisible;
        }
        return this.onKeyPressed(keyCode, pressedCount);
    }

    @Override
    protected final boolean handleKeyPressed(int keyCode, int count) {
        if (this.handleBindsOnKeyPressed(keyCode)) {
            return true;
        }
        if (this.onKeyPressed(keyCode, count)) {
            return true;
        }
        return this.isFocused;
    }

    protected boolean onKeyPressed(int keyCode, int count) {
        return false;
    }

    protected boolean handleBindsOnKeyPressed(int keyCode) {
        for (int i = 0; i < this.buttons.length; ++i) {
            int[] binds;
            Button button = this.buttons[i];
            if (!button.isActive() || (binds = button.getBindedKeyCodes()) == null) continue;
            for (int j = 0; j < binds.length; ++j) {
                if (keyCode != binds[j]) continue;
                button.buttonPressed();
                return true;
            }
        }
        return false;
    }

    public abstract int getMinPossibleWidth();
}

