/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.Mathh;

public class AnimationThread
implements Runnable {
    public static final int FPS = 20;
    public static final int FRAME_MILLIS = 50;
    public static final int FP_MATH_MULTIPLIER = 1000;
    private Thread thread = null;
    private AnimationWorker feedback;
    private boolean isRunning = false;
    private int framesCount;
    private int frameTime;
    private int x;
    private int y;
    private int targetX;
    private int targetY;
    private int leftLimitX;
    private int rightLimitX;
    private int topLimitY;
    private int bottomLimitY;
    private int vX = 0;
    private int vY = 0;
    private int aX;
    private int aY;

    public AnimationThread(AnimationWorker feedback) {
        this.feedback = feedback;
    }

    public void animate(int currX, int currY, int targetX, int targetY, int durationMillis, int leftLimitX, int rightLimitX, int topLimitY, int bottomLimitY) {
        this.animate(currX, currY, targetX, targetY, durationMillis, leftLimitX, rightLimitX, topLimitY, bottomLimitY, 50);
    }

    public void animate(int currX, int currY, int targetX, int targetY, int durationMillis, int leftLimitX, int rightLimitX, int topLimitY, int bottomLimitY, int frameTime) {
        if (currY == targetY && currX == targetX) {
            return;
        }
        this.frameTime = Math.max(frameTime, 5);
        this.leftLimitX = leftLimitX * 1000;
        this.rightLimitX = rightLimitX * 1000;
        this.topLimitY = topLimitY * 1000;
        this.bottomLimitY = bottomLimitY * 1000;
        this.x = currX * 1000;
        this.y = currY * 1000;
        this.targetX = targetX * 1000;
        this.targetY = targetY * 1000;
        this.framesCount = durationMillis / frameTime;
        if (this.framesCount == 0) {
            this.onStep(this.targetX, this.targetY);
            return;
        }
        int sX = this.targetX - this.x;
        int sY = this.targetY - this.y;
        this.vX = 2 * sX / this.framesCount;
        this.vY = 2 * sY / this.framesCount;
        this.aX = 2 * sX / (this.framesCount * this.framesCount);
        this.aY = 2 * sY / (this.framesCount * this.framesCount);
        int vX = this.vX;
        int vY = this.vY;
        int x = this.x;
        int y = this.y;
        for (int i = 0; i < this.framesCount; ++i) {
            x += (vX -= this.aX);
            y += (vY -= this.aY);
        }
        this.x += this.targetX - x;
        this.y += this.targetY - y;
        this.targetX = Mathh.constrain(this.leftLimitX, this.targetX, this.rightLimitX);
        this.targetY = Mathh.constrain(this.topLimitY, this.targetY, this.bottomLimitY);
        if (!this.isRunning) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @Override
    public void run() {
        this.isRunning = true;
        try {
            for (int i = 0; i < this.framesCount; ++i) {
                long iterationStartMillis = System.currentTimeMillis();
                this.vX -= this.aX;
                this.vY -= this.aY;
                this.x += this.vX;
                this.y += this.vY;
                this.onStep(this.x, this.y);
                if (!Mathh.nonStrictIneq(this.leftLimitX, this.x, this.rightLimitX) || !Mathh.nonStrictIneq(this.topLimitY, this.y, this.bottomLimitY)) break;
                Thread.sleep(Math.max(0L, (long)this.frameTime - (System.currentTimeMillis() - iterationStartMillis)));
            }
            this.onStep(this.targetX, this.targetY);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.isRunning = false;
    }

    private void onStep(int xFP, int yFP) {
        xFP = Mathh.constrain(this.leftLimitX, xFP, this.rightLimitX);
        yFP = Mathh.constrain(this.topLimitY, yFP, this.bottomLimitY);
        this.feedback.onStep(xFP / 1000, yFP / 1000);
    }

    public static interface AnimationWorker {
        public void onStep(int var1, int var2);
    }
}

