/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.Utils;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Keys;

public abstract class Button {
    private String text;
    private String kbHint = "";
    private boolean isActive = true;
    protected int bgColor;
    protected int bgColorInactive;
    protected int fontColor;
    protected int fontColorInactive;
    protected int selectedBgColor;
    private int bgPadding;
    private int[][] lineBounds = null;
    private int prevW;
    public Font font;
    private Font prevGetLineBoundsFont;
    private boolean wasKbHintVisible = false;
    private int[] bindedKeyCodes = null;

    public Button(String title) {
        this.setFont(Font.getDefaultFontSize());
        this.bgPadding = 0;
        this.selectedBgColor = 13173;
        this.fontColorInactive = 0x404040;
        this.fontColor = 0xFFFFFF;
        this.bgColorInactive = 0x202025;
        this.bgColor = 0x101020;
        this.text = title;
        this.setTitle(this.getTitle());
    }

    public boolean invokePressed(boolean isSelected, boolean isFocused) {
        if (this.isActive) {
            if (!isSelected) {
                this.buttonPressed();
            } else {
                this.buttonPressedSelected();
            }
            this.setTitle(this.getTitle());
            return true;
        }
        return false;
    }

    protected void setFont(int size, Graphics g) {
        this.setFont(size);
        g.setFont(this.font);
    }

    public void setFont(int size) {
        this.font = new Font(size);
    }

    public Button setIsActive(boolean b) {
        this.isActive = b;
        return this;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Button setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public Button setFontColorInactive(int fontColorInactive) {
        this.fontColorInactive = fontColorInactive;
        return this;
    }

    public int getFontColorInactive() {
        return this.fontColorInactive;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public Button setBgColor(int bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public int getBgColorInactive() {
        return this.bgColorInactive;
    }

    public Button setBgColorInactive(int bgColorInactive) {
        this.bgColorInactive = bgColorInactive;
        return this;
    }

    public int getSelectedColor() {
        return this.selectedBgColor;
    }

    public Button setSelectedColor(int selectedColor) {
        this.selectedBgColor = selectedColor;
        return this;
    }

    public int getBgPagging() {
        return this.bgPadding;
    }

    public Button setBgPadding(int bgPadding) {
        this.bgPadding = bgPadding;
        return this;
    }

    public void setTitle(String s) {
        if (s == null) {
            s = "<null>";
        }
        this.text = s;
    }

    public String getTitle() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    private void setKbHint(String s) {
        if (s == null) {
            s = "";
        }
        this.kbHint = s;
    }

    public Button setBindedKeyCode(int keyCode) {
        return this.setBindedKeyCodes(new int[]{keyCode});
    }

    public Button setBindedKeyCodes(int[] keyCodes) {
        if (keyCodes == null || keyCodes.length == 0) {
            this.resetKeyBinds();
            return this;
        }
        this.bindedKeyCodes = keyCodes;
        StringBuffer hintStringBuffer = new StringBuffer();
        for (int i = 0; i < keyCodes.length; ++i) {
            int keyCode = keyCodes[i];
            if (keyCode == -6 || keyCode == -7) continue;
            hintStringBuffer.append(",").append(Keys.getButtonName(keyCode));
        }
        String hint = hintStringBuffer.toString();
        if (hint.length() > 0) {
            this.setKbHint("(" + hint.substring(1) + ")");
        }
        return this;
    }

    public void resetKeyBinds() {
        this.bindedKeyCodes = new int[0];
        this.setKbHint(null);
    }

    public int[] getBindedKeyCodes() {
        return this.bindedKeyCodes;
    }

    public void paint(Graphics g, int x0, int y0, int w, int h, boolean isSelected, boolean isFocused, boolean drawAsInactive, boolean kbHintVisible) {
        this.paint(g, x0, y0, w, h, x0, y0, w, h, isSelected, isFocused, drawAsInactive, kbHintVisible);
    }

    public void paint(Graphics g, int x0, int y0, int w, int h, int clipX, int clipY, int clipW, int clipH, boolean isSelected, boolean isFocused, boolean drawAsInactive, boolean kbHintVisible) {
        int prevClipX = g.getClipX();
        int prevClipY = g.getClipY();
        int prevClipW = g.getClipWidth();
        int prevClipH = g.getClipHeight();
        x0 += this.bgPadding;
        clipX += this.bgPadding;
        y0 += this.bgPadding;
        clipW -= this.bgPadding * 2;
        if ((w -= this.bgPadding * 2) <= 0 || (h -= this.bgPadding * 2) <= 0) {
            return;
        }
        int clipX2 = clipX + clipW;
        int clipY2 = clipY + clipH;
        clipX = Math.max(clipX, prevClipX);
        clipY = Math.max(clipY, prevClipY);
        clipX2 = Math.min(clipX2, prevClipX + prevClipW);
        clipY2 = Math.min(clipY2, prevClipY + prevClipH);
        clipW = Math.max(0, clipX2 - clipX);
        clipH = Math.max(0, clipY2 - clipY);
        g.setClip(clipX, clipY, clipW, clipH);
        this.drawBg(g, clipX, clipY, clipW, clipH, isSelected, drawAsInactive);
        this.drawText(g, this.text, x0, y0, w, h, isSelected, isFocused, drawAsInactive, kbHintVisible);
        this.drawSelectionMark(g, clipX, clipY, clipW, clipH, isSelected, isFocused, drawAsInactive);
        g.setClip(prevClipX, prevClipY, prevClipW, prevClipH);
    }

    protected void drawSelectionMark(Graphics g, int x0, int y0, int w, int h, boolean isSelected, boolean isFocused, boolean forceInactive) {
        if (isSelected) {
            g.setColor(this.getCurrentFontColor(forceInactive));
            int markY0 = h / 3;
            int markY1 = h - markY0;
            int markCenterY = (markY0 + markY1) / 2;
            int markw = (markY1 - markY0) / 2;
            g.fillTriangle(x0 + 1, y0 + markY0, x0 + 1, y0 + markY1, x0 + markw, y0 + markCenterY);
            g.fillTriangle(x0 + w - 1, y0 + markY0, x0 + w - 1, y0 + markY1, x0 + w - markw, y0 + markCenterY);
        }
    }

    protected void drawText(Graphics g, String text, int x0, int y0, int w, int h, boolean isSelected, boolean isFocused, boolean forceInactive, boolean showKbHints) {
        int[][] lineBounds;
        Font prevFont = g.getFont();
        this.setFont(Font.getDefaultFontSize());
        if (showKbHints) {
            text = text + this.kbHint;
        }
        if (h / (lineBounds = this.getLineBounds(text, this.font, w, this.bgPadding, showKbHints)).length < this.font.getHeight()) {
            this.setFont(0);
            lineBounds = this.getLineBounds(text, this.font, w, this.bgPadding, showKbHints);
            if (h / lineBounds.length < this.font.getHeight()) {
                this.setFont(8);
                lineBounds = this.getLineBounds(text, this.font, w, this.bgPadding, showKbHints);
            }
        }
        this.setFont(this.font.getSize(), g);
        g.setColor(this.getCurrentFontColor(forceInactive));
        int offset = 0;
        int step = this.font.getHeight() * 3 / 2;
        if (step * lineBounds.length > h - this.bgPadding * 2) {
            step = h / lineBounds.length;
        }
        offset += (h - step * (lineBounds.length - 1) - this.font.getHeight()) / 2;
        for (int i = 0; i < lineBounds.length; ++i) {
            int[] bounds = lineBounds[i];
            g.drawSubstring(text, bounds[0], bounds[1], x0 + w / 2, y0 + offset, 17);
            offset += step;
        }
        g.setFont(prevFont);
    }

    protected void drawBg(Graphics g, int x0, int y0, int w, int h, boolean isSelected, boolean forceInactive) {
        int r = Math.min(w / 5, h / 5);
        int bgColor = this.isActive && !forceInactive ? (!isSelected ? this.bgColor : this.selectedBgColor) : this.bgColorInactive;
        if (bgColor > 0) {
            g.setColor(bgColor);
            g.fillRoundRect(x0, y0, w, h, r, r);
        }
    }

    protected int getCurrentFontColor(boolean forceInactive) {
        if (this.isActive && !forceInactive) {
            return this.fontColor;
        }
        return this.fontColorInactive;
    }

    private int[][] getLineBounds(String text, Font font, int w, int padding, boolean kbHintVisible) {
        if (this.lineBounds != null && w == this.prevW && font.getSize() == this.prevGetLineBoundsFont.getSize() && kbHintVisible == this.wasKbHintVisible) {
            return this.lineBounds;
        }
        this.prevW = w;
        this.lineBounds = font.getLineBounds(text, w, padding);
        this.prevGetLineBoundsFont = font;
        return this.lineBounds;
    }

    public int getMinPossibleWidth() {
        int w = 0;
        String[] words = Utils.split(this.text, " ");
        for (int i = 0; i < words.length; ++i) {
            w = Math.max(w, this.font.stringWidth(words[i]));
        }
        return w;
    }

    public abstract void buttonPressed();

    public void buttonPressedSelected() {
        this.buttonPressed();
    }
}

