/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.Utils;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.AbstractButtonSet;
import mobileapplication3.ui.AnimationThread;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonStub;
import mobileapplication3.ui.IUIComponent;

public class ButtonCol
extends AbstractButtonSet {
    private AnimationThread animationThread = null;
    private int btnH = -1;
    private boolean isScrollable = true;
    private boolean trimHeight = true;
    private int hBeforeTrim;
    private int btnHBeforeAuto = this.btnH;
    private int prevTotalBtnsH;
    private int scrollOffset = 0;
    private int pointerPressedY;
    private int scrollOffsetWhenPressed;
    protected int lastDraggedY;
    protected int lastDraggedDY;
    protected int draggedAvgDY;
    protected long lastDraggedT;
    protected int lastDraggedDT;
    protected int draggedAvgDT;
    private boolean startFromBottom = false;
    private boolean kbSmoothScrolling = true;
    private boolean kineticTouchScrolling = true;

    public ButtonCol() {
        this.setIsSelectionEnabled(true);
    }

    public ButtonCol(Button[] buttons) {
        this();
        this.buttons = buttons;
    }

    @Override
    public void init() {
        try {
            this.kbSmoothScrolling = this.getUISettings().getKbSmoothScrollingEnabled();
            this.kineticTouchScrolling = this.getUISettings().getKineticTouchScrollingEnabled();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.init();
    }

    @Override
    public void recalcSize() {
        this.setSizes(this.w, this.hBeforeTrim, this.btnHBeforeAuto, this.trimHeight);
    }

    @Override
    public IUIComponent setSize(int w, int h) {
        return this.setSizes(w, h, this.btnHBeforeAuto);
    }

    public IUIComponent setSizes(int w, int h, int btnH) {
        return this.setSizes(w, h, btnH, this.trimHeight);
    }

    public IUIComponent setSizes(int w, int h, int btnH, boolean trimHeight) {
        if (w == 0 || h == 0 || btnH == 0) {
            try {
                throw new Exception("Setting zero as a dimension " + this.getClass().getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return this;
            }
        }
        int prevH = this.h;
        super.setSize(w, h);
        this.hBeforeTrim = this.h;
        this.btnHBeforeAuto = btnH;
        this.btnH = btnH;
        this.trimHeight = trimHeight;
        if (this.buttons == null) {
            return this;
        }
        if (this.w == -1) {
            this.w = this.getMinPossibleWidth();
        }
        if (this.btnH == -1) {
            this.btnH = Font.getDefaultFont().getHeight() * 5 / 2 + this.buttonsBgPadding * 2;
            if (this.h != -1 && !this.trimHeight && this.buttons.length > 0) {
                this.btnH = Math.max(this.btnH, this.h / this.buttons.length);
            }
        } else {
            this.h = Math.min(this.h, this.btnH * this.buttons.length);
        }
        if (this.h == -1) {
            this.h = this.buttons.length * this.btnH;
        }
        if (this.trimHeight) {
            this.h = Math.min(this.h, this.btnH * this.buttons.length);
        }
        if (this.startFromBottom) {
            int dtbh = this.getTotalBtnsH() - this.prevTotalBtnsH;
            int dh = this.h - prevH;
            this.prevTotalBtnsH = this.getTotalBtnsH();
            this.scrollOffset += dtbh - dh;
            this.setSelected(this.buttons.length - 1);
        }
        this.scrollOffsetWhenPressed = this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.getTotalBtnsH() - this.h));
        this.recalcPos();
        return this;
    }

    @Override
    public int getMinPossibleWidth() {
        int res = 0;
        for (int i = 0; i < this.buttons.length; ++i) {
            String[] btnTextLines = Utils.split(this.buttons[i].getTitle(), "\n");
            for (int j = 0; j < btnTextLines.length; ++j) {
                res = Math.max(res, Font.getDefaultFont().stringWidth(btnTextLines[j] + "  ") + this.buttons[i].getBgPagging() * 4);
            }
        }
        return res;
    }

    public int getBtnH() {
        return this.btnH;
    }

    public int getTotalBtnsH() {
        if (this.buttons == null) {
            return 0;
        }
        return this.buttons.length * this.getBtnH();
    }

    @Override
    public boolean handleMouseEvent(int event, int x, int y) {
        int scrollOffset = this.scrollOffset;
        if (event == 7) {
            scrollOffset += this.h / 5;
        } else if (event == -7) {
            scrollOffset -= this.h / 5;
        } else {
            return false;
        }
        if (this.kbSmoothScrolling && scrollOffset != this.scrollOffset) {
            this.initAnimationThread();
            this.animationThread.animate(0, this.scrollOffset, 0, scrollOffset, 200, 0, 0, 0, this.btnH * this.buttons.length - this.h);
        } else {
            this.scrollOffset = Math.max(0, Math.min(scrollOffset, this.getTotalBtnsH() - this.h));
        }
        return true;
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        if (!this.isVisible) {
            return false;
        }
        if (this.buttons == null || this.buttons.length == 0) {
            return false;
        }
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        this.prevSelected = this.selected;
        x -= this.x0;
        this.setSelected((y -= this.y0 - this.scrollOffset) / this.btnH);
        boolean wasSelected = this.selected == this.prevSelected && this.isSelectionEnabled;
        return this.buttons[this.selected].invokePressed(wasSelected, this.isFocused);
    }

    @Override
    protected boolean handlePointerReleased(int x, int y) {
        int startY = this.scrollOffset;
        int targetY = this.scrollOffset;
        int dY = this.draggedAvgDT > 0 ? this.draggedAvgDY * this.draggedAvgDY * 350 / this.draggedAvgDT / this.draggedAvgDT : 0;
        int topLimitY = 0;
        int bottomLimitY = this.getTotalBtnsH() - this.h;
        if (this.kineticTouchScrolling && (targetY -= dY * Mathh.sign(this.draggedAvgDY)) != startY) {
            this.initAnimationThread();
            int t = Math.min(2000, Math.abs(2 * dY * this.draggedAvgDT / this.draggedAvgDY));
            this.animationThread.animate(0, startY, 0, targetY, t, 0, 0, topLimitY, bottomLimitY, this.draggedAvgDT);
        }
        return true;
    }

    @Override
    public boolean handlePointerPressed(int x, int y) {
        this.stopAnimation();
        if (!this.isVisible) {
            return false;
        }
        if (this.buttons == null || this.buttons.length == 0) {
            return false;
        }
        if (this.btnH * this.buttons.length <= this.h) {
            // empty if block
        }
        if (!this.checkTouchEvent(x, y)) {
            this.pointerPressedY = -1;
            return false;
        }
        this.pointerPressedY = y;
        this.scrollOffsetWhenPressed = this.scrollOffset;
        this.lastDraggedY = y;
        this.lastDraggedT = System.currentTimeMillis();
        this.draggedAvgDY = 0;
        this.draggedAvgDT = 0;
        return true;
    }

    @Override
    public boolean handlePointerDragged(int x, int y) {
        if (!this.isVisible) {
            return false;
        }
        if (this.buttons == null || this.buttons.length == 0) {
            return false;
        }
        if (!this.isScrollable) {
            return false;
        }
        if (this.btnH * this.buttons.length <= this.h) {
            // empty if block
        }
        this.scrollOffset = this.scrollOffsetWhenPressed - (y - this.pointerPressedY);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.getTotalBtnsH() - this.h));
        this.lastDraggedDY = y - this.lastDraggedY;
        this.lastDraggedY = y;
        this.lastDraggedDT = (int)(System.currentTimeMillis() - this.lastDraggedT);
        this.lastDraggedT = System.currentTimeMillis();
        this.draggedAvgDY = this.draggedAvgDY == 0 ? this.lastDraggedDY : (2 * this.draggedAvgDY + 2 * this.lastDraggedDY + 1) / 4;
        this.draggedAvgDT = this.draggedAvgDT == 0 ? this.lastDraggedDT : (2 * this.draggedAvgDT + 2 * this.lastDraggedDT + 1) / 4;
        return true;
    }

    @Override
    public boolean onKeyPressed(int keyCode, int count) {
        if (!this.isVisible) {
            return false;
        }
        if (!this.isSelectionEnabled) {
            return false;
        }
        if (this.buttons == null || this.buttons.length == 0) {
            return false;
        }
        boolean ret = false;
        int action = RootContainer.getAction(keyCode);
        do {
            switch (action) {
                case 1: {
                    if (this.selected > 0) {
                        this.setSelected(this.selected - 1);
                    } else {
                        this.setSelected(this.buttons.length - 1);
                    }
                    ret = true;
                    break;
                }
                case 6: {
                    if (this.selected < this.buttons.length - 1) {
                        this.setSelected(this.selected + 1);
                    } else {
                        this.setSelected(0);
                    }
                    ret = true;
                    break;
                }
                case 8: {
                    if (this.isSelectionEnabled) {
                        this.isSelectionVisible = true;
                    }
                    return this.buttons[this.selected].invokePressed(true, this.isFocused);
                }
            }
        } while (this.buttons[this.selected] instanceof ButtonStub && action != 8);
        if (this.isSelectionEnabled) {
            this.isSelectionVisible = true;
        }
        return ret;
    }

    @Override
    public AbstractButtonSet setSelected(int selected) {
        int selectedY = this.btnH * selected;
        int startY = this.scrollOffset;
        int targetY = this.scrollOffset;
        int topLimitY = 0;
        int bottomLimitY = this.btnH * this.buttons.length - this.h;
        if (this.btnH * 2 < this.h) {
            if (selectedY < this.scrollOffset) {
                targetY = Math.max(topLimitY, selectedY - this.btnH * 3 / 4);
            }
            if (selectedY + this.btnH > this.scrollOffset + this.h) {
                targetY = Math.min(bottomLimitY, selectedY - this.h + this.btnH + this.btnH * 3 / 4);
            }
        } else {
            targetY = selectedY - this.h / 2 + this.btnH / 2;
        }
        if (this.kbSmoothScrolling && targetY != startY) {
            this.initAnimationThread();
            this.animationThread.animate(0, startY, 0, targetY, 200, 0, 0, topLimitY, bottomLimitY);
        } else {
            this.scrollOffset = targetY;
        }
        return super.setSelected(selected);
    }

    public ButtonCol enableScrolling(boolean isScrollable, boolean startFromBottom) {
        this.startFromBottom = startFromBottom;
        if (isScrollable) {
            this.setIsSelectionEnabled(true);
        }
        this.isScrollable = isScrollable;
        return this;
    }

    public ButtonCol enableAnimations(boolean b) {
        this.kbSmoothScrolling = b;
        return this;
    }

    public ButtonCol trimHeight(boolean b) {
        this.trimHeight = b;
        return this;
    }

    @Override
    public void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (this.buttons == null || this.buttons.length == 0) {
            return;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            int prevFontFace = g.getFontFace();
            int prevFontStyle = g.getFontStyle();
            int prevFontSize = g.getFontSize();
            int btnY = y0 - this.scrollOffset + i * this.btnH;
            if (btnY + this.btnH < y0) continue;
            if (btnY > y0 + h) break;
            boolean drawAsSelected = i == this.selected && this.isSelectionVisible && this.isFocused;
            this.buttons[i].paint(g, x0, btnY, w, this.btnH, x0, btnY, w, this.btnH, drawAsSelected, this.isFocused, forceInactive, this.showKbHints);
            g.setFont(prevFontFace, prevFontStyle, prevFontSize);
        }
        if (this.isSelectionEnabled && h < this.getTotalBtnsH()) {
            g.setColor(0xFFFFFF);
            int scrollBarMarkY0 = h * this.scrollOffset / this.getTotalBtnsH();
            int scrollBarMarkY1 = h * (this.scrollOffset + h) / this.getTotalBtnsH();
            g.drawLine(x0 + w - 1, y0 + scrollBarMarkY0, x0 + w - 1, y0 + scrollBarMarkY1);
        }
    }

    private void initAnimationThread() {
        if (this.animationThread == null) {
            this.animationThread = new AnimationThread(new AnimationThread.AnimationWorker(){

                @Override
                public void onStep(int newX, int newY) {
                    ButtonCol.this.scrollOffset = newY;
                    ButtonCol.this.repaint();
                }
            });
        }
    }

    private void stopAnimation() {
        if (this.animationThread != null) {
            this.animationThread.stop();
        }
    }
}

