/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.Utils;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.AbstractButtonSet;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.IUIComponent;

public class ButtonComponent
extends AbstractButtonSet {
    public ButtonComponent(Button button) {
        this.buttons = new Button[]{button};
    }

    @Override
    public int getMinPossibleWidth() {
        int res = 0;
        String[] btnTextLines = Utils.split(this.buttons[0].getTitle(), "\n");
        for (int j = 0; j < btnTextLines.length; ++j) {
            res = Math.max(res, Font.getDefaultFont().stringWidth(btnTextLines[j] + "  ") + this.buttons[0].getBgPagging() * 4);
        }
        return res;
    }

    @Override
    public void onSetBounds(int x0, int y0, int w, int h) {
        if (w == -1) {
            this.w = this.getMinPossibleWidth();
        }
        if (h == -1) {
            this.h = Font.getDefaultFont().getHeight() * 5 / 2 + this.buttonsBgPadding;
        }
    }

    @Override
    public void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        boolean drawAsSelected = this.isSelectionVisible && this.isFocused;
        this.buttons[0].paint(g, x0, y0, w, h, drawAsSelected, this.isFocused, forceInactive, this.showKbHints);
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        if (this.checkTouchEvent(x, y)) {
            this.buttons[0].invokePressed(true, this.isSelectionEnabled);
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyPressed(int keyCode, int count) {
        if (this.isSelectionEnabled && RootContainer.getAction(keyCode) == 8) {
            this.buttons[0].invokePressed(true, true);
            return true;
        }
        return this.isFocused;
    }

    @Override
    public boolean handleKeyRepeated(int keyCode, int pressedCount) {
        return false;
    }

    @Override
    public IUIComponent setBgColor(int color) {
        this.buttons[0].setBgColor(color);
        return this;
    }

    public ButtonComponent setBindedKeyCode(int keyCode) {
        this.buttons[0].setBindedKeyCode(keyCode);
        return this;
    }

    public ButtonComponent setBindedKeyCodes(int[] keyCodes) {
        this.buttons[0].setBindedKeyCodes(keyCodes);
        return this;
    }
}

