/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.AbstractButtonSet;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonRow;
import mobileapplication3.ui.IUIComponent;

public class ButtonPanelHorizontal
extends AbstractButtonSet {
    public static final int H_AUTO = -1;
    private int rows;
    private int btnH;
    private ButtonRow[] buttonRows = new ButtonRow[0];
    private int btnsInRow;
    private int selectedRow;

    public ButtonPanelHorizontal(Button[] buttons) {
        this.setButtons(buttons);
    }

    @Override
    public AbstractButtonSet setButtons(Button[] buttons) {
        this.buttons = buttons;
        this.initRows();
        return super.setButtons(buttons);
    }

    private void initRows() {
        if (this.buttons == null) {
            return;
        }
        this.buttonRows = new ButtonRow[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            Button[] row = new Button[Math.min(this.buttons.length - i * this.btnsInRow, this.btnsInRow)];
            System.arraycopy(this.buttons, i * this.btnsInRow, row, 0, row.length);
            this.buttonRows[i] = new ButtonRow(row);
        }
        super.setButtons(this.buttons);
    }

    public IUIComponent setSizes(int w, int h, int btnH) {
        return this.setSizes(w, h, btnH, false);
    }

    public IUIComponent setSizes(int w, int h, int btnH, boolean trimHeight) {
        if (this.buttons == null) {
            return this;
        }
        this.w = w;
        this.h = h;
        this.btnH = btnH;
        if (this.btnH == -1) {
            this.btnH = this.h == -1 || trimHeight ? Font.getDefaultFont().getHeight() * 5 / 2 : this.h / this.rows;
            if (trimHeight) {
                this.h = Math.min(this.h, this.btnH * this.rows);
            }
        } else {
            this.h = Math.min(this.h, this.btnH * this.rows);
        }
        if (h == -1) {
            this.h = this.rows * this.btnH;
        }
        this.setPos(this.x0, this.y0, this.anchor);
        return super.setSize(this.w, this.h);
    }

    @Override
    public void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        int btnH = h / this.rows;
        for (int i = 0; i < this.rows; ++i) {
            this.buttonRows[i].paint(g, x0, y0 + btnH * i, w, btnH, forceInactive);
        }
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        for (int i = 0; i < this.buttonRows.length; ++i) {
            if (!this.buttonRows[i].handlePointerClicked(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyPressed(int keyCode, int count) {
        int i;
        if (keyCode >= 49 && keyCode <= 57 && (i = keyCode - 49) < this.buttons.length) {
            this.setIsSelectionVisible(true);
            this.selected = i;
            this.buttons[this.selected].invokePressed(false, false);
            return true;
        }
        if (!this.isVisible) {
            return false;
        }
        this.setIsSelectionVisible(true);
        switch (keyCode) {
            default: 
        }
        switch (RootContainer.getAction(keyCode)) {
            case 2: {
                if (this.selected > 0) {
                    --this.selected;
                    break;
                }
                this.selected = this.buttons.length - 1;
                break;
            }
            case 5: {
                if (this.selected < this.buttons.length - 1) {
                    ++this.selected;
                    break;
                }
                this.selected = 0;
                break;
            }
            case 1: {
                this.selected -= this.btnsInRow;
                if (this.selected >= 0) break;
                this.selected += this.buttons.length;
                break;
            }
            case 6: {
                this.selected += this.btnsInRow;
                if (this.selected <= this.buttons.length - 1) break;
                this.selected += this.buttons.length;
                break;
            }
            case 8: {
                if (this.isSelectionEnabled) {
                    this.isSelectionVisible = true;
                }
                return this.buttons[this.selected].invokePressed(true, this.isFocused);
            }
            default: {
                return this.isFocused;
            }
        }
        this.selected = Mathh.constrain(0, this.selected, this.buttons.length - 1);
        this.buttonRows[this.selectedRow].setIsSelectionVisible(false);
        this.selectedRow = Mathh.constrain(0, this.selected / this.btnsInRow, this.rows - 1);
        this.buttonRows[this.selectedRow].setIsSelectionVisible(true);
        this.buttonRows[this.selectedRow].setSelected(this.selected % this.btnsInRow);
        if (this.isSelectionEnabled) {
            this.isSelectionVisible = true;
        }
        return true;
    }

    public ButtonPanelHorizontal setBtnsInRowCount(int btnsInRow) {
        this.btnsInRow = btnsInRow;
        int buttonsNumber = this.buttons.length;
        this.rows = buttonsNumber % btnsInRow > 0 ? buttonsNumber / btnsInRow + 1 : buttonsNumber / btnsInRow;
        if (this.isSizeSet()) {
            this.setSize(this.w, this.btnH * this.rows);
        }
        return this;
    }

    @Override
    public AbstractButtonSet setIsSelectionVisible(boolean isSelectionVisible) {
        if (this.buttonRows != null && this.buttonRows.length > this.selectedRow && this.buttonRows[this.selectedRow] != null) {
            this.buttonRows[this.selectedRow].setIsSelectionVisible(isSelectionVisible);
        }
        return super.setIsSelectionVisible(isSelectionVisible);
    }

    @Override
    public AbstractButtonSet setIsSelectionEnabled(boolean selectionEnabled) {
        super.setIsSelectionEnabled(selectionEnabled);
        for (int i = 0; i < this.buttonRows.length; ++i) {
            this.buttonRows[i].setIsSelectionEnabled(selectionEnabled);
        }
        return this;
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        this.initRows();
        for (int i = 0; i < this.rows; ++i) {
            this.buttonRows[i].setSize(this.w, this.btnH).setPos(this.x0, this.y0 + this.btnH * i, 20);
        }
    }

    @Override
    public int getMinPossibleWidth() {
        int ret = 0;
        for (int i = 0; i < this.buttonRows.length; ++i) {
            int rowW = 0;
            for (int j = 0; j < this.buttonRows[i].buttons.length; ++j) {
                rowW += this.buttonRows[i].buttons[i].getMinPossibleWidth();
            }
            ret = Math.max(ret, rowW);
        }
        return ret;
    }
}

